/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.board;

import com.jamesswafford.chess4j.board.Bitboard;
import com.jamesswafford.chess4j.board.Board;
import com.jamesswafford.chess4j.board.squares.Direction;
import com.jamesswafford.chess4j.board.squares.East;
import com.jamesswafford.chess4j.board.squares.File;
import com.jamesswafford.chess4j.board.squares.North;
import com.jamesswafford.chess4j.board.squares.NorthEast;
import com.jamesswafford.chess4j.board.squares.NorthWest;
import com.jamesswafford.chess4j.board.squares.Rank;
import com.jamesswafford.chess4j.board.squares.South;
import com.jamesswafford.chess4j.board.squares.SouthEast;
import com.jamesswafford.chess4j.board.squares.SouthWest;
import com.jamesswafford.chess4j.board.squares.Square;
import com.jamesswafford.chess4j.board.squares.West;
import com.jamesswafford.chess4j.utils.BoardUtils;
import java.util.Random;

public class Magic {
    private static long[] rookMasks;
    private static long[][] rookOcc;
    private static long[][] rookAttacks;
    private static long[] magicNumbersRooks;
    private static long[] magicNumbersShiftRooks;
    private static long[][] magicRookMoves;
    private static long[] bishopMasks;
    private static long[][] bishopOcc;
    private static long[][] bishopAttacks;
    private static long[] magicNumbersBishops;
    private static long[] magicNumbersShiftBishops;
    private static long[][] magicBishopMoves;

    private static long genMovesMask(Square sq, long occupied, Direction direction) {
        long mask = 0L;
        Square to = direction.next(sq);
        while (to != null) {
            mask |= Bitboard.squares[to.value()];
            if ((Bitboard.squares[to.value()] & occupied) != 0L) break;
            to = direction.next(to);
        }
        return mask;
    }

    public static long getBishopMoves(Board board, int fromSq, long targets) {
        long blockers = (board.getBlackPieces() | board.getWhitePieces()) & bishopMasks[fromSq];
        int magicInd = (int)(blockers * magicNumbersBishops[fromSq] >>> (int)magicNumbersShiftBishops[fromSq]);
        return magicBishopMoves[fromSq][magicInd] & targets;
    }

    public static long getQueenMoves(Board board, int fromSq, long targets) {
        return Magic.getBishopMoves(board, fromSq, targets) | Magic.getRookMoves(board, fromSq, targets);
    }

    public static long getRookMoves(Board board, int fromSq, long targets) {
        long blockers = (board.getBlackPieces() | board.getWhitePieces()) & rookMasks[fromSq];
        int magicInd = (int)(blockers * magicNumbersRooks[fromSq] >>> (int)magicNumbersShiftRooks[fromSq]);
        return magicRookMoves[fromSq][magicInd] & targets;
    }

    static {
        int i;
        int numVariations;
        int sqVal;
        long attackSet;
        int index;
        long occupied;
        int i2;
        boolean fail;
        Random r;
        long[] usedBy;
        boolean[] isUsed;
        long magicShift;
        int numVariations2;
        Square toSq;
        int index2;
        int i3;
        int sq;
        rookMasks = new long[64];
        rookOcc = new long[64][4096];
        rookAttacks = new long[64][4096];
        magicNumbersRooks = new long[64];
        magicNumbersShiftRooks = new long[64];
        magicRookMoves = new long[64][4096];
        bishopMasks = new long[64];
        bishopOcc = new long[64][1024];
        bishopAttacks = new long[64][1024];
        magicNumbersBishops = new long[64];
        magicNumbersShiftBishops = new long[64];
        magicBishopMoves = new long[64][1024];
        for (int i4 = 0; i4 < 64; ++i4) {
            Magic.rookMasks[i4] = 0L;
            Square sq2 = Square.valueOf(i4);
            for (int j = 0; j < 64; ++j) {
                Square sq22 = Square.valueOf(j);
                if (i4 == j) continue;
                if (sq22.rank() == sq2.rank() && sq22.file() != File.FILE_A && sq22.file() != File.FILE_H || sq22.file() == sq2.file() && sq22.rank() != Rank.RANK_1 && sq22.rank() != Rank.RANK_8) {
                    int n = i4;
                    rookMasks[n] = rookMasks[n] | Bitboard.squares[j];
                }
                if (!BoardUtils.isDiagonal(sq2, sq22) || sq22.rank() == Rank.RANK_1 || sq22.rank() == Rank.RANK_8 || sq22.file() == File.FILE_A || sq22.file() == File.FILE_H) continue;
                int n = i4;
                bishopMasks[n] = bishopMasks[n] | Bitboard.squares[j];
            }
        }
        for (sq = 0; sq < 64; ++sq) {
            long mask = rookMasks[sq];
            int numVariations3 = 1 << Long.bitCount(mask);
            block3: for (i3 = 0; i3 < numVariations3; ++i3) {
                int indexBit;
                Magic.rookAttacks[sq][i3] = 0L;
                Magic.rookOcc[sq][i3] = 0L;
                for (index2 = i3; index2 != 0; index2 ^= 1 << indexBit) {
                    indexBit = Bitboard.lsb(index2);
                    long[] lArray = rookOcc[sq];
                    int n = i3;
                    lArray[n] = lArray[n] | Bitboard.isolateLSB(mask, indexBit);
                }
                for (int j = 0; j < i3; ++j) {
                    assert (rookOcc[sq][i3] != rookOcc[sq][j]);
                }
                toSq = North.getInstance().next(Square.valueOf(sq));
                while (toSq != null) {
                    if ((rookOcc[sq][i3] & Bitboard.squares[toSq.value()]) != 0L) {
                        long[] lArray = rookAttacks[sq];
                        int n = i3;
                        lArray[n] = lArray[n] | Bitboard.squares[toSq.value()];
                        break;
                    }
                    toSq = North.getInstance().next(toSq);
                }
                toSq = South.getInstance().next(Square.valueOf(sq));
                while (toSq != null) {
                    if ((rookOcc[sq][i3] & Bitboard.squares[toSq.value()]) != 0L) {
                        long[] lArray = rookAttacks[sq];
                        int n = i3;
                        lArray[n] = lArray[n] | Bitboard.squares[toSq.value()];
                        break;
                    }
                    toSq = South.getInstance().next(toSq);
                }
                toSq = East.getInstance().next(Square.valueOf(sq));
                while (toSq != null) {
                    if ((rookOcc[sq][i3] & Bitboard.squares[toSq.value()]) != 0L) {
                        long[] lArray = rookAttacks[sq];
                        int n = i3;
                        lArray[n] = lArray[n] | Bitboard.squares[toSq.value()];
                        break;
                    }
                    toSq = East.getInstance().next(toSq);
                }
                toSq = West.getInstance().next(Square.valueOf(sq));
                while (toSq != null) {
                    if ((rookOcc[sq][i3] & Bitboard.squares[toSq.value()]) != 0L) {
                        long[] lArray = rookAttacks[sq];
                        int n = i3;
                        lArray[n] = lArray[n] | Bitboard.squares[toSq.value()];
                        continue block3;
                    }
                    toSq = West.getInstance().next(toSq);
                }
            }
        }
        for (sq = 0; sq < 64; ++sq) {
            long mask = bishopMasks[sq];
            int numVariations4 = 1 << Long.bitCount(mask);
            block11: for (i3 = 0; i3 < numVariations4; ++i3) {
                int indexBit;
                Magic.bishopAttacks[sq][i3] = 0L;
                Magic.bishopOcc[sq][i3] = 0L;
                for (index2 = i3; index2 != 0; index2 ^= 1 << indexBit) {
                    indexBit = Bitboard.lsb(index2);
                    long[] lArray = bishopOcc[sq];
                    int n = i3;
                    lArray[n] = lArray[n] | Bitboard.isolateLSB(mask, indexBit);
                }
                for (int j = 0; j < i3; ++j) {
                    assert (bishopOcc[sq][i3] != bishopOcc[sq][j]);
                }
                toSq = NorthEast.getInstance().next(Square.valueOf(sq));
                while (toSq != null) {
                    if ((bishopOcc[sq][i3] & Bitboard.squares[toSq.value()]) != 0L) {
                        long[] lArray = bishopAttacks[sq];
                        int n = i3;
                        lArray[n] = lArray[n] | Bitboard.squares[toSq.value()];
                        break;
                    }
                    toSq = NorthEast.getInstance().next(toSq);
                }
                toSq = SouthEast.getInstance().next(Square.valueOf(sq));
                while (toSq != null) {
                    if ((bishopOcc[sq][i3] & Bitboard.squares[toSq.value()]) != 0L) {
                        long[] lArray = bishopAttacks[sq];
                        int n = i3;
                        lArray[n] = lArray[n] | Bitboard.squares[toSq.value()];
                        break;
                    }
                    toSq = SouthEast.getInstance().next(toSq);
                }
                toSq = SouthWest.getInstance().next(Square.valueOf(sq));
                while (toSq != null) {
                    if ((bishopOcc[sq][i3] & Bitboard.squares[toSq.value()]) != 0L) {
                        long[] lArray = bishopAttacks[sq];
                        int n = i3;
                        lArray[n] = lArray[n] | Bitboard.squares[toSq.value()];
                        break;
                    }
                    toSq = SouthWest.getInstance().next(toSq);
                }
                toSq = NorthWest.getInstance().next(Square.valueOf(sq));
                while (toSq != null) {
                    if ((bishopOcc[sq][i3] & Bitboard.squares[toSq.value()]) != 0L) {
                        long[] lArray = bishopAttacks[sq];
                        int n = i3;
                        lArray[n] = lArray[n] | Bitboard.squares[toSq.value()];
                        continue block11;
                    }
                    toSq = NorthWest.getInstance().next(toSq);
                }
            }
        }
        for (sq = 0; sq < 64; ++sq) {
            long magic;
            long mask = rookMasks[sq];
            long numMaskBits = Long.bitCount(mask);
            numVariations2 = 1 << (int)numMaskBits;
            magicShift = 64L - numMaskBits;
            isUsed = new boolean[4096];
            usedBy = new long[4096];
            r = new Random();
            block19: do {
                magic = r.nextLong() & r.nextLong() & r.nextLong();
                for (i2 = 0; i2 < numVariations2; ++i2) {
                    isUsed[i2] = false;
                }
                fail = false;
                for (i2 = 0; i2 < numVariations2; ++i2) {
                    occupied = rookOcc[sq][i2];
                    index = (int)(occupied * magic >>> (int)magicShift);
                    assert (index <= 1 << (int)numMaskBits && index <= 4096);
                    attackSet = rookAttacks[sq][i2];
                    boolean bl = fail = isUsed[index] && usedBy[index] != attackSet;
                    if (fail) continue block19;
                    isUsed[index] = true;
                    usedBy[index] = attackSet;
                }
            } while (fail);
            Magic.magicNumbersRooks[sq] = magic;
            Magic.magicNumbersShiftRooks[sq] = magicShift;
        }
        for (sq = 0; sq < 64; ++sq) {
            long magic;
            long mask = bishopMasks[sq];
            long numMaskBits = Long.bitCount(mask);
            numVariations2 = 1 << (int)numMaskBits;
            magicShift = 64L - numMaskBits;
            isUsed = new boolean[1024];
            usedBy = new long[1024];
            r = new Random();
            block23: do {
                magic = r.nextLong() & r.nextLong() & r.nextLong();
                for (i2 = 0; i2 < numVariations2; ++i2) {
                    isUsed[i2] = false;
                }
                fail = false;
                for (i2 = 0; i2 < numVariations2; ++i2) {
                    occupied = bishopOcc[sq][i2];
                    index = (int)(occupied * magic >>> (int)magicShift);
                    assert (index <= 1 << (int)numMaskBits && index <= 1024);
                    attackSet = bishopAttacks[sq][i2];
                    boolean bl = fail = isUsed[index] && usedBy[index] != attackSet;
                    if (fail) continue block23;
                    isUsed[index] = true;
                    usedBy[index] = attackSet;
                }
            } while (fail);
            Magic.magicNumbersBishops[sq] = magic;
            Magic.magicNumbersShiftBishops[sq] = magicShift;
        }
        for (sqVal = 0; sqVal < 64; ++sqVal) {
            Square sq3 = Square.valueOf(sqVal);
            long mask = rookMasks[sqVal];
            numVariations = 1 << Long.bitCount(mask);
            for (i = 0; i < numVariations; ++i) {
                int magicInd = (int)(rookOcc[sqVal][i] * magicNumbersRooks[sqVal] >>> (int)magicNumbersShiftRooks[sqVal]);
                Magic.magicRookMoves[sqVal][magicInd] = Magic.genMovesMask(sq3, rookOcc[sqVal][i], North.getInstance()) | Magic.genMovesMask(sq3, rookOcc[sqVal][i], South.getInstance()) | Magic.genMovesMask(sq3, rookOcc[sqVal][i], East.getInstance()) | Magic.genMovesMask(sq3, rookOcc[sqVal][i], West.getInstance());
            }
        }
        for (sqVal = 0; sqVal < 64; ++sqVal) {
            Square sq4 = Square.valueOf(sqVal);
            long mask = bishopMasks[sqVal];
            numVariations = 1 << Long.bitCount(mask);
            for (i = 0; i < numVariations; ++i) {
                int magicInd = (int)(bishopOcc[sqVal][i] * magicNumbersBishops[sqVal] >>> (int)magicNumbersShiftBishops[sqVal]);
                Magic.magicBishopMoves[sqVal][magicInd] = Magic.genMovesMask(sq4, bishopOcc[sqVal][i], NorthEast.getInstance()) | Magic.genMovesMask(sq4, bishopOcc[sqVal][i], SouthEast.getInstance()) | Magic.genMovesMask(sq4, bishopOcc[sqVal][i], SouthWest.getInstance()) | Magic.genMovesMask(sq4, bishopOcc[sqVal][i], NorthWest.getInstance());
            }
        }
    }
}

