/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.parts;

import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.PlayerSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridAccessException;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.common.parts.PartFluidStorageMonitor;
import com.glodblock.github.util.Util;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.apache.commons.lang3.tuple.MutablePair;

public class PartFluidConversionMonitor
extends PartFluidStorageMonitor {
    public PartFluidConversionMonitor(ItemStack is) {
        super(is);
    }

    public boolean onPartShiftActivate(EntityPlayer player, Vec3 pos) {
        if (Platform.isClient()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions((DimensionalCoord)this.getLocation(), (EntityPlayer)player)) {
            return false;
        }
        ItemStack item = player.func_71045_bC();
        FluidStack fluidStack = item != null && item.func_77973_b() instanceof ItemFluidPacket ? ItemFluidPacket.getFluidStack(item) : Util.FluidUtil.getFluidFromContainer(item);
        if (this.getDisplayed() == null || fluidStack == null || fluidStack.getFluid() != ((IAEFluidStack)this.getDisplayed()).getFluid()) {
            return false;
        }
        try {
            IAEFluidStack input;
            IMEMonitor cell;
            if (!this.getProxy().isActive()) {
                return false;
            }
            IEnergyGrid energy = this.getProxy().getEnergy();
            IAEFluidStack failedToInsert = (IAEFluidStack)Platform.poweredInsert((IEnergySource)energy, (IMEInventory)(cell = this.getProxy().getStorage().getFluidInventory()), (IAEStack)(input = (IAEFluidStack)this.getDisplayed().copy().setStackSize((long)fluidStack.amount)), (BaseActionSource)new PlayerSource(player, (IActionHost)this));
            if (failedToInsert != null && failedToInsert.getStackSize() == input.getStackSize()) {
                return false;
            }
            if (failedToInsert == null || failedToInsert.getStackSize() != input.getStackSize()) {
                if (item.func_77973_b() instanceof ItemFluidPacket) {
                    if (failedToInsert != null) {
                        player.func_71045_bC().func_77982_d(ItemFluidPacket.newStack(failedToInsert).func_77978_p());
                        return true;
                    }
                } else {
                    ItemStack tmp = item.func_77946_l();
                    tmp.field_77994_a = 1;
                    ItemStack tank = null;
                    if (failedToInsert == null) {
                        tank = Util.FluidUtil.clearFluid(tmp);
                    } else if (tmp.func_77973_b() instanceof IFluidContainerItem) {
                        tank = Util.FluidUtil.setFluidContainerAmount(tmp, (int)failedToInsert.getStackSize());
                    } else if (FluidContainerRegistry.isContainer((ItemStack)tmp)) {
                        IAEFluidStack insertedFluid = input.copy();
                        insertedFluid.decStackSize(failedToInsert.getStackSize());
                        this.getProxy().getStorage().getFluidInventory().extractItems((IAEStack)insertedFluid, Actionable.MODULATE, (BaseActionSource)new PlayerSource(player, (IActionHost)this));
                        return false;
                    }
                    if (tank != null && !player.field_71071_by.func_70441_a(tank)) {
                        player.func_70099_a(tank, 0.0f);
                    }
                }
                --item.field_77994_a;
                if (item.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return true;
    }

    @Override
    protected void extractItem(EntityPlayer player) {
        IAEFluidStack input = (IAEFluidStack)this.getDisplayed();
        ItemStack eq = player.func_71045_bC();
        if (input != null && Util.FluidUtil.isFluidContainer(eq) && Util.FluidUtil.isEmpty(eq)) {
            try {
                if (!this.getProxy().isActive()) {
                    return;
                }
                IEnergyGrid energy = this.getProxy().getEnergy();
                IMEMonitor cell = this.getProxy().getStorage().getFluidInventory();
                ItemStack tank = eq.func_77946_l();
                tank.field_77994_a = 1;
                MutablePair<Integer, ItemStack> fillStack = Util.FluidUtil.fillStack(tank, input.getFluidStack());
                input.setStackSize((long)((Integer)fillStack.left).intValue());
                IAEFluidStack retrieved = (IAEFluidStack)Platform.poweredExtraction((IEnergySource)energy, (IMEInventory)cell, (IAEStack)input, (BaseActionSource)new PlayerSource(player, (IActionHost)this));
                if (retrieved != null) {
                    InventoryAdaptor adaptor;
                    ItemStack newItems;
                    if (!player.field_71071_by.func_70441_a((ItemStack)fillStack.right)) {
                        player.func_70099_a(((ItemStack)fillStack.right).func_77946_l(), 0.0f);
                    }
                    --eq.field_77994_a;
                    if (eq.field_77994_a <= 0) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    }
                    if ((newItems = (adaptor = InventoryAdaptor.getAdaptor((Object)player, (ForgeDirection)ForgeDirection.UNKNOWN)).addItems(Util.FluidUtil.setFluidContainerAmount((ItemStack)fillStack.right, (int)retrieved.getStackSize()))) != null) {
                        TileEntity te = this.getTile();
                        List<ItemStack> list = Collections.singletonList(newItems);
                        Platform.spawnDrops((World)player.field_70170_p, (int)(te.field_145851_c + this.getSide().offsetX), (int)(te.field_145848_d + this.getSide().offsetY), (int)(te.field_145849_e + this.getSide().offsetZ), list);
                    }
                    if (player.field_71070_bA != null) {
                        player.field_71070_bA.func_75142_b();
                    }
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }
}

