/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.tools;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.HarvestTool;

public abstract class DualHarvestTool
extends HarvestTool {
    public DualHarvestTool(int baseDamage) {
        super(baseDamage);
    }

    @Override
    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (stack == null || !(stack.func_77973_b() instanceof HarvestTool)) {
            return -1;
        }
        if (toolClass == null) {
            return -1;
        }
        if (!stack.func_77942_o()) {
            return -1;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74767_n("Broken")) {
            return -1;
        }
        if (this.getHarvestType().equals(toolClass)) {
            return tags.func_74762_e("HarvestLevel");
        }
        if (this.getSecondHarvestType().equals(toolClass)) {
            return tags.func_74762_e("HarvestLevel2");
        }
        return -1;
    }

    @Override
    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        Material[] materials;
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74767_n("Broken")) {
            return 0.1f;
        }
        for (Material value : materials = this.getEffectiveMaterials()) {
            if (value != block.func_149688_o()) continue;
            if (block.getHarvestLevel(meta) <= tags.func_74762_e("HarvestLevel")) {
                return AbilityHelper.calcDualToolSpeed(this, tags, false);
            }
            return 0.1f;
        }
        for (Material material : materials = this.getEffectiveSecondaryMaterials()) {
            if (material != block.func_149688_o()) continue;
            if (block.getHarvestLevel(meta) <= tags.func_74762_e("HarvestLevel2")) {
                return AbilityHelper.calcDualToolSpeed(this, tags, true);
            }
            return 0.1f;
        }
        return super.getDigSpeed(stack, block, meta);
    }

    @Override
    public boolean isEffective(Material material) {
        if (super.isEffective(material)) {
            return true;
        }
        for (Material m : this.getEffectiveSecondaryMaterials()) {
            if (m != material) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getTraits() {
        return new String[]{"harvest", "dualharvest"};
    }

    protected abstract Material[] getEffectiveSecondaryMaterials();

    protected abstract String getSecondHarvestType();
}

