/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.client.gui;

import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.TextRenderer;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.recursive_pineapple.matter_manipulator.common.networking.SoundResource;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import org.joml.Vector2d;
import org.lwjgl.opengl.GL11;

public class RadialMenu
extends Widget
implements Interactable {
    private static final double TAU = Math.PI * 2;
    public List<RadialMenuOption> options = new ArrayList<RadialMenuOption>();
    public float innerRadius = 0.25f;
    public float outerRadius = 0.6f;
    public IDrawable innerIcon;

    public Pos2d getPos() {
        return new Pos2d(0, 0);
    }

    public Size getSize() {
        return this.getContext().getScaledScreenSize();
    }

    public void draw(float partialTicks) {
        Minecraft.func_71410_x().field_71424_I.func_76320_a("radial menu");
        double weightSum = 0.0;
        for (RadialMenuOption option : this.options) {
            option.isHidden = option.hidden.getAsBoolean();
            if (option.isHidden) continue;
            weightSum += option.weight;
        }
        double currentAngle = 0.0;
        for (RadialMenuOption radialMenuOption : this.options) {
            if (radialMenuOption.isHidden) {
                radialMenuOption.startTheta = 0.0;
                radialMenuOption.endTheta = 0.0;
                continue;
            }
            double sliceSize = radialMenuOption.weight / weightSum * (Math.PI * 2);
            radialMenuOption.startTheta = currentAngle;
            radialMenuOption.endTheta = currentAngle += sliceSize;
        }
        RadialMenuOption firstShown = null;
        for (RadialMenuOption option : this.options) {
            if (option.isHidden) continue;
            firstShown = option;
            break;
        }
        if (firstShown != null) {
            double d = Math.abs(firstShown.startTheta - firstShown.endTheta) / 2.0;
            for (RadialMenuOption option : this.options) {
                if (option.isHidden) continue;
                option.startTheta -= d;
                option.endTheta -= d;
            }
        }
        this.pos = this.getPos();
        this.size = this.getSize();
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)(this.pos.getX() + (float)this.size.width / 2.0f), (float)(this.pos.getY() + (float)this.size.height / 2.0f), (float)0.0f);
        if (this.innerIcon != null) {
            this.innerIcon.draw(0.0f, 0.0f, 0.0f, 0.0f, partialTicks);
        }
        int n = Math.min(this.size.width, this.size.height);
        GlStateManager.scale((float)((float)n / 2.0f), (float)((float)n / 2.0f), (float)1.0f);
        Vector2d mouse = this.getMousePosition();
        double mouseRadius = mouse.x;
        double mouseTheta = mouse.y;
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        for (RadialMenuOption option : this.options) {
            boolean isHoveredOver;
            if (option.isHidden) continue;
            boolean bl = isHoveredOver = mouseRadius >= (double)this.innerRadius && mouseRadius <= (double)this.outerRadius && RadialMenu.isAngleBetween(mouseTheta, option.startTheta, option.endTheta);
            if (isHoveredOver) {
                GL11.glColor4f((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
            } else {
                GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            GlStateManager.glBegin((int)5);
            double step = 0.09817477042468103;
            int i = 0;
            while (true) {
                double t = option.startTheta + (double)i * step;
                RadialMenu.radialVertex(this.outerRadius, Math.min(Math.max(t, option.startTheta), option.endTheta));
                RadialMenu.radialVertex(this.innerRadius, Math.min(Math.max(t, option.startTheta), option.endTheta));
                if (t > option.endTheta) break;
                ++i;
            }
            GlStateManager.glEnd();
        }
        GL11.glEnable((int)3553);
        GlStateManager.popMatrix();
        for (RadialMenuOption option : this.options) {
            if (option.isHidden) continue;
            this.radialText((this.innerRadius + this.outerRadius) / 2.0f, (option.startTheta + option.endTheta) / 2.0, 60, -3355444, option.label.get());
        }
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3042);
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }

    public Interactable.ClickResult onClick(int mouseButton, boolean doubleClick) {
        Vector2d mouse = this.getMousePosition();
        double mouseRadius = mouse.x;
        double mouseTheta = mouse.y;
        for (RadialMenuOption option : this.options) {
            boolean isHoveredOver = mouseRadius >= (double)this.innerRadius && mouseRadius <= (double)this.outerRadius && RadialMenu.isAngleBetween(mouseTheta, option.startTheta, option.endTheta);
            if (!isHoveredOver) continue;
            if (option.hidden.getAsBoolean()) {
                return Interactable.ClickResult.ACKNOWLEDGED;
            }
            SoundResource.RANDOM_CLICK.playClient(0.5f, 1.0f);
            option.onClick.onClick(this, option, mouseButton, doubleClick);
            return Interactable.ClickResult.ACCEPT;
        }
        return Interactable.ClickResult.IGNORE;
    }

    private static double mod_tau(double angle) {
        return (angle % (Math.PI * 2) + Math.PI * 2) % (Math.PI * 2);
    }

    private static boolean isAngleBetween(double target, double angle1, double angle2) {
        if (angle2 < angle1) {
            return false;
        }
        while (angle1 < 0.0) {
            angle1 += Math.PI * 2;
            angle2 += Math.PI * 2;
        }
        while (angle1 > Math.PI * 2) {
            angle1 -= Math.PI * 2;
            angle2 -= Math.PI * 2;
        }
        return RadialMenu.mod_tau(target - angle1) < angle2 - angle1;
    }

    private Vector2d getMousePosition() {
        Pos2d pos = this.getPos();
        Size size = this.getSize();
        int dim = Math.min(size.width, size.height);
        double mx = (double)this.getContext().getMousePos().x - (double)pos.getX();
        double my = (double)this.getContext().getMousePos().y - (double)pos.getY();
        mx = RadialMenu.map(mx, (float)size.width / 2.0f - (float)dim / 2.0f, (float)size.width / 2.0f + (float)dim / 2.0f, -1.0, 1.0);
        my = RadialMenu.map(my, (float)size.height / 2.0f - (float)dim / 2.0f, (float)size.height / 2.0f + (float)dim / 2.0f, -1.0, 1.0);
        double mouseRadius = Math.sqrt(mx * mx + my * my);
        double mouseTheta = RadialMenu.mod_tau(Math.atan2(my, mx));
        return new Vector2d(mouseRadius, mouseTheta);
    }

    private void radialText(double radius, double theta, int wrapWidth, int color, String text) {
        FontRenderer renderer = TextRenderer.getFontRenderer();
        Size size = this.getSize();
        int dim = Math.min(size.width, size.height);
        int x = (int)RadialMenu.map(Math.cos(theta) * radius, -1.0, 1.0, (float)size.width / 2.0f - (float)dim / 2.0f, (float)size.width / 2.0f + (float)dim / 2.0f);
        int y = (int)RadialMenu.map(Math.sin(theta) * radius, -1.0, 1.0, (float)size.height / 2.0f - (float)dim / 2.0f, (float)size.height / 2.0f + (float)dim / 2.0f);
        List lines = renderer.func_78271_c(text, wrapWidth);
        int boundsX = 0;
        int boundsY = lines.size() * renderer.field_78288_b;
        for (String line : lines) {
            boundsX = Math.max(boundsX, renderer.func_78256_a(line));
        }
        int nextY = y - boundsY / 2;
        for (String line : lines) {
            int width = renderer.func_78256_a(line);
            int height = renderer.field_78288_b;
            int paddingX = (boundsX - width) / 2;
            renderer.func_78276_b(line, x - boundsX / 2 + paddingX, nextY, color);
            nextY += height;
        }
    }

    private static double map(double x, double in_min, double in_max, double out_min, double out_max) {
        return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
    }

    private static void radialVertex(double radius, double theta) {
        double x = Math.cos(theta) * radius;
        double y = Math.sin(theta) * radius;
        GlStateManager.glVertex3f((float)((float)x), (float)((float)y), (float)1.0f);
    }

    public static class RadialMenuOption {
        public Supplier<String> label;
        public double weight = 1.0;
        public BooleanSupplier hidden = () -> false;
        boolean isHidden;
        public RadialMenuClickHandler onClick;
        public double startTheta;
        public double endTheta;
    }

    public static interface RadialMenuClickHandler {
        public void onClick(RadialMenu var1, RadialMenuOption var2, int var3, boolean var4);
    }
}

