/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.tile;

import cpw.mods.fml.relauncher.Side;
import java.util.LinkedList;
import micdoodle8.mods.galacticraft.api.power.ILaserNode;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAdvanced;
import micdoodle8.mods.galacticraft.core.util.Annotations;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public abstract class TileEntityBeamOutput
extends TileEntityAdvanced
implements ILaserNode {
    public LinkedList<ILaserNode> nodeList = new LinkedList();
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public BlockVec3 targetVec = BlockVec3.INVALID_VECTOR;
    public float pitch;
    public float yaw;
    private BlockVec3 preLoadTarget = null;
    private BlockVec3 lastTargetVec = BlockVec3.INVALID_VECTOR;

    @Override
    public void func_145845_h() {
        TileEntity tileAtTarget;
        if (this.preLoadTarget != null && (tileAtTarget = this.field_145850_b.func_147438_o(this.preLoadTarget.x, this.preLoadTarget.y, this.preLoadTarget.z)) instanceof ILaserNode) {
            this.setTarget((ILaserNode)tileAtTarget);
            this.preLoadTarget = null;
        }
        super.func_145845_h();
        if (!this.targetVec.equals(this.lastTargetVec)) {
            this.func_70296_d();
        }
        this.lastTargetVec = this.targetVec;
        if (this.field_145850_b.field_72995_K) {
            this.updateOrientation();
        } else if (this.targetVec.equals(BlockVec3.INVALID_VECTOR)) {
            this.initiateReflector();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.invalidateReflector();
    }

    public void func_145829_t() {
        super.func_145829_t();
    }

    public void onChunkUnload() {
        this.invalidateReflector();
    }

    public void invalidateReflector() {
        for (ILaserNode node : this.nodeList) {
            node.removeNode(this);
        }
        this.nodeList.clear();
    }

    public void initiateReflector() {
        this.nodeList.clear();
        int chunkXMin = this.field_145851_c - 15 >> 4;
        int chunkZMin = this.field_145849_e - 15 >> 4;
        int chunkXMax = this.field_145851_c + 15 >> 4;
        int chunkZMax = this.field_145849_e + 15 >> 4;
        for (int cX = chunkXMin; cX <= chunkXMax; ++cX) {
            for (int cZ = chunkZMin; cZ <= chunkZMax; ++cZ) {
                if (!this.field_145850_b.func_72863_F().func_73149_a(cX, cZ)) continue;
                Chunk chunk = this.field_145850_b.func_72964_e(cX, cZ);
                for (Object obj : chunk.field_150816_i.values()) {
                    ILaserNode laserNode;
                    if (obj == this || !(obj instanceof ILaserNode)) continue;
                    BlockVec3 deltaPos = new BlockVec3(this).subtract(new BlockVec3(((ILaserNode)obj).getTile()));
                    if (deltaPos.x >= 16 || deltaPos.y >= 16 || deltaPos.z >= 16 || !this.canConnectTo(laserNode = (ILaserNode)obj) || !laserNode.canConnectTo(this)) continue;
                    this.addNode(laserNode);
                    laserNode.addNode(this);
                }
            }
        }
        this.setTarget(this.nodeList.peekFirst());
    }

    @Override
    public void addNode(ILaserNode node) {
        int index = -1;
        for (int i = 0; i < this.nodeList.size(); ++i) {
            if (!new BlockVec3(this.nodeList.get(i).getTile()).equals(new BlockVec3(node.getTile()))) continue;
            index = i;
            break;
        }
        if (index != -1) {
            this.nodeList.set(index, node);
            return;
        }
        if (this.nodeList.isEmpty()) {
            this.nodeList.add(node);
        } else {
            int nodeCompare = this.nodeList.get(0).compareTo(node, new BlockVec3(this));
            if (nodeCompare <= 0) {
                this.nodeList.addFirst(node);
                return;
            }
            nodeCompare = this.nodeList.get(this.nodeList.size() - 1).compareTo(node, new BlockVec3(this));
            if (nodeCompare >= 0) {
                this.nodeList.addLast(node);
                return;
            }
            for (index = 1; index < this.nodeList.size(); ++index) {
            }
            this.nodeList.add(index, node);
        }
    }

    @Override
    public void removeNode(ILaserNode node) {
        int index = -1;
        for (int i = 0; i < this.nodeList.size(); ++i) {
            if (!new BlockVec3(this.nodeList.get(i).getTile()).equals(new BlockVec3(node.getTile()))) continue;
            index = i;
            break;
        }
        if (new BlockVec3(node.getTile()).equals(this.targetVec)) {
            if (index == 0) {
                if (this.nodeList.size() > 1) {
                    this.setTarget(this.nodeList.get(index + 1));
                } else {
                    this.setTarget(null);
                }
            } else {
                this.setTarget(this.nodeList.get(index - 1));
            }
        }
        if (index != -1) {
            this.nodeList.remove(index);
        }
    }

    public void updateOrientation() {
        if (this.getTarget() != null) {
            Vector3 direction = Vector3.subtract(this.getOutputPoint(false), this.getTarget().getInputPoint()).normalize();
            this.pitch = (float)(-Vector3.getAngle(new Vector3(-direction.x, -direction.y, -direction.z), new Vector3(0.0, 1.0, 0.0))) * 57.29578f + 90.0f;
            this.yaw = (float)(-(Math.atan2(direction.z, direction.x) * (double)57.29578f)) + 90.0f;
        }
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    @Override
    public int compareTo(ILaserNode otherNode, BlockVec3 origin) {
        int otherDistance;
        int thisDistance = new BlockVec3(this).subtract(origin).getMagnitudeSquared();
        if (thisDistance < (otherDistance = new BlockVec3(otherNode.getTile()).subtract(origin).getMagnitudeSquared())) {
            return 1;
        }
        if (thisDistance > otherDistance) {
            return -1;
        }
        return 0;
    }

    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        if (this.nodeList.size() > 1) {
            int index = -1;
            if (this.getTarget() != null) {
                for (int i = 0; i < this.nodeList.size(); ++i) {
                    if (!new BlockVec3(this.nodeList.get(i).getTile()).equals(new BlockVec3(this.getTarget().getTile()))) continue;
                    index = i;
                    break;
                }
            }
            if (index != -1) {
                ++index;
                this.setTarget(this.nodeList.get(index %= this.nodeList.size()));
                return true;
            }
            this.initiateReflector();
        }
        return false;
    }

    @Override
    public ILaserNode getTarget() {
        TileEntity tileAtTarget;
        if (!this.targetVec.equals(BlockVec3.INVALID_VECTOR) && (tileAtTarget = this.field_145850_b.func_147438_o(this.targetVec.x, this.targetVec.y, this.targetVec.z)) instanceof ILaserNode) {
            return (ILaserNode)tileAtTarget;
        }
        return null;
    }

    public void setTarget(ILaserNode target) {
        this.targetVec = target != null ? new BlockVec3(target.getTile()) : BlockVec3.INVALID_VECTOR;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74767_n("HasTarget")) {
            this.preLoadTarget = new BlockVec3(nbt.func_74762_e("TargetX"), nbt.func_74762_e("TargetY"), nbt.func_74762_e("TargetZ"));
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("HasTarget", this.getTarget() != null);
        if (this.getTarget() != null) {
            nbt.func_74768_a("TargetX", this.getTarget().getTile().field_145851_c);
            nbt.func_74768_a("TargetY", this.getTarget().getTile().field_145848_d);
            nbt.func_74768_a("TargetZ", this.getTarget().getTile().field_145849_e);
        }
    }
}

