/*
 * Decompiled with CFR 0.152.
 */
package com.n247s.n2core.networking;

import com.n247s.n2core.N2Core;
import com.n247s.n2core.networking.N2Packet;
import com.n247s.n2core.networking.N2PacketHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import org.apache.logging.log4j.Logger;

public class N2MessageHandler
implements IMessage {
    private static final Logger log = N2Core.logger;
    private N2Packet packet;

    protected N2MessageHandler bindPacket(N2Packet packet) {
        if (packet != null) {
            this.packet = packet;
        } else {
            log.catching((Throwable)new IllegalArgumentException("packet can't be null!"));
        }
        return this;
    }

    public IMessage onMessageReciev(N2MessageHandler message, MessageContext ctx) {
        return message.packet.onMessage(message, ctx);
    }

    public void fromBytes(ByteBuf buf) {
        String id = ByteBufUtils.readUTF8String((ByteBuf)buf);
        Class<? extends N2Packet> clazz = N2PacketHandler.getPacketClass(id);
        if (clazz != null) {
            try {
                Constructor<? extends N2Packet> constructor = clazz.getConstructor(ByteBuf.class);
                this.packet = constructor != null ? constructor.newInstance(buf) : clazz.newInstance();
                System.out.println("");
            }
            catch (Exception e) {
                log.catching((Throwable)e);
                return;
            }
        } else {
            log.catching((Throwable)new Exception("Couldn't find PacketType " + id));
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)N2PacketHandler.getPacketID(this.packet.getClass()));
        this.packet.writeBytes(buf);
    }
}

