/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.network;

import com.sinthoras.visualprospecting.database.ClientCache;
import com.sinthoras.visualprospecting.database.OreVeinPosition;
import com.sinthoras.visualprospecting.database.UndergroundFluidPosition;
import com.sinthoras.visualprospecting.utils.VPByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ProspectingNotification
implements IMessage {
    private static final List<UndergroundFluidPosition> emptyUndergroundFluids = new ArrayList<UndergroundFluidPosition>(0);
    private List<OreVeinPosition> oreVeins;
    private List<UndergroundFluidPosition> undergroundFluids;

    public ProspectingNotification() {
    }

    public ProspectingNotification(OreVeinPosition oreVeinPosition) {
        this.oreVeins = Collections.singletonList(oreVeinPosition);
        this.undergroundFluids = emptyUndergroundFluids;
    }

    public ProspectingNotification(List<OreVeinPosition> oreVeins, List<UndergroundFluidPosition> undergroundFluids) {
        this.oreVeins = oreVeins;
        this.undergroundFluids = undergroundFluids;
    }

    public void fromBytes(ByteBuf buf) {
        this.oreVeins = VPByteBufUtils.ReadOreVeinPositions(buf);
        this.undergroundFluids = VPByteBufUtils.ReadUndergroundFluidPositions(buf);
    }

    public void toBytes(ByteBuf buf) {
        VPByteBufUtils.WriteOreVeinPositions(buf, this.oreVeins);
        VPByteBufUtils.WriteUndergroundFluidPositions(buf, this.undergroundFluids);
    }

    public static class Handler
    implements IMessageHandler<ProspectingNotification, IMessage> {
        public IMessage onMessage(ProspectingNotification message, MessageContext ctx) {
            ClientCache.instance.putOreVeins(message.oreVeins);
            ClientCache.instance.putUndergroundFluids(message.undergroundFluids);
            return null;
        }
    }
}

