/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.tape;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.MouseEvent;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.item.ItemPortableTapeDrive;
import pl.asie.computronics.network.PacketType;
import pl.asie.computronics.tape.PortableDriveManager;
import pl.asie.computronics.tape.PortableTapeDrive;
import pl.asie.computronics.tile.TapeDriveState;

@SideOnly(value=Side.CLIENT)
public class TapeScrollEventHandler {
    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        Item item;
        ItemStack stack;
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (event.dwheel != 0 && player != null && player.func_70093_af() && (stack = player.func_71045_bC()) != null && (item = stack.func_77973_b()) instanceof ItemPortableTapeDrive) {
            TapeScrollEventHandler.scrollTapeDrive(stack, (EntityPlayer)player, event.dwheel);
            event.setCanceled(true);
        }
    }

    public static void scrollTapeDrive(ItemStack stack, EntityPlayer player, int dWheel) {
        PortableTapeDrive tapeDrive = PortableDriveManager.INSTANCE.getOrCreate(stack, true);
        TapeDriveState.State state = tapeDrive.getEnumState();
        TapeDriveState.State newState = null;
        switch (state) {
            case STOPPED: 
            case PLAYING: {
                newState = dWheel < 0 ? TapeDriveState.State.REWINDING : TapeDriveState.State.FORWARDING;
                break;
            }
            case FORWARDING: {
                newState = dWheel < 0 ? TapeDriveState.State.STOPPED : null;
                break;
            }
            case REWINDING: {
                newState = dWheel > 0 ? TapeDriveState.State.STOPPED : null;
            }
        }
        String id = PortableDriveManager.INSTANCE.getID(tapeDrive, true);
        if (newState != null && id != null) {
            try {
                Computronics.packet.sendToServer(Computronics.packet.create(PacketType.PORTABLE_TAPE_STATE.ordinal()).writeString(id).writeByte((byte)newState.ordinal()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

