/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.oc.driver;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Visibility;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.api.audio.AudioPacket;
import pl.asie.computronics.api.audio.AudioPacketRegistry;
import pl.asie.computronics.api.audio.IAudioReceiver;
import pl.asie.computronics.api.audio.IAudioSource;
import pl.asie.computronics.audio.AudioUtils;
import pl.asie.computronics.audio.SoundCardPacket;
import pl.asie.computronics.audio.SoundCardPacketClientHandler;
import pl.asie.computronics.oc.driver.ManagedEnvironmentWithComponentConnector;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.util.OCUtils;
import pl.asie.computronics.util.sound.AudioType;
import pl.asie.computronics.util.sound.AudioUtil;
import pl.asie.computronics.util.sound.Instruction;

public class DriverCardSound
extends ManagedEnvironmentWithComponentConnector
implements IAudioSource {
    protected final EnvironmentHost host;
    private final IAudioReceiver internalSpeaker = new IAudioReceiver(){

        @Override
        public boolean connectsAudio(ForgeDirection side) {
            return true;
        }

        @Override
        public World getSoundWorld() {
            return DriverCardSound.this.host.world();
        }

        @Override
        public Vec3 getSoundPos() {
            return Vec3.func_72443_a((double)DriverCardSound.this.host.xPosition(), (double)DriverCardSound.this.host.yPosition(), (double)DriverCardSound.this.host.zPosition());
        }

        @Override
        public int getSoundDistance() {
            return Config.SOUND_RADIUS;
        }

        @Override
        public void receivePacket(AudioPacket packet, ForgeDirection direction) {
            packet.addReceiver(this);
        }

        @Override
        public String getID() {
            return DriverCardSound.this.host instanceof TileEntity ? AudioUtils.positionId(DriverCardSound.this.host.xPosition(), DriverCardSound.this.host.yPosition(), DriverCardSound.this.host.zPosition()) : "";
        }
    };
    private AudioUtil.AudioProcess process;
    private final ArrayDeque<Instruction> buildBuffer;
    private final ArrayDeque<Instruction> nextBuffer;
    private int buildDelay = 0;
    private int nextDelay = 0;
    private long timeout = System.currentTimeMillis();
    private int soundVolume = 127;
    private Integer codecId;
    private String clientAddress;
    private final int soundTimeoutMS = 250;
    private static HashMap<Object, Object> modes;

    public DriverCardSound(EnvironmentHost host) {
        this.host = host;
        this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Neighbors).withComponent("sound").withConnector().create());
        this.process = new AudioUtil.AudioProcess(Config.SOUND_CARD_CHANNEL_COUNT);
        if (host.world().field_72995_K) {
            SyncHandler.envs.add(this);
            this.buildBuffer = null;
            this.nextBuffer = null;
        } else {
            this.buildBuffer = new ArrayDeque();
            this.nextBuffer = new ArrayDeque();
        }
    }

    public boolean canUpdate() {
        return !this.host.world().field_72995_K;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        if (this.nextBuffer != null && !this.nextBuffer.isEmpty() && System.currentTimeMillis() >= this.timeout - 100L) {
            Object clone;
            ArrayDeque<Instruction> arrayDeque = this.nextBuffer;
            synchronized (arrayDeque) {
                clone = this.nextBuffer.clone();
                this.timeout += (long)this.nextDelay;
                this.nextBuffer.clear();
            }
            this.sendSound((Queue<Instruction>)clone);
        } else if (this.codecId != null && System.currentTimeMillis() >= this.timeout + 250L) {
            AudioUtils.removePlayer(Computronics.opencomputers.managerId, this.codecId);
            this.codecId = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        if (nbt.func_74764_b("process")) {
            this.process.load(nbt.func_74775_l("process"));
        }
        if (this.host.world().field_72995_K) {
            NBTTagCompound nodeNBT;
            if (nbt.func_74764_b("node") && (nodeNBT = nbt.func_74775_l("node")).func_74764_b("address")) {
                this.clientAddress = nodeNBT.func_74779_i("address");
                SyncHandler.getHandler().setProcess(this.clientAddress, this.process);
            }
        } else {
            ArrayDeque<Instruction> arrayDeque;
            if (nbt.func_74764_b("bbuffer") && this.buildBuffer != null) {
                arrayDeque = this.buildBuffer;
                synchronized (arrayDeque) {
                    this.buildBuffer.clear();
                    this.buildBuffer.addAll(Instruction.fromNBT(nbt.func_150295_c("bbuffer", 10)));
                    this.buildDelay = 0;
                    for (Instruction inst : this.buildBuffer) {
                        if (!(inst instanceof Instruction.Delay)) continue;
                        this.buildDelay += ((Instruction.Delay)inst).delay;
                    }
                }
            }
            if (nbt.func_74764_b("nbuffer") && this.nextBuffer != null) {
                arrayDeque = this.nextBuffer;
                synchronized (arrayDeque) {
                    this.nextBuffer.clear();
                    this.nextBuffer.addAll(Instruction.fromNBT(nbt.func_150295_c("nbuffer", 10)));
                    this.nextDelay = 0;
                    for (Instruction inst : this.nextBuffer) {
                        if (!(inst instanceof Instruction.Delay)) continue;
                        this.nextDelay += ((Instruction.Delay)inst).delay;
                    }
                }
            }
            if (nbt.func_74764_b("volume")) {
                this.soundVolume = nbt.func_74771_c("volume");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        if (!this.host.world().field_72995_K) {
            ArrayDeque<Instruction> arrayDeque;
            NBTTagCompound processNBT = new NBTTagCompound();
            nbt.func_74782_a("process", (NBTBase)processNBT);
            this.process.save(processNBT);
            if (this.buildBuffer != null && !this.buildBuffer.isEmpty()) {
                NBTTagList buildNBT = new NBTTagList();
                arrayDeque = this.buildBuffer;
                synchronized (arrayDeque) {
                    Instruction.toNBT(buildNBT, this.buildBuffer);
                }
                nbt.func_74782_a("bbuffer", (NBTBase)buildNBT);
            }
            if (this.nextBuffer != null && !this.nextBuffer.isEmpty()) {
                NBTTagList nextNBT = new NBTTagList();
                arrayDeque = this.nextBuffer;
                synchronized (arrayDeque) {
                    Instruction.toNBT(nextNBT, this.nextBuffer);
                }
                nbt.func_74782_a("nbuffer", (NBTBase)nextNBT);
            }
            nbt.func_74774_a("volume", (byte)this.soundVolume);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAndStop() {
        ArrayDeque<Instruction> arrayDeque;
        if (this.buildBuffer != null && !this.buildBuffer.isEmpty()) {
            arrayDeque = this.buildBuffer;
            synchronized (arrayDeque) {
                this.buildBuffer.clear();
            }
        }
        if (this.nextBuffer != null && !this.nextBuffer.isEmpty()) {
            arrayDeque = this.nextBuffer;
            synchronized (arrayDeque) {
                this.nextBuffer.clear();
            }
        }
        this.buildDelay = 0;
        if (this.codecId != null) {
            AudioUtils.removePlayer(Computronics.opencomputers.managerId, this.codecId);
            this.codecId = null;
        }
    }

    public void onMessage(Message message) {
        if ((message.name().equals("computer.stopped") || message.name().equals("computer.started")) && this.node().isNeighborOf(message.source())) {
            this.clearAndStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] tryAdd(Instruction inst) {
        ArrayDeque<Instruction> arrayDeque = this.buildBuffer;
        synchronized (arrayDeque) {
            if (this.buildBuffer.size() >= Config.SOUND_CARD_QUEUE_SIZE) {
                return new Object[]{false, "too many instructions"};
            }
            this.buildBuffer.add(inst);
        }
        return new Object[]{true};
    }

    private static HashMap<Object, Object> compileModes() {
        if (modes == null) {
            HashMap<Object, Object> modes = new HashMap<Object, Object>(AudioType.VALUES.length * 2);
            for (AudioType value : AudioType.VALUES) {
                String name = value.name().toLowerCase(Locale.ENGLISH);
                modes.put(value.ordinal() + 1, name);
                modes.put(name, value.ordinal() + 1);
            }
            modes.put("noise", -1);
            modes.put(-1, "noise");
            DriverCardSound.modes = modes;
        }
        return modes;
    }

    protected int checkChannel(Arguments args, int index) {
        int channel = args.checkInteger(index) - 1;
        if (channel >= 0 && channel < this.process.states.size()) {
            return channel;
        }
        throw new IllegalArgumentException("invalid channel: " + (channel + 1));
    }

    protected int checkChannel(Arguments args) {
        return this.checkChannel(args, 0);
    }

    @Callback(doc="This is a bidirectional table of all valid modes.", direct=true, getter=true)
    public Object[] modes(Context context, Arguments args) {
        return new Object[]{DriverCardSound.compileModes()};
    }

    @Callback(doc="This is the number of channels this card provides.", direct=true, getter=true)
    public Object[] channel_count(Context context, Arguments args) {
        return new Object[]{this.process.states.size()};
    }

    @Callback(doc="function(volume:number); Sets the general volume of the entire sound card to a value between 0 and 1. Not an instruction, this affects all channels directly.", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] setTotalVolume(Context context, Arguments args) {
        double volume = args.checkDouble(0);
        if (volume < 0.0) {
            volume = 0.0;
        }
        if (volume > 1.0) {
            volume = 1.0;
        }
        this.soundVolume = MathHelper.func_76128_c((double)(volume * 127.0));
        return new Object[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback(doc="function(); Clears the instruction queue.", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] clear(Context context, Arguments args) {
        ArrayDeque<Instruction> arrayDeque = this.buildBuffer;
        synchronized (arrayDeque) {
            this.buildBuffer.clear();
        }
        this.buildDelay = 0;
        return new Object[0];
    }

    @Callback(doc="function(channel:number); Instruction; Opens the specified channel, allowing sound to be generated.", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] open(Context context, Arguments args) {
        return this.tryAdd(new Instruction.Open(this.checkChannel(args)));
    }

    @Callback(doc="function(channel:number); Instruction; Closes the specified channel, stopping sound from being generated.", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] close(Context context, Arguments args) {
        return this.tryAdd(new Instruction.Close(this.checkChannel(args)));
    }

    @Callback(doc="function(channel:number, type:number); Instruction; Sets the wave type on the specified channel.", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] setWave(Context context, Arguments args) {
        int channel = this.checkChannel(args);
        int mode = args.checkInteger(1) - 1;
        switch (mode) {
            case -2: {
                return this.tryAdd(new Instruction.SetWhiteNoise(channel));
            }
        }
        if (mode >= 0 && mode < AudioType.VALUES.length) {
            return this.tryAdd(new Instruction.SetWave(channel, AudioType.fromIndex(mode)));
        }
        throw new IllegalArgumentException("invalid mode: " + (mode + 1));
    }

    @Callback(doc="function(channel:number, frequency:number); Instruction; Sets the frequency on the specified channel.", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] setFrequency(Context context, Arguments args) {
        return this.tryAdd(new Instruction.SetFrequency(this.checkChannel(args), (float)args.checkDouble(1)));
    }

    @Callback(doc="function(channel:number, initial:number, mask:number); Instruction; Makes the specified channel generate LFSR noise. Functions like a wave type.", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] setLFSR(Context context, Arguments args) {
        return this.tryAdd(new Instruction.SetLFSR(this.checkChannel(args), args.checkInteger(1), args.checkInteger(2)));
    }

    @Callback(doc="function(duration:number); Instruction; Adds a delay of the specified duration in milliseconds, allowing sound to generate.", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] delay(Context context, Arguments args) {
        int duration = args.checkInteger(0);
        if (duration < 0 || duration > Config.SOUND_CARD_MAX_DELAY) {
            throw new IllegalArgumentException("invalid duration. must be between 0 and " + Config.SOUND_CARD_MAX_DELAY);
        }
        if (this.buildDelay + duration > Config.SOUND_CARD_MAX_DELAY) {
            return new Object[]{false, "too many delays in queue"};
        }
        this.buildDelay += duration;
        return this.tryAdd(new Instruction.Delay(duration));
    }

    @Callback(doc="function(channel:number, modIndex:number, intensity:number); Instruction; Assigns a frequency modulator channel to the specified channel with the specified intensity.", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] setFM(Context context, Arguments args) {
        return this.tryAdd(new Instruction.SetFM(this.checkChannel(args), this.checkChannel(args, 1), (float)args.checkDouble(2)));
    }

    @Callback(doc="function(channel:number); Instruction; Removes the specified channel's frequency modulator.", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] resetFM(Context context, Arguments args) {
        return this.tryAdd(new Instruction.ResetFM(this.checkChannel(args)));
    }

    @Callback(doc="function(channel:number, modIndex:number); Instruction; Assigns an amplitude modulator channel to the specified channel.", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] setAM(Context context, Arguments args) {
        return this.tryAdd(new Instruction.SetAM(this.checkChannel(args), this.checkChannel(args, 1)));
    }

    @Callback(doc="function(channel:number); Instruction; Removes the specified channel's amplitude modulator.", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] resetAM(Context context, Arguments args) {
        return this.tryAdd(new Instruction.ResetAM(this.checkChannel(args)));
    }

    @Callback(doc="function(channel:number, attack:number, decay:number, attenuation:number, release:number); Instruction; Assigns ADSR to the specified channel with the specified phase durations in milliseconds and attenuation between 0 and 1.", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] setADSR(Context context, Arguments args) {
        return this.tryAdd(new Instruction.SetADSR(this.checkChannel(args), args.checkInteger(1), args.checkInteger(2), (float)args.checkDouble(3), args.checkInteger(4)));
    }

    @Callback(doc="function(channel:number); Instruction; Removes ADSR from the specified channel.", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] resetEnvelope(Context context, Arguments args) {
        return this.tryAdd(new Instruction.ResetEnvelope(this.checkChannel(args)));
    }

    @Callback(doc="function(channel:number, volume:number); Instruction; Sets the volume of the channel between 0 and 1.", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] setVolume(Context context, Arguments args) {
        return this.tryAdd(new Instruction.SetVolume(this.checkChannel(args), (float)args.checkDouble(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback(doc="function(); Starts processing the queue; Returns true is processing began, false if there is still a queue being processed.", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] process(Context context, Arguments args) {
        ArrayDeque<Instruction> arrayDeque = this.buildBuffer;
        synchronized (arrayDeque) {
            if (this.nextBuffer != null && this.nextBuffer.isEmpty()) {
                if (this.buildBuffer.size() == 0) {
                    return new Object[]{true};
                }
                if (!this.node.tryChangeBuffer(-Config.SOUND_CARD_ENERGY_COST * ((double)this.buildDelay / 1000.0))) {
                    return new Object[]{false, "not enough energy"};
                }
                ArrayDeque<Instruction> arrayDeque2 = this.nextBuffer;
                synchronized (arrayDeque2) {
                    this.nextBuffer.addAll(new ArrayDeque<Instruction>(this.buildBuffer));
                }
                this.nextDelay = this.buildDelay;
                this.buildBuffer.clear();
                this.buildDelay = 0;
                if (System.currentTimeMillis() > this.timeout) {
                    this.timeout = System.currentTimeMillis();
                }
                return new Object[]{true};
            }
            return new Object[]{false, System.currentTimeMillis() - this.timeout};
        }
    }

    private void sendMusicPacket(Queue<Instruction> instructions) {
        if (this.codecId == null) {
            this.codecId = Computronics.opencomputers.audio.newPlayer();
            Computronics.opencomputers.audio.getPlayer(this.codecId);
        }
        SoundCardPacket pkt = new SoundCardPacket(this, (byte)this.soundVolume, this.node().address(), instructions);
        this.internalSpeaker.receivePacket(pkt, ForgeDirection.UNKNOWN);
        pkt.sendPacket();
    }

    protected void sendSound(Queue<Instruction> buffer) {
        ArrayDeque<Instruction> sendBuffer = new ArrayDeque<Instruction>();
        while (!buffer.isEmpty() || this.process.delay > 0) {
            if (this.process.delay > 0) {
                this.process.delay = 0;
                continue;
            }
            Instruction inst = buffer.poll();
            inst.encounter(this.process);
            sendBuffer.add(inst);
        }
        if (sendBuffer.size() > 0) {
            this.sendMusicPacket(sendBuffer);
        }
    }

    @Override
    public boolean connectsAudio(ForgeDirection side) {
        return false;
    }

    @Override
    public int getSourceId() {
        return this.codecId;
    }

    @Override
    protected OCUtils.Device deviceInfo() {
        return new OCUtils.Device("multimedia", "Audio interface", "Yanaki Sound Systems", "MinoSound 244-X", new String[0]);
    }

    public static class SyncHandler {
        static Set<DriverCardSound> envs = Collections.newSetFromMap(new WeakHashMap());

        @SideOnly(value=Side.CLIENT)
        private static SoundCardPacketClientHandler getHandler() {
            return (SoundCardPacketClientHandler)AudioPacketRegistry.INSTANCE.getClientHandler(AudioPacketRegistry.INSTANCE.getId(SoundCardPacket.class));
        }

        @SubscribeEvent
        public void onChunkUnload(ChunkEvent.Unload evt) {
            for (DriverCardSound env : envs) {
                if (env.host.world() != evt.world || !evt.getChunk().func_76600_a(MathHelper.func_76128_c((double)env.host.xPosition()) >> 4, MathHelper.func_76128_c((double)env.host.zPosition()) >> 4)) continue;
                SyncHandler.getHandler().setProcess(env.clientAddress, null);
            }
        }

        @SubscribeEvent
        public void onWorldUnload(WorldEvent.Unload evt) {
            for (DriverCardSound env : envs) {
                if (env.host.world() != evt.world) continue;
                SyncHandler.getHandler().setProcess(env.clientAddress, null);
            }
        }
    }
}

