/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.audio.tts;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import marytts.server.MaryProperties;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.log4j.PropertyConfigurator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextToSpeechLoader {
    public static final TextToSpeechLoader INSTANCE = new TextToSpeechLoader();
    private boolean hasDoneInit = false;
    public static final Logger log = LogManager.getLogger((String)"computronics-text-to-speech-loader");
    public static File ttsDir;
    private ClasspathAdder classpathAdder;

    public boolean preInit() {
        log.info("Initializing Text To Speech");
        LaunchClassLoader classLoader = Launch.classLoader;
        ClassLoader ownClassLoader = this.getClass().getClassLoader();
        if (ownClassLoader instanceof LaunchClassLoader) {
            classLoader = (LaunchClassLoader)ownClassLoader;
        }
        this.classpathAdder = new ClasspathAdder((ClassLoader)classLoader);
        classLoader.addClassLoaderExclusion("marytts.");
        classLoader.addClassLoaderExclusion("jtok.");
        classLoader.addClassLoaderExclusion("de.dfki.");
        classLoader.addClassLoaderExclusion("org.apache.log4j.");
        try {
            Class.forName("marytts.MaryInterface");
            Class.forName("marytts.LocalMaryInterface");
            Class.forName("marytts.server.Mary");
            log.trace("MaryTTS in classpath.");
        }
        catch (Exception e) {
            log.trace("No MaryTTS in classpath.");
        }
        ttsDir = new File(System.getProperty("user.dir"));
        ttsDir = new File(ttsDir, "marytts");
        if (!ttsDir.exists()) {
            log.info("No MaryTTS directory found, you will not be able to use Text To Speech unless the server you are playing on has MaryTTS installed. To use TTS, install MaryTTS into the marytts directory of your minecraft instance.");
            this.hasDoneInit = false;
            return false;
        }
        if (!ttsDir.isDirectory()) {
            log.error("Could not load MaryTTS - found a file, not a directory!");
            this.hasDoneInit = false;
            return false;
        }
        Object[] files = ttsDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return (name = name.toLowerCase(Locale.ROOT)).endsWith(".jar") || name.endsWith(".zip");
            }
        });
        if (files == null || files.length <= 0) {
            log.error("Found an empty or invalid marytts directory, Text To Speech will not be initialized");
            this.hasDoneInit = false;
            return false;
        }
        Arrays.sort(files);
        for (Object file : files) {
            if (((File)file).isDirectory() || !((File)file).exists()) continue;
            try {
                log.info("Found Text-to-speech file " + ((File)file).getName());
                classLoader.addURL(((File)file).toURI().toURL());
                this.classpathAdder.addFile((File)file);
            }
            catch (IOException e) {
                log.error("Error trying to load " + ((File)file).getName(), (Throwable)e);
            }
        }
        try {
            Class.forName("marytts.MaryInterface");
            Class.forName("marytts.LocalMaryInterface");
            Class.forName("marytts.server.Mary");
            Properties logprops = new Properties();
            BufferedInputStream propIS = new BufferedInputStream(MaryProperties.needStream((String)"log.config"));
            logprops.load(propIS);
            ((InputStream)propIS).close();
            for (Object key : logprops.keySet()) {
                String val = (String)logprops.get(key);
                if (!val.contains("MARY_BASE")) continue;
                String maryBase = MaryProperties.maryBase();
                if (maryBase.contains("\\")) {
                    maryBase = maryBase.replaceAll("\\\\", "/");
                }
                val = val.replaceAll("MARY_BASE", maryBase);
                logprops.put(key, val);
            }
            String loggerMaryttsKey = "log4j.logger.marytts";
            String loggerMaryttsValue = MaryProperties.getProperty((String)loggerMaryttsKey);
            if (loggerMaryttsValue != null) {
                logprops.setProperty(loggerMaryttsKey, loggerMaryttsValue);
            }
            PropertyConfigurator.configure((Properties)logprops);
            this.hasDoneInit = true;
            return true;
        }
        catch (Exception e) {
            log.error("Text To Speech directory initialization failed, you will not be able to hear anything", (Throwable)e);
            this.hasDoneInit = false;
            return false;
        }
    }

    public boolean hasDoneInit() {
        return this.hasDoneInit;
    }

    private static class ClasspathAdder {
        private final ClassLoader classLoader;

        private ClasspathAdder(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        private void addFile(String path) throws IOException {
            File f = new File(path);
            this.addFile(f);
        }

        private void addFile(File file) throws IOException {
            this.addURL(file.toURI().toURL());
        }

        private void addURL(URL url) throws IOException {
            try {
                ClassLoader parent = this.classLoader.getParent();
                URLClassLoader sysloader = parent != null && parent instanceof URLClassLoader ? (URLClassLoader)parent : (URLClassLoader)ClassLoader.getSystemClassLoader();
                Class<URLClassLoader> sysclass = URLClassLoader.class;
                Method method = sysclass.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke((Object)sysloader, url);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new IOException("Error, could not add URL to system classloader", t);
            }
        }
    }
}

