/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.animation.Eases;
import com.gtnewhorizons.modularui.api.animation.Interpolator;
import com.gtnewhorizons.modularui.api.drawable.GuiHelper;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.Theme;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import com.gtnewhorizons.modularui.config.Config;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpandTab
extends MultiChildWidget
implements Interactable,
IWidgetBuilder<ExpandTab> {
    private boolean expanded = false;
    private boolean animating = false;
    private boolean firstBuild = true;
    private Interpolator openAnimator;
    private Interpolator closeAnimator;
    protected Size expandedSize;
    protected Size normalSize;
    protected Pos2d expandedPos;
    protected Pos2d normalPos;
    private int animateDuration = Config.openCloseDurationMs;
    private float animateX;
    private float animateY;
    private float animateWidth;
    private float animateHeight;
    @Nullable
    private IDrawable[] normalTexture;
    private float ticktime;

    @Override
    public void onInit() {
        this.openAnimator = new Interpolator(0.0f, 1.0f, this.animateDuration, Eases.EaseQuadOut, value -> {
            float val = ((Float)value).floatValue();
            this.animateX = (float)(this.expandedPos.x - this.normalPos.x) * val + (float)this.normalPos.x;
            this.animateY = (float)(this.expandedPos.y - this.normalPos.y) * val + (float)this.normalPos.y;
            this.animateWidth = (float)(this.expandedSize.width - this.normalSize.width) * val + (float)this.normalSize.width;
            this.animateHeight = (float)(this.expandedSize.height - this.normalSize.height) * val + (float)this.normalSize.height;
        }, val -> {
            this.animateX = this.expandedPos.x;
            this.animateY = this.expandedPos.y;
            this.animateWidth = this.expandedSize.width;
            this.animateHeight = this.expandedSize.height;
            this.animating = false;
        });
        this.closeAnimator = this.openAnimator.getReversed(this.animateDuration, Eases.EaseQuadIn);
        this.closeAnimator.setCallback(val -> {
            this.animateX = this.normalPos.x;
            this.animateY = this.normalPos.y;
            this.animateWidth = this.normalSize.width;
            this.animateHeight = this.normalSize.height;
            this.animating = false;
            for (Widget widget : this.getChildren()) {
                if (this.shouldDrawChildWidgetWhenCollapsed(widget)) continue;
                widget.setEnabled(false);
            }
        });
        for (Widget widget : this.getChildren()) {
            if (this.shouldDrawChildWidgetWhenCollapsed(widget)) continue;
            widget.setEnabled(false);
        }
        if (this.isClient()) {
            FMLCommonHandler.instance().bus().register((Object)this);
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        FMLCommonHandler.instance().bus().unregister((Object)this);
    }

    @Override
    @NotNull
    protected Size determineSize(int maxWidth, int maxHeight) {
        return new Size(20, 20);
    }

    @Override
    public void onRebuild() {
        if (this.firstBuild) {
            if (this.normalPos == null) {
                this.normalPos = this.getPos();
            }
            if (this.normalSize == null) {
                this.normalSize = this.getSize();
            }
            if (this.expandedPos == null) {
                this.expandedPos = this.normalPos;
            }
            if (this.expandedSize == null) {
                this.expandedSize = new Size(this.normalSize.width * 3, this.normalSize.height * 3);
            }
            this.animateX = this.getPos().x;
            this.animateY = this.getPos().y;
            this.animateWidth = this.getSize().width;
            this.animateHeight = this.getSize().height;
            this.firstBuild = false;
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        this.ticktime = event.renderTickTime;
    }

    @Override
    public void onFrameUpdate() {
        if (this.animating) {
            if (this.expanded) {
                this.openAnimator.update(this.ticktime);
            } else {
                this.closeAnimator.update(this.ticktime);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(float partialTicks) {
        IDrawable[] background = this.getBackground();
        if (background != null) {
            int themeColor = Theme.INSTANCE.getColor(this.getBackgroundColorKey());
            for (IDrawable drawable : background) {
                if (drawable == null) continue;
                drawable.applyThemeColor(themeColor);
                IDrawable.applyTintColor(this.getWindow().getGuiTint());
                drawable.draw(this.animateX - (float)this.getPos().x, this.animateY - (float)this.getPos().y, this.animateWidth, this.animateHeight, partialTicks);
            }
        }
    }

    @Override
    public void draw(float partialTicks) {
        if (!this.isExpanded() && this.normalTexture != null) {
            for (IDrawable drawable : this.normalTexture) {
                if (drawable == null) continue;
                drawable.applyThemeColor();
                drawable.draw(Pos2d.ZERO, this.normalSize, partialTicks);
            }
        }
    }

    @Override
    public void drawChildren(float partialTicks) {
        if (this.isExpanded() || this.animating) {
            Pos2d parentPos = this.getParent().getAbsolutePos();
            GlStateManager.pushMatrix();
            Pos2d relativePos = this.isExpanded() ? this.expandedPos : this.normalPos;
            GlStateManager.translate(this.animateX - (float)relativePos.x, this.animateY - (float)relativePos.y, 0.0f);
            if (this.animating) {
                GuiHelper.useScissor((int)((float)parentPos.x + this.animateX), (int)((float)parentPos.y + this.animateY), (int)this.animateWidth, (int)this.animateHeight, () -> super.drawChildren(partialTicks));
            } else {
                super.drawChildren(partialTicks);
            }
            GlStateManager.popMatrix();
        } else {
            for (Widget child : this.getChildren()) {
                if (!this.shouldDrawChildWidgetWhenCollapsed(child)) continue;
                child.drawInternal(partialTicks);
            }
        }
    }

    @Override
    public Interactable.ClickResult onClick(int buttonId, boolean doubleClick) {
        if (buttonId == 0) {
            this.setExpanded(!this.isExpanded());
            return Interactable.ClickResult.ACCEPT;
        }
        return Interactable.ClickResult.ACKNOWLEDGED;
    }

    public void setExpanded(boolean expanded) {
        if (this.expanded != expanded) {
            this.expanded = expanded;
            this.animating = true;
            if (this.isExpanded()) {
                for (Widget widget : this.getChildren()) {
                    widget.setEnabled(true);
                }
                this.openAnimator.forward();
                super.setSize(this.expandedSize);
                super.setPos(this.expandedPos);
            } else {
                this.closeAnimator.forward();
                super.setSize(this.normalSize);
                super.setPos(this.normalPos);
            }
            this.checkNeedsRebuild();
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void addWidgetInternal(Widget widget) {
        this.addChild(widget);
    }

    public boolean shouldDrawChildWidgetWhenCollapsed(Widget child) {
        return false;
    }

    public ExpandTab setExpandedPos(int x, int y) {
        return this.setExpandedPos(new Pos2d(x, y));
    }

    public ExpandTab setExpandedPos(Pos2d expandedPos) {
        this.expandedPos = expandedPos;
        return this;
    }

    public ExpandTab setExpandedSize(int width, int height) {
        return this.setExpandedSize(new Size(width, height));
    }

    public ExpandTab setExpandedSize(Size expandedSize) {
        this.expandedSize = expandedSize;
        return this;
    }

    @Override
    public ExpandTab setSize(Size size) {
        super.setSize(size);
        this.normalSize = size;
        return this;
    }

    @Override
    public ExpandTab setPos(Pos2d relativePos) {
        super.setPos(relativePos);
        this.normalPos = relativePos;
        return this;
    }

    public ExpandTab setAnimateDuration(int animateDuration) {
        this.animateDuration = animateDuration;
        return this;
    }

    public ExpandTab setNormalTexture(IDrawable ... normalTexture) {
        this.normalTexture = normalTexture;
        return this;
    }
}

