/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.drawable;

import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.common.internal.Theme;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class TextRenderer {
    protected float maxWidth = -1.0f;
    protected float maxHeight = -1.0f;
    protected int x = 0;
    protected int y = 0;
    protected Alignment alignment = Alignment.TopLeft;
    protected float scale = 1.0f;
    protected boolean shadow = false;
    protected int color = Theme.INSTANCE.getText();
    protected boolean simulate;
    protected float lastWidth = 0.0f;
    protected float lastHeight = 0.0f;

    public void setAlignment(Alignment alignment, float maxWidth) {
        this.setAlignment(alignment, maxWidth, -1.0f);
    }

    public void setAlignment(Alignment alignment, float maxWidth, float maxHeight) {
        this.alignment = alignment;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void setPos(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setPos(Pos2d pos) {
        this.setPos(pos.x, pos.y);
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setSimulate(boolean simulate) {
        this.simulate = simulate;
    }

    public void draw(String text) {
        this.draw(Collections.singletonList(text));
    }

    public void draw(List<String> lines) {
        this.drawMeasuredLines(this.measureLines(lines));
    }

    protected void drawMeasuredLines(List<Pair<String, Float>> measuredLines) {
        this.drawMeasuredLines(measuredLines, Collections.emptyList(), false);
    }

    protected void drawMeasuredLines(List<Pair<String, Float>> measuredLines, List<Integer> colors, boolean hasSpaceAfterFirstLine) {
        float maxW = 0.0f;
        int y0 = this.getStartY(measuredLines.size());
        boolean addedExtraSpace = false;
        int EXTRA_SPACE = 2;
        for (int i = 0; i < measuredLines.size(); ++i) {
            Pair<String, Float> measuredLine = measuredLines.get(i);
            if (i < colors.size()) {
                this.setColor(colors.get(i));
            }
            int x0 = this.getStartX(((Float)measuredLine.getRight()).floatValue());
            maxW = Math.max(this.draw((String)measuredLine.getLeft(), x0, y0), maxW);
            y0 = (int)((float)y0 + this.getRenderHeight());
            if (!hasSpaceAfterFirstLine || addedExtraSpace || measuredLines.size() <= 1) continue;
            y0 += 2;
            addedExtraSpace = true;
        }
        this.lastWidth = this.maxWidth > 0.0f ? Math.min(maxW, this.maxWidth) : maxW;
        this.lastHeight = (float)measuredLines.size() * this.getRenderHeight() + (float)(addedExtraSpace ? 2 : 0) - this.getRenderYToSubtractAfterLastLineDraw();
        this.lastWidth = Math.max(0.0f, this.lastWidth - this.scale);
        this.lastHeight = Math.max(0.0f, this.lastHeight - this.scale);
    }

    public List<Pair<String, Float>> measureLines(List<String> lines) {
        ArrayList<Pair<String, Float>> measuredLines = new ArrayList<Pair<String, Float>>();
        for (String line : lines) {
            for (String subLine : this.wrapLine(line)) {
                float width = (float)TextRenderer.getFontRenderer().func_78256_a(subLine) * this.scale;
                measuredLines.add((Pair<String, Float>)Pair.of((Object)subLine, (Object)Float.valueOf(width)));
            }
        }
        return measuredLines;
    }

    public List<String> wrapLine(String line) {
        return this.maxWidth > 0.0f ? TextRenderer.getFontRenderer().func_78271_c(line, (int)(this.maxWidth / this.scale)) : Collections.singletonList(line);
    }

    public boolean wouldFit(List<String> text) {
        if (this.maxHeight > 0.0f && this.maxHeight < (float)text.size() * this.getFontHeight() - this.scale) {
            return false;
        }
        if (this.maxWidth > 0.0f) {
            for (String line : text) {
                if (!(this.maxWidth < (float)TextRenderer.getFontRenderer().func_78256_a(line))) continue;
                return false;
            }
        }
        return true;
    }

    public int getMaxWidth(List<String> lines) {
        if (lines.isEmpty()) {
            return 0;
        }
        List<Pair<String, Float>> measuredLines = this.measureLines(lines);
        float w = 0.0f;
        for (Pair<String, Float> measuredLine : measuredLines) {
            w = Math.max(w, ((Float)measuredLine.getRight()).floatValue());
        }
        return (int)Math.ceil(w);
    }

    protected int getStartY(int lines) {
        if (this.alignment.y >= 0 && this.maxHeight > 0.0f) {
            float height = (float)lines * this.getFontHeight() + (float)(Math.max(lines - 1, 0) * 1) - this.scale;
            if (this.alignment.y > 0) {
                return (int)((float)this.y + this.maxHeight - height);
            }
            return (int)((float)this.y + (this.maxHeight - height) / 2.0f);
        }
        return this.y;
    }

    protected int getStartX(float lineWidth) {
        if (this.maxWidth > 0.0f && this.alignment.x >= 0) {
            if (this.alignment.x > 0) {
                return (int)((float)this.x + this.maxWidth - lineWidth);
            }
            return (int)((float)this.x + (this.maxWidth - lineWidth) / 2.0f);
        }
        return this.x;
    }

    protected float draw(String text, float x, float y) {
        if (this.simulate) {
            return TextRenderer.getFontRenderer().func_78256_a(text);
        }
        GlStateManager.disableBlend();
        GlStateManager.pushMatrix();
        GlStateManager.scale(this.scale, this.scale, 0.0f);
        GL11.glDisable((int)2896);
        int width = TextRenderer.getFontRenderer().func_85187_a(text, (int)(x / this.scale), (int)(y / this.scale), this.color, this.shadow);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2896);
        GlStateManager.popMatrix();
        GlStateManager.enableBlend();
        return (float)width * this.scale;
    }

    public float getFontHeight() {
        return (float)TextRenderer.getFontRenderer().field_78288_b * this.scale;
    }

    public float getRenderHeight() {
        return (float)(TextRenderer.getFontRenderer().field_78288_b + 1) * this.scale;
    }

    public float getRenderYToSubtractAfterLastLineDraw() {
        return this.getRenderHeight() - this.getFontHeight();
    }

    public float getLastHeight() {
        return this.lastHeight;
    }

    public float getLastWidth() {
        return this.lastWidth;
    }

    public Size getLastSize() {
        return new Size(this.lastWidth, this.lastHeight);
    }

    @SideOnly(value=Side.CLIENT)
    public static FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }
}

