/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech;

import gregtech.api.enums.GTValues;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeBuilder;
import gttweaker.GTTweaker;
import gttweaker.mods.gregtech.GTRecipeMap;
import java.util.Arrays;
import java.util.Objects;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.RA2")
@ModOnly(value={"gregtech"})
public class RA2Builder {
    private GTRecipeBuilder recipeBuilder;

    public RA2Builder() {
    }

    public RA2Builder(GTRecipeBuilder recipeBuilder) {
        this.recipeBuilder = recipeBuilder;
    }

    @ZenMethod
    public static RA2Builder builder() {
        return new RA2Builder(GTValues.RA.stdBuilder());
    }

    @ZenMethod
    public RA2Builder noItemInputs() {
        return this;
    }

    @ZenMethod
    public RA2Builder itemInputs(IIngredient[] inputs) {
        this.recipeBuilder.itemInputs((ItemStack[])Arrays.stream(inputs).map(GTTweaker::getItemStackOrNull).filter(Objects::nonNull).toArray(ItemStack[]::new));
        return this;
    }

    @ZenMethod
    public RA2Builder noItemOutputs() {
        return this;
    }

    @ZenMethod
    public RA2Builder itemOutputs(IIngredient[] outputs) {
        this.recipeBuilder.itemOutputs((ItemStack[])Arrays.stream(outputs).map(GTTweaker::getItemStackOrNull).filter(Objects::nonNull).toArray(ItemStack[]::new));
        return this;
    }

    @ZenMethod
    public RA2Builder noFluidInputs() {
        return this;
    }

    @ZenMethod
    public RA2Builder fluidInputs(IIngredient[] inputs) {
        this.recipeBuilder.fluidInputs((FluidStack[])Arrays.stream(inputs).map(GTTweaker::getFluidStackOrNull).filter(Objects::nonNull).toArray(FluidStack[]::new));
        return this;
    }

    @ZenMethod
    public RA2Builder noFluidOutputs() {
        return this;
    }

    @ZenMethod
    public RA2Builder fluidOutputs(IIngredient[] outputs) {
        this.recipeBuilder.fluidOutputs((FluidStack[])Arrays.stream(outputs).map(GTTweaker::getFluidStackOrNull).filter(Objects::nonNull).toArray(FluidStack[]::new));
        return this;
    }

    @ZenMethod
    public RA2Builder duration(int duration) {
        this.recipeBuilder.duration(duration);
        return this;
    }

    @ZenMethod
    public RA2Builder eut(int eut) {
        this.recipeBuilder.eut(eut);
        return this;
    }

    @ZenMethod
    public RA2Builder outputChances(int[] chances) {
        this.recipeBuilder.outputChances(chances);
        return this;
    }

    @ZenMethod
    public RA2Builder specialValue(int specialValue) {
        this.recipeBuilder.specialValue(specialValue);
        return this;
    }

    @ZenMethod
    public RA2Builder specialItem(IIngredient specialItem) {
        this.recipeBuilder.special((Object)GTTweaker.getItemStackOrNull(specialItem));
        return this;
    }

    @ZenMethod
    public void addTo(String recipeMap) {
        GTRecipe recipe = this.recipeBuilder.build().orElse(null);
        if (recipe == null) {
            MineTweakerAPI.logError((String)"Could not build recipe!");
            return;
        }
        RecipeMap<?> map = GTRecipeMap.getRecipeMap(recipeMap);
        if (map == null) {
            MineTweakerAPI.logError((String)("Could not find recipe map named \"" + recipeMap + "\""));
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new RecipeAddAction(recipe, map));
    }

    public static class RecipeAddAction
    implements IUndoableAction {
        GTRecipe recipe;
        RecipeMap<?> map;

        public RecipeAddAction(GTRecipe recipe, RecipeMap<?> map) {
            this.recipe = recipe;
            this.map = map;
        }

        public void apply() {
            this.map.add(this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            this.map.getBackend().removeRecipe(this.recipe);
        }

        public String describe() {
            return "RA2 - Adding recipe";
        }

        public String describeUndo() {
            return "RA2 - Removing recipe";
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

