/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.inventory.filters;

import mods.railcraft.api.core.items.IStackFilter;
import net.minecraft.item.ItemStack;

public class ComplexStackFilter {
    public static IStackFilter and(IStackFilter ... filters) {
        return new AndFilter(filters);
    }

    public static IStackFilter or(IStackFilter ... filters) {
        return new OrFilter(filters);
    }

    public static IStackFilter not(IStackFilter filter) {
        return new NotFilter(filter);
    }

    private ComplexStackFilter() {
    }

    private static class AndFilter
    implements IStackFilter {
        private final IStackFilter[] filters;

        private AndFilter(IStackFilter ... filters) {
            this.filters = filters;
        }

        @Override
        public boolean matches(ItemStack stack) {
            if (stack == null) {
                return false;
            }
            for (IStackFilter filter : this.filters) {
                if (filter.matches(stack)) continue;
                return false;
            }
            return true;
        }
    }

    private static class OrFilter
    implements IStackFilter {
        private final IStackFilter[] filters;

        private OrFilter(IStackFilter ... filters) {
            this.filters = filters;
        }

        @Override
        public boolean matches(ItemStack stack) {
            if (stack == null) {
                return false;
            }
            for (IStackFilter filter : this.filters) {
                if (!filter.matches(stack)) continue;
                return true;
            }
            return false;
        }
    }

    private static class NotFilter
    implements IStackFilter {
        private final IStackFilter filter;

        private NotFilter(IStackFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean matches(ItemStack stack) {
            if (stack == null) {
                return false;
            }
            return !this.filter.matches(stack);
        }
    }
}

