/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.tracks.RailTools;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.tracks.TrackSpeed;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.carts.CartUtils;
import mods.railcraft.common.carts.EntityTunnelBore;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.carts.Train;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.misc.Vec2D;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.IMinecartCollisionHandler;
import net.minecraftforge.event.entity.minecart.MinecartCollisionEvent;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.event.entity.minecart.MinecartUpdateEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public final class MinecartHooks
implements IMinecartCollisionHandler {
    private static final float OPTIMAL_DISTANCE = 1.28f;
    private static final float COEF_SPRING = 0.2f;
    private static final float COEF_SPRING_PLAYER = 0.5f;
    private static final float COEF_RESTITUTION = 0.2f;
    private static final float COEF_DAMPING = 0.4f;
    private static final float CART_LENGTH = 1.22f;
    private static final float CART_WIDTH = 0.98f;
    private static final float COLLISION_EXPANSION = 0.2f;
    private static final int MAX_INTERACT_DIST_SQ = 25;
    private static MinecartHooks instance;

    private MinecartHooks() {
    }

    public static MinecartHooks getInstance() {
        if (instance == null) {
            instance = new MinecartHooks();
        }
        return instance;
    }

    @SubscribeEvent
    public void onItemUse(PlayerInteractEvent event) {
        Item item;
        EntityPlayer player = event.entityPlayer;
        World world = player.field_70170_p;
        if (Game.isNotHost(world)) {
            return;
        }
        ItemStack itemStack = player.func_70694_bm();
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && itemStack != null && (item = itemStack.func_77973_b()) != null && CartUtils.vanillaCartItemMap.containsKey(item)) {
            event.useItem = Event.Result.DENY;
            EntityMinecart placedCart = CartUtils.placeCart(CartUtils.vanillaCartItemMap.get(item), player.func_146103_bH(), itemStack, world, event.x, event.y, event.z);
            if (placedCart != null && !player.field_71075_bZ.field_75098_d) {
                --itemStack.field_77994_a;
            }
        }
    }

    public void onEntityCollision(EntityMinecart cart, Entity other) {
        int mountPrevention;
        if (Game.isNotHost(cart.field_70170_p) || other == cart.field_70153_n || !other.func_70089_S() || !cart.func_70089_S()) {
            return;
        }
        LinkageManager lm = LinkageManager.instance();
        EntityMinecart link = lm.getLinkedCartA(cart);
        if (link != null && (link == other || other == link.field_70153_n)) {
            return;
        }
        link = lm.getLinkedCartB(cart);
        if (link != null && (link == other || other == link.field_70153_n)) {
            return;
        }
        boolean isLiving = other instanceof EntityLivingBase;
        boolean isPlayer = other instanceof EntityPlayer;
        if (isLiving && !isPlayer && cart.canBeRidden() && !(other instanceof EntityIronGolem) && cart.field_70159_w * cart.field_70159_w + cart.field_70179_y * cart.field_70179_y > 0.001 && cart.field_70153_n == null && other.field_70154_o == null && (mountPrevention = cart.getEntityData().func_74762_e("MountPrevention")) <= 0) {
            other.func_70078_a((Entity)cart);
        }
        int i = MathHelper.func_76128_c((double)cart.field_70165_t);
        int j = MathHelper.func_76128_c((double)cart.field_70163_u);
        int k = MathHelper.func_76128_c((double)cart.field_70161_v);
        Block block = cart.field_70170_p.func_147439_a(i, j, k);
        if (isLiving && RailcraftBlocks.getBlockElevator() != null && block == RailcraftBlocks.getBlockElevator()) {
            return;
        }
        Vec2D cartPos = new Vec2D(cart.field_70165_t, cart.field_70161_v);
        Vec2D otherPos = new Vec2D(other.field_70165_t, other.field_70161_v);
        Vec2D unit = Vec2D.subtract(otherPos, cartPos);
        unit.normalize();
        double distance = cart.func_70032_d(other);
        double depth = distance - (double)1.28f;
        double forceX = 0.0;
        double forceZ = 0.0;
        if (depth < 0.0) {
            double spring = isPlayer ? 0.5 : (double)0.2f;
            double penaltyX = spring * depth * unit.getX();
            double penaltyZ = spring * depth * unit.getY();
            forceX += penaltyX;
            forceZ += penaltyZ;
            if (!isPlayer) {
                double impulseX = unit.getX();
                double impulseZ = unit.getY();
                impulseX *= -1.2000000029802322;
                impulseZ *= -1.2000000029802322;
                Vec2D cartVel = new Vec2D(cart.field_70159_w, cart.field_70179_y);
                Vec2D otherVel = new Vec2D(other.field_70159_w, other.field_70179_y);
                double dot = Vec2D.subtract(otherVel, cartVel).dotProduct(unit);
                impulseX *= dot;
                impulseZ *= dot;
                forceX -= (impulseX *= 0.5);
                forceZ -= (impulseZ *= 0.5);
            }
        }
        if (other instanceof EntityMinecart) {
            EntityMinecart otherCart = (EntityMinecart)other;
            if (!(cart.isPoweredCart() && !otherCart.isPoweredCart() || RailTools.isCartLockedDown(cart))) {
                cart.func_70024_g(forceX, 0.0, forceZ);
            }
            if (!(otherCart.isPoweredCart() && !cart.isPoweredCart() || RailTools.isCartLockedDown(otherCart))) {
                other.func_70024_g(-forceX, 0.0, -forceZ);
            }
        } else {
            Vec2D cartVel = new Vec2D(cart.field_70159_w + forceX, cart.field_70179_y + forceZ);
            Vec2D otherVel = new Vec2D(other.field_70159_w - forceX, other.field_70179_y - forceZ);
            double dot = Vec2D.subtract(otherVel, cartVel).dotProduct(unit);
            double dampX = (double)0.4f * dot * unit.getX();
            double dampZ = (double)0.4f * dot * unit.getY();
            forceX += dampX;
            forceZ += dampZ;
            if (!isPlayer) {
                other.func_70024_g(-forceX, 0.0, -forceZ);
            }
            if (!RailTools.isCartLockedDown(cart)) {
                cart.func_70024_g(forceX, 0.0, forceZ);
            }
        }
    }

    public AxisAlignedBB getCollisionBox(EntityMinecart cart, Entity other) {
        if (other instanceof EntityItem && RailcraftConfig.doCartsCollideWithItems()) {
            return other.field_70121_D;
        }
        if (other instanceof EntityPlayer) {
            return other.func_70104_M() ? other.field_70121_D : null;
        }
        return null;
    }

    public AxisAlignedBB getMinecartCollisionBox(EntityMinecart cart) {
        double yaw = Math.toRadians(cart.field_70177_z);
        double diff = 0.3200000077486038;
        double x = diff * Math.abs(Math.cos(yaw));
        double z = diff * Math.abs(Math.sin(yaw));
        return cart.field_70121_D.func_72314_b(x, (double)0.2f, z);
    }

    public AxisAlignedBB getBoundingBox(EntityMinecart cart) {
        if (cart == null || cart.field_70128_L) {
            return null;
        }
        if (RailcraftConfig.areCartsSolid()) {
            return cart.field_70121_D;
        }
        return null;
    }

    private void land(EntityMinecart cart) {
        cart.getEntityData().func_74768_a("Launched", 0);
        cart.setMaxSpeedAirLateral(EntityMinecart.defaultMaxSpeedAirLateral);
        cart.setMaxSpeedAirVertical(EntityMinecart.defaultMaxSpeedAirVertical);
        cart.setDragAir(EntityMinecart.defaultDragAir);
    }

    @SubscribeEvent
    public void onMinecartUpdate(MinecartUpdateEvent event) {
        byte elevator;
        int mountPrevention;
        EntityMinecart cart = event.minecart;
        NBTTagCompound data = cart.getEntityData();
        int x = (int)event.x;
        int y = (int)event.y;
        int z = (int)event.z;
        Block block = cart.field_70170_p.func_147439_a(x, y, z);
        int launched = data.func_74762_e("Launched");
        if (TrackTools.isRailBlock(block)) {
            cart.field_70143_R = 0.0f;
            if (cart.field_70153_n != null) {
                cart.field_70153_n.field_70143_R = 0.0f;
            }
            if (launched > 1) {
                this.land(cart);
            }
        } else if (launched == 1) {
            data.func_74768_a("Launched", 2);
            cart.setCanUseRail(true);
        } else if (launched > 1 && (cart.field_70122_E || cart.func_70055_a(Material.field_151594_q))) {
            this.land(cart);
        }
        if ((mountPrevention = data.func_74762_e("MountPrevention")) > 0) {
            data.func_74768_a("MountPrevention", --mountPrevention);
        }
        if ((elevator = data.func_74771_c("elevator")) > 0) {
            elevator = (byte)(elevator - 1);
            data.func_74774_a("elevator", elevator);
        }
        if (data.func_74767_n("explode")) {
            cart.getEntityData().func_74757_a("explode", false);
            CartUtils.explodeCart(cart);
        }
        if (data.func_74767_n("HighSpeed")) {
            if (CartUtils.cartVelocityIsLessThan(cart, 0.39f)) {
                data.func_74757_a("HighSpeed", false);
            } else if (!TrackSpeed.isTrackHighSpeedCapable(cart.field_70170_p, x, y, z)) {
                CartUtils.explodeCart(cart);
            }
        }
        cart.field_70159_w = Math.copySign(Math.min(Math.abs(cart.field_70159_w), 9.5), cart.field_70159_w);
        cart.field_70181_x = Math.copySign(Math.min(Math.abs(cart.field_70181_x), 9.5), cart.field_70181_x);
        cart.field_70179_y = Math.copySign(Math.min(Math.abs(cart.field_70179_y), 9.5), cart.field_70179_y);
    }

    @SubscribeEvent
    public void onMinecartEntityCollision(MinecartCollisionEvent event) {
        List<EntityMinecart> carts;
        EntityMinecart cart = event.minecart;
        Entity other = event.collider;
        if (other == cart.field_70153_n) {
            return;
        }
        if (other instanceof EntityMinecart) {
            LinkageManager.instance().tryAutoLink(cart, (EntityMinecart)other);
        }
        this.testHighSpeedCollision(cart, other);
        int i = MathHelper.func_76128_c((double)cart.field_70165_t);
        int j = MathHelper.func_76128_c((double)cart.field_70163_u);
        int k = MathHelper.func_76128_c((double)cart.field_70161_v);
        if (EntityMinecart.getCollisionHandler() != this && other instanceof EntityLivingBase && RailcraftBlocks.getBlockElevator() != null && cart.field_70170_p.func_147439_a(i, j, k) == RailcraftBlocks.getBlockElevator() && other.field_70121_D.field_72338_b < cart.field_70121_D.field_72337_e) {
            other.func_70091_d(0.0, cart.field_70121_D.field_72337_e - other.field_70121_D.field_72338_b, 0.0);
            other.field_70122_E = true;
        }
        if (MiscTools.getRand().nextFloat() < 0.001f && (carts = CartTools.getMinecartsAt(cart.field_70170_p, i, j, k, 0.0f)).size() >= 12) {
            this.primeToExplode(cart);
        }
    }

    private void testHighSpeedCollision(EntityMinecart cart, Entity other) {
        boolean highSpeed = cart.getEntityData().func_74767_n("HighSpeed");
        if (highSpeed) {
            boolean otherHighSpeed;
            if (other instanceof EntityMinecart && Train.areInSameTrain(cart, (EntityMinecart)other)) {
                return;
            }
            for (EntityMinecart c : Train.getTrain(cart)) {
                if (other != c.field_70153_n) continue;
                return;
            }
            if (other instanceof EntityMinecart && (!(otherHighSpeed = other.getEntityData().func_74767_n("HighSpeed")) || cart.field_70159_w > 0.0 ^ other.field_70159_w > 0.0 || cart.field_70179_y > 0.0 ^ other.field_70179_y > 0.0)) {
                this.primeToExplode(cart);
                return;
            }
            if (RailcraftConfig.isEntityExcludedFromHighSpeedExplosions(other)) {
                return;
            }
            this.primeToExplode(cart);
        }
    }

    private void primeToExplode(EntityMinecart cart) {
        cart.getEntityData().func_74757_a("explode", true);
    }

    @SubscribeEvent
    public void onMinecartInteract(MinecartInteractEvent event) {
        EntityMinecart cart = event.minecart;
        EntityPlayer player = event.player;
        if (!CartTools.doesCartHaveOwner(cart)) {
            CartTools.setCartOwner(cart, player);
        }
        if (!(cart instanceof EntityTunnelBore) && player.func_70068_e((Entity)cart) > 25.0) {
            event.setCanceled(true);
            return;
        }
        if (cart.field_70128_L) {
            event.setCanceled(true);
            return;
        }
        if (cart.canBeRidden()) {
            if (cart.field_70153_n != null && player.field_70154_o != cart) {
                event.setCanceled(true);
                return;
            }
            if (player.field_70154_o != null && player.field_70154_o != cart) {
                event.setCanceled(true);
                return;
            }
            if (player.field_70154_o != cart && player.func_70617_f_()) {
                event.setCanceled(true);
                return;
            }
        }
        if (!player.func_70685_l((Entity)cart)) {
            event.setCanceled(true);
        }
    }
}

