/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha.ai;

import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;

public class EntityAIMoveToBlock
extends EntityAIBase {
    private final EntityCreature entity;
    protected WorldCoordinate watchedBlock;
    private final int maxDist;
    private final float weight;
    private final Block searchedBlock;
    private final int searchedMeta;

    public EntityAIMoveToBlock(EntityCreature entity, Block searchedBlock, int searchedMeta, int maxDist) {
        this(entity, searchedBlock, searchedMeta, maxDist, 0.001f);
    }

    public EntityAIMoveToBlock(EntityCreature entity, Block searchedBlock, int searchedMeta, int maxDist, float weight) {
        this.entity = entity;
        this.searchedBlock = searchedBlock;
        this.searchedMeta = searchedMeta;
        this.maxDist = maxDist;
        this.weight = weight;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (this.entity.func_70681_au().nextFloat() >= this.weight) {
            return false;
        }
        if (!this.entity.field_70170_p.func_72935_r()) {
            return false;
        }
        if (this.watchedBlock == null || !this.isBlockValid()) {
            this.watchedBlock = WorldPlugin.findBlock(this.entity.field_70170_p, (int)this.entity.field_70165_t, (int)this.entity.field_70163_u, (int)this.entity.field_70161_v, this.maxDist, this.searchedBlock, this.searchedMeta);
        }
        return this.watchedBlock != null;
    }

    private boolean isBlockValid() {
        if (this.searchedBlock != WorldPlugin.getBlock((IBlockAccess)this.entity.field_70170_p, this.watchedBlock)) {
            return false;
        }
        return WorldPlugin.getDistanceSq(this.watchedBlock, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v) <= (double)(this.maxDist * this.maxDist);
    }

    public boolean func_75253_b() {
        return !this.entity.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        if (this.entity.func_70092_e((double)this.watchedBlock.x + 0.5, (double)this.watchedBlock.y + 0.5, (double)this.watchedBlock.z + 0.5) > 256.0) {
            Vec3 vec3 = RandomPositionGenerator.func_75464_a((EntityCreature)this.entity, (int)14, (int)3, (Vec3)Vec3.func_72443_a((double)((double)this.watchedBlock.x + 0.5), (double)((double)this.watchedBlock.y + 0.5), (double)((double)this.watchedBlock.z + 0.5)));
            if (vec3 != null) {
                this.move(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c);
            }
        } else {
            this.move((double)this.watchedBlock.x + 0.5, (double)this.watchedBlock.y + 0.5, (double)this.watchedBlock.z + 0.5);
        }
    }

    private void move(double x, double y, double z) {
        this.entity.func_70661_as().func_75492_a(x, y, z, 0.6);
    }

    public void func_75251_c() {
        this.watchedBlock = null;
    }
}

