/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render.carts;

import mods.railcraft.api.carts.locomotive.IRenderer;
import mods.railcraft.api.carts.locomotive.LocomotiveModelRenderer;
import mods.railcraft.api.carts.locomotive.LocomotiveRenderType;
import mods.railcraft.client.render.carts.LocomotiveRenderer;
import mods.railcraft.common.carts.EntityLocomotive;
import mods.railcraft.common.carts.ItemLocomotive;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderItemLocomotive
implements IItemRenderer,
IRenderer {
    private final LocomotiveRenderType renderType;
    private final EntityLocomotive entity;

    public RenderItemLocomotive(LocomotiveRenderType renderType, EntityLocomotive entity) {
        this.renderType = renderType;
        this.entity = entity;
    }

    public boolean handleRenderType(ItemStack stack, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case INVENTORY: {
                String rendererTag = ItemLocomotive.getModel(stack);
                LocomotiveModelRenderer renderer = this.renderType.getRenderer(rendererTag);
                if (renderer == null || !renderer.renderItemIn3D()) {
                    return false;
                }
            }
            case ENTITY: 
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack stack, IItemRenderer.ItemRendererHelper helper) {
        switch (helper) {
            case ENTITY_ROTATION: 
            case ENTITY_BOBBING: 
            case INVENTORY_BLOCK: {
                return true;
            }
        }
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        GL11.glPushMatrix();
        switch (type) {
            case EQUIPPED_FIRST_PERSON: {
                GL11.glTranslatef((float)0.5f, (float)0.4f, (float)0.0f);
                GL11.glRotatef((float)20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                this.render(stack, 0.6f);
                break;
            }
            case EQUIPPED: {
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
                GL11.glRotatef((float)-35.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)40.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                this.render(stack, 0.6f);
                break;
            }
            case INVENTORY: 
            case ENTITY: {
                GL11.glTranslatef((float)0.0f, (float)-0.1f, (float)0.0f);
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                this.render(stack, 0.8f);
            }
        }
        GL11.glPopMatrix();
    }

    @Override
    public void bindTex(ResourceLocation texture) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    private void render(ItemStack stack, float scale) {
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.entity.field_70177_z = 0.0f;
        this.entity.field_70125_A = 0.0f;
        this.entity.setModel(ItemLocomotive.getModel(stack));
        this.entity.setPrimaryColor(ItemLocomotive.getPrimaryColor(stack).ordinal());
        this.entity.setSecondaryColor(ItemLocomotive.getSecondaryColor(stack).ordinal());
        LocomotiveRenderer.INSTANCE.render(this, (EntityMinecart)this.entity, 1.0f, 1.0f);
        GL11.glPopAttrib();
    }
}

