/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.KryoException;

public class GenericsUtil {
    public static Type resolveType(Class fromClass, Class toClass, Type type) {
        if (type instanceof Class) {
            return type;
        }
        if (type instanceof TypeVariable) {
            return GenericsUtil.resolveTypeVariable(fromClass, toClass, type, true);
        }
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            int dimensions = 1;
            while ((type = ((GenericArrayType)type).getGenericComponentType()) instanceof GenericArrayType) {
                ++dimensions;
            }
            Type componentType = GenericsUtil.resolveType(fromClass, toClass, type);
            if (!(componentType instanceof Class)) {
                return type;
            }
            if (dimensions == 1) {
                return Array.newInstance((Class)componentType, 0).getClass();
            }
            return Array.newInstance((Class)componentType, new int[dimensions]).getClass();
        }
        if (type instanceof WildcardType) {
            Type upperBound = ((WildcardType)type).getUpperBounds()[0];
            if (upperBound != Object.class) {
                return GenericsUtil.resolveType(fromClass, toClass, upperBound);
            }
            Type[] lowerBounds = ((WildcardType)type).getLowerBounds();
            if (lowerBounds.length != 0) {
                return GenericsUtil.resolveType(fromClass, toClass, lowerBounds[0]);
            }
            return Object.class;
        }
        throw new KryoException("Unable to resolve type: " + type);
    }

    private static Type resolveTypeVariable(Class fromClass, Class current, Type type, boolean first) {
        Type genericSuper = current.getGenericSuperclass();
        if (!(genericSuper instanceof ParameterizedType)) {
            return type;
        }
        Class superClass = current.getSuperclass();
        if (superClass != fromClass) {
            Type resolved = GenericsUtil.resolveTypeVariable(fromClass, superClass, type, false);
            if (resolved instanceof Class) {
                return resolved;
            }
            type = resolved;
        }
        String name = type.toString();
        TypeVariable<Class<T>>[] params = superClass.getTypeParameters();
        int n = params.length;
        for (int i = 0; i < n; ++i) {
            TypeVariable param = params[i];
            if (!param.getName().equals(name)) continue;
            Type arg = ((ParameterizedType)genericSuper).getActualTypeArguments()[i];
            if (arg instanceof Class) {
                return arg;
            }
            if (arg instanceof ParameterizedType) {
                return GenericsUtil.resolveType(fromClass, current, arg);
            }
            if (arg instanceof GenericArrayType) {
                return GenericsUtil.resolveType(fromClass, current, arg);
            }
            if (!(arg instanceof TypeVariable)) continue;
            if (first) {
                return type;
            }
            return arg;
        }
        return type;
    }

    public static Type[] resolveTypeParameters(Class fromClass, Class toClass, Type type) {
        if (type instanceof ParameterizedType) {
            Type[] actualArgs = ((ParameterizedType)type).getActualTypeArguments();
            int n = actualArgs.length;
            Type[] generics = new Type[n];
            for (int i = 0; i < n; ++i) {
                generics[i] = GenericsUtil.resolveType(fromClass, toClass, actualArgs[i]);
            }
            return generics;
        }
        if (type instanceof GenericArrayType) {
            while ((type = ((GenericArrayType)type).getGenericComponentType()) instanceof GenericArrayType) {
            }
            return GenericsUtil.resolveTypeParameters(fromClass, toClass, type);
        }
        return null;
    }
}

