/*
 * Decompiled with CFR 0.152.
 */
package serverutils.net;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesConfig;
import serverutils.client.gui.GuiEditNBT;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.net.MessageToClient;
import serverutils.lib.net.NetworkWrapper;
import serverutils.net.ServerUtilitiesNetHandler;

public class MessageEditNBT
extends MessageToClient {
    private NBTTagCompound info;
    private NBTTagCompound mainNbt;

    public MessageEditNBT() {
    }

    public MessageEditNBT(NBTTagCompound i, NBTTagCompound nbt) {
        this.info = i;
        this.mainNbt = nbt;
        if (ServerUtilitiesConfig.debugging.log_config_editing) {
            ServerUtilities.LOGGER.info("Editing NBT: " + this.mainNbt);
        }
    }

    @Override
    public NetworkWrapper getWrapper() {
        return ServerUtilitiesNetHandler.FILES;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeNBT(this.info);
        data.writeNBT(this.mainNbt);
    }

    @Override
    public void readData(DataIn data) {
        this.info = data.readNBT();
        this.mainNbt = data.readNBT();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        new GuiEditNBT(this.info, this.mainNbt).openGui();
    }
}

