/*
 * Decompiled with CFR 0.152.
 */
package serverutils.mixins.early.minecraft.vanish;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.util.IChatComponent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import serverutils.lib.util.ServerUtils;
import serverutils.lib.util.permission.PermissionAPI;

@Mixin(value={ServerConfigurationManager.class})
public abstract class MixinServerConfigurationManager {
    @Shadow
    @Final
    public List<EntityPlayerMP> field_72404_b;
    @Shadow
    @Final
    private MinecraftServer field_72400_f;

    @WrapWithCondition(method={"initializeConnectionToPlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/management/ServerConfigurationManager;sendChatMsg(Lnet/minecraft/util/IChatComponent;)V")})
    private boolean serverutilities$skipMessageIfVanished(ServerConfigurationManager instance, IChatComponent component, @Local(argsOnly=true) EntityPlayerMP playerMP) {
        if (ServerUtils.isVanished((Entity)playerMP)) {
            this.serverutilities$sendMessageToAllowedPlayers(component);
            return false;
        }
        return true;
    }

    @WrapWithCondition(method={"sendPlayerInfoToAllPlayers"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/management/ServerConfigurationManager;sendPacketToAllPlayers(Lnet/minecraft/network/Packet;)V")})
    private boolean serverutilities$skipPacketIfVanished(ServerConfigurationManager instance, Packet packet, @Local EntityPlayerMP player) {
        if (ServerUtils.isVanished((Entity)player)) {
            this.serverutilities$sendPacketToAllowedPlayers(packet);
            return false;
        }
        return true;
    }

    @WrapWithCondition(method={"playerLoggedIn"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/management/ServerConfigurationManager;sendPacketToAllPlayers(Lnet/minecraft/network/Packet;)V")})
    private boolean serverutilities$skipPacketIfVanished2(ServerConfigurationManager instance, Packet packet, @Local(argsOnly=true) EntityPlayerMP playerMP) {
        if (ServerUtils.isVanished((Entity)playerMP)) {
            this.serverutilities$sendPacketToAllowedPlayers(packet);
            return false;
        }
        return true;
    }

    @WrapWithCondition(method={"playerLoggedIn"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/NetHandlerPlayServer;sendPacket(Lnet/minecraft/network/Packet;)V")})
    private boolean serverutilities$skipIfVanished(NetHandlerPlayServer instance, Packet packet, @Local(argsOnly=true) EntityPlayerMP player, @Local(ordinal=1) EntityPlayerMP playerToSend) {
        return PermissionAPI.hasPermission((EntityPlayer)player, "serverutilities.vanish.see") || !ServerUtils.isVanished((Entity)playerToSend);
    }

    @Redirect(method={"getAllUsernames"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayerMP;getCommandSenderName()Ljava/lang/String;"))
    private String serverutilities$removeVanished(EntityPlayerMP player) {
        if (ServerUtils.isVanished((Entity)player)) {
            return "";
        }
        return player.func_70005_c_();
    }

    @Unique
    private void serverutilities$sendPacketToAllowedPlayers(Packet packet) {
        for (EntityPlayerMP player : this.field_72404_b) {
            if (!PermissionAPI.hasPermission((EntityPlayer)player, "serverutilities.vanish.see")) continue;
            player.field_71135_a.func_147359_a(packet);
        }
    }

    @Unique
    private void serverutilities$sendMessageToAllowedPlayers(IChatComponent component) {
        this.field_72400_f.func_145747_a(component);
        for (EntityPlayerMP player : this.field_72404_b) {
            if (!PermissionAPI.hasPermission((EntityPlayer)player, "serverutilities.vanish.see")) continue;
            player.func_145747_a(component);
        }
    }
}

