/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.config;

import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IChatComponent;
import serverutils.lib.config.ConfigValue;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.io.DataReader;
import serverutils.lib.util.JsonUtils;

public class ConfigTextComponent
extends ConfigValue {
    public static final String ID = "text_component";
    private IChatComponent value;

    public ConfigTextComponent(IChatComponent c) {
        this.value = c;
    }

    @Override
    public String getId() {
        return ID;
    }

    public IChatComponent getText() {
        return this.value;
    }

    public void setText(IChatComponent c) {
        this.value = c;
    }

    @Override
    public String getString() {
        return JsonUtils.serializeTextComponent(this.getText()).toString();
    }

    @Override
    public boolean setValueFromString(@Nullable ICommandSender sender, String string, boolean simulate) {
        IChatComponent component = JsonUtils.deserializeTextComponent(DataReader.get(string).safeJson());
        if (component != null) {
            if (!simulate) {
                this.setText(component);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean getBoolean() {
        return !this.getString().isEmpty();
    }

    @Override
    public int getInt() {
        return this.getString().length();
    }

    @Override
    public ConfigTextComponent copy() {
        return new ConfigTextComponent(this.getText());
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String key) {
        nbt.func_74782_a(key, JsonUtils.toNBT(JsonUtils.serializeTextComponent(this.getText())));
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String key) {
        this.setText(JsonUtils.deserializeTextComponent(JsonUtils.toJson(nbt.func_74781_a(key))));
    }

    @Override
    public void writeData(DataOut data) {
        data.writeTextComponent(this.getText());
    }

    @Override
    public void readData(DataIn data) {
        this.setText(data.readTextComponent());
    }

    @Override
    public IChatComponent getStringForGUI() {
        return this.getText().func_150259_f();
    }

    @Override
    public void setValueFromOtherValue(ConfigValue value) {
        if (value instanceof ConfigTextComponent) {
            this.setText(((ConfigTextComponent)value).getText().func_150259_f());
        } else {
            super.setValueFromOtherValue(value);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getText().func_150260_c().isEmpty();
    }
}

