/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.config;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import serverutils.lib.config.ConfigValue;
import serverutils.lib.config.ConfigValueInstance;
import serverutils.lib.icon.Color4I;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;

public class ConfigString
extends ConfigValue {
    public static final String ID = "string";
    public static final Color4I COLOR = Color4I.rgb(16755273);
    private String value;
    private Pattern pattern;

    public ConfigString(String v) {
        this(v, null);
    }

    public ConfigString(String v, @Nullable Pattern p) {
        this.value = v;
        this.pattern = p;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getString() {
        return this.value;
    }

    public void setString(String v) {
        this.value = v;
    }

    @Nullable
    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(@Nullable Pattern p) {
        this.pattern = p;
    }

    @Override
    public boolean getBoolean() {
        return this.getString().equals("true");
    }

    @Override
    public int getInt() {
        return Integer.parseInt(this.getString());
    }

    @Override
    public double getDouble() {
        return Double.parseDouble(this.getString());
    }

    @Override
    public long getLong() {
        return Long.parseLong(this.getString());
    }

    @Override
    public ConfigString copy() {
        return new ConfigString(this.getString(), this.getPattern());
    }

    @Override
    public Color4I getColor() {
        return COLOR;
    }

    @Override
    public IChatComponent getStringForGUI() {
        return new ChatComponentText('\"' + this.getString() + '\"');
    }

    @Override
    public boolean setValueFromString(@Nullable ICommandSender sender, String string, boolean simulate) {
        if (string.length() >= 2 && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            return this.setValueFromString(sender, string.substring(1, string.length() - 1), simulate);
        }
        if (this.getPattern() != null && !this.getPattern().matcher(string).matches()) {
            return false;
        }
        if (!simulate) {
            this.setString(string);
        }
        return true;
    }

    @Override
    public void addInfo(ConfigValueInstance inst, List<String> list) {
        super.addInfo(inst, list);
        if (this.getPattern() != null) {
            list.add(EnumChatFormatting.AQUA + "Regex: " + EnumChatFormatting.RESET + this.getPattern().pattern());
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String key) {
        this.value = this.getString();
        if (!this.value.isEmpty()) {
            nbt.func_74778_a(key, this.value);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String key) {
        this.setString(nbt.func_74779_i(key));
    }

    @Override
    public void writeData(DataOut data) {
        data.writeString(this.getString());
        data.writeString(this.getPattern() == null ? "" : this.getPattern().pattern());
    }

    @Override
    public void readData(DataIn data) {
        this.setString(data.readString());
        String p = data.readString();
        this.setPattern(p.isEmpty() ? null : Pattern.compile(p));
    }

    @Override
    public boolean isEmpty() {
        return this.getString().isEmpty();
    }

    @Override
    public void setValueFromOtherValue(ConfigValue value) {
        this.setString(value.getString());
    }

    public static class SimpleString
    extends ConfigString {
        private final Supplier<String> get;
        private final Consumer<String> set;

        public SimpleString(Supplier<String> g, Consumer<String> s, @Nullable Pattern pattern) {
            super("", pattern);
            this.get = g;
            this.set = s;
        }

        @Override
        public String getString() {
            return this.get.get();
        }

        @Override
        public void setString(String v) {
            this.set.accept(v);
        }
    }
}

