/*
 * Decompiled with CFR 0.152.
 */
package serverutils.invsee;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import serverutils.invsee.inventories.IModdedInventory;
import serverutils.invsee.inventories.InvSeeInventories;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.gui.ContainerBase;

public class InvseeContainer
extends ContainerBase {
    private final Map<InvSeeInventories, IInventory> inventories;
    private final ForgePlayer otherPlayer;
    private final Map<InvSeeInventories, List<Slot>> moddedInventorySlots = new HashMap<InvSeeInventories, List<Slot>>();
    private final Set<InvSeeInventories> modifiedInventories = new HashSet<InvSeeInventories>();
    private InvSeeInventories activeInventory;
    private int playerSlotStart;

    public InvseeContainer(Map<InvSeeInventories, IInventory> moddedInventories, EntityPlayer player, @Nullable ForgePlayer otherPlayer) {
        super(player);
        this.inventories = moddedInventories;
        this.otherPlayer = otherPlayer;
        for (Map.Entry<InvSeeInventories, IInventory> entry : moddedInventories.entrySet()) {
            IModdedInventory moddedInventory = entry.getKey().getNullableInventory();
            if (moddedInventory == null) continue;
            IInventory inventory = entry.getValue();
            List inventorySlots = this.moddedInventorySlots.computeIfAbsent(entry.getKey(), a -> new ArrayList(inventory.func_70302_i_()));
            int slotsInRow = 0;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                Slot slot;
                if (slotsInRow == 9) {
                    slotsInRow = 0;
                }
                if ((slot = moddedInventory.getSlot(player, inventory, i, 8 + slotsInRow++ * 18, 54 - i / 9 * 18)) != null) {
                    inventorySlots.add(slot);
                    continue;
                }
                if (slotsInRow <= 0) continue;
                --slotsInRow;
            }
            inventorySlots.sort(Comparator.comparingInt(Slot::getSlotIndex));
        }
        this.setActiveInventory(InvSeeInventories.MAIN);
    }

    public void setActiveInventory(InvSeeInventories inventory) {
        this.activeInventory = inventory;
        this.field_75151_b.clear();
        for (Slot slot : this.moddedInventorySlots.get((Object)inventory)) {
            this.func_75146_a(slot);
        }
        this.playerSlotStart = this.field_75151_b.size();
        this.addPlayerSlots(8, 85);
        this.func_75142_b();
    }

    public InvSeeInventories getActiveInventory() {
        return this.activeInventory;
    }

    public int getHighestSlot() {
        return this.field_75151_b.stream().mapToInt(e -> e.field_75221_f).min().orElse(0);
    }

    public int getLowestSlot() {
        return this.field_75151_b.stream().mapToInt(e -> e.field_75221_f).max().orElse(0);
    }

    @Override
    public int getNonPlayerSlots() {
        return this.playerSlotStart;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (!this.player.field_70170_p.field_72995_K && this.otherPlayer != null && this.otherPlayer.isOnline()) {
            Container container = this.otherPlayer.getPlayer().field_71070_bA;
            if (!container.field_75149_d.contains((EntityPlayerMP)this.player)) {
                container.func_75142_b();
            }
        }
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!player.field_70170_p.field_72995_K && this.otherPlayer != null) {
            ArrayList<InvSeeInventories> modifiedInventories = new ArrayList<InvSeeInventories>(this.modifiedInventories);
            modifiedInventories.sort(Comparator.comparingInt(Enum::ordinal));
            for (InvSeeInventories inventory : modifiedInventories) {
                IModdedInventory moddedInventory = inventory.getNullableInventory();
                if (moddedInventory == null) continue;
                moddedInventory.saveInventory(this.otherPlayer, this.inventories.get((Object)inventory));
            }
        }
    }

    public ItemStack func_75144_a(int slotId, int clickedButton, int mode, EntityPlayer player) {
        this.modifiedInventories.add(this.activeInventory);
        return super.func_75144_a(slotId, clickedButton, mode, player);
    }
}

