/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command;

import java.util.HashSet;
import java.util.Map;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import serverutils.lib.command.CmdBase;
import serverutils.lib.util.NBTUtils;

public class CmdDumpChunkloaders
extends CmdBase {
    public CmdDumpChunkloaders() {
        super("dump_chunkloaders", CmdBase.Level.OP_OR_SP);
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        for (WorldServer world : DimensionManager.getWorlds()) {
            HashSet<ForgeChunkManager.Ticket> set = new HashSet<ForgeChunkManager.Ticket>();
            for (Map.Entry entry : ForgeChunkManager.getPersistentChunksFor((World)world).entries()) {
                set.add((ForgeChunkManager.Ticket)entry.getValue());
            }
            if (set.isEmpty()) continue;
            sender.func_145747_a((IChatComponent)new ChatComponentText("- DIM " + world.field_73011_w.field_76574_g + ":"));
            for (ForgeChunkManager.Ticket ticket : set) {
                ChatComponentText title = new ChatComponentText(String.format("#%08x", ticket.hashCode()));
                title.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(ticket.getChunkList().size() + " chunks")));
                ChatComponentText owner = new ChatComponentText("Owner");
                owner.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(ticket.getModId() + " : " + ticket.getEntity())));
                ChatComponentText data = new ChatComponentText("Data");
                data.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(NBTUtils.getColoredNBTString((NBTBase)ticket.getModData()))));
                ChatComponentText chunks = new ChatComponentText("Chunks");
                int minX = Integer.MAX_VALUE;
                int minZ = Integer.MAX_VALUE;
                int maxX = Integer.MIN_VALUE;
                int maxZ = Integer.MIN_VALUE;
                for (ChunkCoordIntPair pos : ticket.getChunkList()) {
                    if (pos.field_77276_a < minX) {
                        minX = pos.field_77276_a;
                    }
                    if (pos.field_77275_b < minZ) {
                        minZ = pos.field_77275_b;
                    }
                    if (pos.field_77276_a > maxX) {
                        maxX = pos.field_77276_a;
                    }
                    if (pos.field_77275_b <= maxZ) continue;
                    maxZ = pos.field_77275_b;
                }
                int x = (minX + maxX) * 8 + 8;
                int z = (minZ + maxZ) * 8 + 8;
                world.func_72938_d(x, z);
                int y = world.func_72825_h(x, z);
                chunks.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText("(" + x + ',' + y + ',' + z + ") ; " + ticket.getChunkList().toString())));
                chunks.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tp " + x + " " + y + " " + z));
                sender.func_145747_a(new ChatComponentText("").func_150257_a((IChatComponent)title).func_150258_a(" | ").func_150257_a((IChatComponent)owner).func_150258_a(" | ").func_150257_a((IChatComponent)data).func_150258_a(" | ").func_150257_a((IChatComponent)chunks));
            }
        }
    }
}

