/*
 * Decompiled with CFR 0.152.
 */
package singulariteam.eternalsingularity.render;

import fox.spiteful.avaritia.render.ICosmicRenderItem;
import fox.spiteful.avaritia.render.IHaloRenderItem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import singulariteam.eternalsingularity.render.CosmicRenderStuffs;

public class EternalItemRenderer
implements IItemRenderer {
    public Random rand = new Random();

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION || helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        boolean renderHalo = false;
        boolean renderPulse = false;
        int spread = 0;
        IIcon halo = null;
        int haloColour = 0;
        Item itype = item.func_77973_b();
        if (itype instanceof IHaloRenderItem) {
            IHaloRenderItem ihri = (IHaloRenderItem)itype;
            spread = ihri.getHaloSize(item);
            halo = ihri.getHaloTexture(item);
            haloColour = ihri.getHaloColour(item);
            renderHalo = ihri.drawHalo(item);
            renderPulse = ihri.drawPulseEffect(item);
        }
        RenderItem r = RenderItem.getInstance();
        Minecraft mc = Minecraft.func_71410_x();
        Tessellator t = Tessellator.field_78398_a;
        this.processLightLevel(type, item, data);
        switch (type) {
            case ENTITY: {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)0.0f);
                if (item.func_82839_y()) {
                    GL11.glTranslatef((float)0.0f, (float)-0.3f, (float)0.01f);
                }
                this.render(item, null);
                GL11.glPopMatrix();
                break;
            }
            case EQUIPPED: {
                this.render(item, data[1] instanceof EntityPlayer ? (EntityPlayer)data[1] : null);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.render(item, data[1] instanceof EntityPlayer ? (EntityPlayer)data[1] : null);
                break;
            }
            case INVENTORY: {
                GL11.glPushMatrix();
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                RenderHelper.func_74520_c();
                GL11.glDisable((int)3008);
                GL11.glDisable((int)2929);
                if (renderHalo) {
                    float ca = (float)(haloColour >> 24 & 0xFF) / 255.0f;
                    float cr = (float)(haloColour >> 16 & 0xFF) / 255.0f;
                    float cg = (float)(haloColour >> 8 & 0xFF) / 255.0f;
                    float cb = (float)(haloColour & 0xFF) / 255.0f;
                    GL11.glColor4f((float)cr, (float)cg, (float)cb, (float)ca);
                    t.func_78382_b();
                    t.func_78374_a((double)(0 - spread), (double)(0 - spread), 0.0, (double)halo.func_94209_e(), (double)halo.func_94206_g());
                    t.func_78374_a((double)(0 - spread), (double)(16 + spread), 0.0, (double)halo.func_94209_e(), (double)halo.func_94210_h());
                    t.func_78374_a((double)(16 + spread), (double)(16 + spread), 0.0, (double)halo.func_94212_f(), (double)halo.func_94210_h());
                    t.func_78374_a((double)(16 + spread), (double)(0 - spread), 0.0, (double)halo.func_94212_f(), (double)halo.func_94206_g());
                    t.func_78381_a();
                }
                if (renderPulse) {
                    GL11.glPushMatrix();
                    double xs = this.rand.nextGaussian() * 0.15 + 0.95;
                    double ox = (1.0 - xs) / 2.0;
                    GL11.glEnable((int)3042);
                    GL11.glTranslated((double)(ox * 16.0), (double)(ox * 16.0), (double)1.0);
                    GL11.glScaled((double)xs, (double)xs, (double)1.0);
                    IIcon icon = item.func_77973_b().getIcon(item, 0);
                    t.func_78382_b();
                    t.func_78369_a(1.0f, 1.0f, 1.0f, 0.6f);
                    t.func_78374_a(0.0 - ox, 0.0 - ox, 0.0, (double)icon.func_94209_e(), (double)icon.func_94206_g());
                    t.func_78374_a(0.0 - ox, 16.0 + ox, 0.0, (double)icon.func_94209_e(), (double)icon.func_94210_h());
                    t.func_78374_a(16.0 + ox, 16.0 + ox, 0.0, (double)icon.func_94212_f(), (double)icon.func_94210_h());
                    t.func_78374_a(16.0 + ox, 0.0 - ox, 0.0, (double)icon.func_94212_f(), (double)icon.func_94206_g());
                    t.func_78381_a();
                    GL11.glPopMatrix();
                }
                r.renderItemIntoGUI(mc.field_71466_p, mc.func_110434_K(), item, 0, 0, true);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)32826);
                GL11.glEnable((int)2929);
                r.field_77024_a = true;
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                RenderHelper.func_74520_c();
                GL11.glDisable((int)3008);
                GL11.glDisable((int)2929);
                r.renderItemIntoGUI(mc.field_71466_p, mc.func_110434_K(), item, 0, 0, true);
                if (item.func_77973_b() instanceof ICosmicRenderItem) {
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    RenderHelper.func_74520_c();
                    GL11.glDisable((int)3008);
                    GL11.glDisable((int)2929);
                    ICosmicRenderItem icri = (ICosmicRenderItem)item.func_77973_b();
                    CosmicRenderStuffs.cosmicOpacity = icri.getMaskMultiplier(item, null);
                    CosmicRenderStuffs.inventoryRender = true;
                    CosmicRenderStuffs.useShader();
                    IIcon cosmicicon = icri.getMaskTexture(item, null);
                    GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
                    float minu = cosmicicon.func_94209_e();
                    float maxu = cosmicicon.func_94212_f();
                    float minv = cosmicicon.func_94206_g();
                    float maxv = cosmicicon.func_94210_h();
                    t.func_78382_b();
                    t.func_78374_a(0.0, 0.0, 0.0, (double)minu, (double)minv);
                    t.func_78374_a(0.0, 16.0, 0.0, (double)minu, (double)maxv);
                    t.func_78374_a(16.0, 16.0, 0.0, (double)maxu, (double)maxv);
                    t.func_78374_a(16.0, 0.0, 0.0, (double)maxu, (double)minv);
                    t.func_78381_a();
                    CosmicRenderStuffs.releaseShader();
                    CosmicRenderStuffs.inventoryRender = false;
                }
                GL11.glEnable((int)3008);
                GL11.glEnable((int)32826);
                GL11.glEnable((int)2929);
                r.field_77024_a = true;
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
                break;
            }
        }
    }

    public void render(ItemStack item, EntityPlayer player) {
        int passes = 1;
        if (item.func_77973_b().func_77623_v()) {
            passes = item.func_77973_b().getRenderPasses(item.func_77960_j());
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float scale = 0.0625f;
        for (int i = 0; i < passes; ++i) {
            IIcon icon = this.getStackIcon(item, i, player);
            float f = icon.func_94209_e();
            float f1 = icon.func_94212_f();
            float f2 = icon.func_94206_g();
            float f3 = icon.func_94210_h();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)f1, (float)f2, (float)f, (float)f3, (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)scale);
        }
        if (item.func_77973_b() instanceof ICosmicRenderItem) {
            GL11.glDisable((int)3008);
            GL11.glDepthFunc((int)514);
            ICosmicRenderItem icri = (ICosmicRenderItem)item.func_77973_b();
            CosmicRenderStuffs.cosmicOpacity = icri.getMaskMultiplier(item, player);
            CosmicRenderStuffs.useShader();
            IIcon cosmicicon = icri.getMaskTexture(item, player);
            float minu = cosmicicon.func_94209_e();
            float maxu = cosmicicon.func_94212_f();
            float minv = cosmicicon.func_94206_g();
            float maxv = cosmicicon.func_94210_h();
            ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)maxu, (float)minv, (float)minu, (float)maxv, (int)cosmicicon.func_94211_a(), (int)cosmicicon.func_94216_b(), (float)scale);
            CosmicRenderStuffs.releaseShader();
            GL11.glDepthFunc((int)515);
            GL11.glEnable((int)3008);
        }
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void processLightLevel(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                EntityItem ent = (EntityItem)data[1];
                if (ent == null) break;
                CosmicRenderStuffs.setLightFromLocation(ent.field_70170_p, MathHelper.func_76128_c((double)ent.field_70165_t), MathHelper.func_76128_c((double)ent.field_70163_u), MathHelper.func_76128_c((double)ent.field_70161_v));
                break;
            }
            case EQUIPPED: {
                EntityLivingBase ent = (EntityLivingBase)data[1];
                if (ent == null) break;
                CosmicRenderStuffs.setLightFromLocation(ent.field_70170_p, MathHelper.func_76128_c((double)ent.field_70165_t), MathHelper.func_76128_c((double)ent.field_70163_u), MathHelper.func_76128_c((double)ent.field_70161_v));
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                EntityLivingBase ent = (EntityLivingBase)data[1];
                if (ent == null) break;
                CosmicRenderStuffs.setLightFromLocation(ent.field_70170_p, MathHelper.func_76128_c((double)ent.field_70165_t), MathHelper.func_76128_c((double)ent.field_70163_u), MathHelper.func_76128_c((double)ent.field_70161_v));
                break;
            }
            case INVENTORY: {
                CosmicRenderStuffs.setLightLevel(1.2f);
                return;
            }
            default: {
                CosmicRenderStuffs.setLightLevel(1.0f);
                return;
            }
        }
    }

    public IIcon getStackIcon(ItemStack stack, int pass, EntityPlayer player) {
        return stack.func_77973_b().getIcon(stack, pass);
    }
}

