/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.popups;

import betterquesting.api2.client.gui.SceneController;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.resources.textures.ColorTexture;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.core.BetterQuesting;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.lwjgl.util.vector.ReadableVector4f;
import org.lwjgl.util.vector.Vector4f;

public class PopWaitExternalEvent<T>
extends CanvasEmpty {
    private String message;
    private final IGuiTexture icon;
    private final CompletableFuture<T> future;
    private PanelTextBox label;

    public PopWaitExternalEvent(@Nonnull String message) {
        this(message, null);
    }

    public PopWaitExternalEvent(@Nonnull String message, @Nullable IGuiTexture icon) {
        super(new GuiTransform(GuiAlign.FULL_BOX));
        this.message = message;
        this.icon = icon;
        this.future = new CompletableFuture();
    }

    @Override
    public void initPanel() {
        super.initPanel();
        this.addPanel(new PanelGeneric(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 1), new ColorTexture(new GuiColorStatic(Integer.MIN_VALUE))));
        CanvasTextured cvBox = new CanvasTextured(new GuiTransform((ReadableVector4f)new Vector4f(0.2f, 0.3f, 0.8f, 0.6f)), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel(cvBox);
        if (this.icon != null) {
            CanvasTextured icoFrame = new CanvasTextured(new GuiTransform((ReadableVector4f)new Vector4f(0.5f, 0.3f, 0.5f, 0.3f), -16, -40, 32, 32, 0), PresetTexture.PANEL_MAIN.getTexture());
            this.addPanel(icoFrame);
            icoFrame.addPanel(new PanelGeneric(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(8, 8, 8, 8), 0), this.icon));
        }
        this.label = new PanelTextBox(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(8, 8, 8, 8), 0), this.message).setAlignment(1);
        cvBox.addPanel(this.label);
    }

    @Override
    public void drawPanel(int mx, int my, float partialTick) {
        super.drawPanel(mx, my, partialTick);
        if (this.future.isDone()) {
            if (SceneController.getActiveScene() != null) {
                SceneController.getActiveScene().closePopup();
            }
            this.handleComplete();
        }
    }

    protected void handleComplete() {
        T v;
        if (this.future.isCancelled()) {
            this.onCancel();
            return;
        }
        try {
            v = this.future.get();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        catch (ExecutionException e) {
            this.onError(e);
            return;
        }
        this.onComplete(v);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
        this.label.setText(message);
    }

    public void complete(T val) {
        this.future.complete(val);
    }

    public void fail(Throwable ex) {
        this.future.completeExceptionally(ex);
    }

    public void cancel() {
        this.future.cancel(true);
    }

    public void ensureDone() {
        if (!this.future.isDone()) {
            this.future.cancel(true);
        }
    }

    protected void onComplete(T future) {
    }

    protected void onCancel() {
    }

    protected void onError(ExecutionException e) {
        BetterQuesting.logger.error("External Event Error", (Throwable)e);
    }

    @Override
    public boolean onMouseClick(int mx, int my, int click) {
        super.onMouseClick(mx, my, click);
        return true;
    }

    @Override
    public boolean onMouseRelease(int mx, int my, int click) {
        super.onMouseRelease(mx, my, click);
        return true;
    }

    @Override
    public boolean onMouseScroll(int mx, int my, int scroll) {
        super.onMouseScroll(mx, my, scroll);
        return true;
    }

    @Override
    public boolean onKeyTyped(char c, int keycode) {
        super.onKeyTyped(c, keycode);
        return true;
    }
}

