/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.api.IPointable;
import openblocks.common.entity.EntityItemProjectile;
import openblocks.rpc.ITriggerable;
import openmods.Log;
import openmods.api.ISurfaceAttachment;
import openmods.inventory.legacy.ItemDistribution;
import openmods.sync.SyncableDouble;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.InventoryUtils;
import openmods.utils.render.GeometryUtils;

public class TileEntityCannon
extends SyncedTileEntity
implements IPointable,
ISurfaceAttachment,
ITriggerable {
    private static final int YAW_OFFSET_DEGREES = -90;
    private static final int KNOB_YAW_CHANGE_SPEED = 3;
    private static final int KNOB_PITCH_CHANGE_SPEED = 20;
    private static final int KNOB_VEL_CHANGE_SPEED = 20;
    private static final int KNOB_LOB_MINIMUM_VALUE = 20;
    private static final int KNOB_LOB_MAXIMUM_VALUE = 75;
    private static final int KNOB_LOB_VERTICAL_MUL = 4;
    private static final int KNOB_LOB_HORIZONTAL_MUL = 1;
    private static final int KNOB_LOB_BONUS = 5;
    public SyncableDouble targetPitch;
    public SyncableDouble targetYaw;
    public SyncableDouble targetSpeed;
    public double currentPitch = 45.0;
    public double currentYaw = 0.0;
    private double currentSpeed = 1.4;
    public Vec3 motion;
    public boolean renderLine = true;
    private int ticksSinceLastFire = Integer.MAX_VALUE;
    private Vec3 projectileOrigin = null;

    protected void createSyncedFields() {
        this.targetPitch = new SyncableDouble();
        this.targetYaw = new SyncableDouble();
        this.targetSpeed = new SyncableDouble(1.4);
    }

    @SideOnly(value=Side.CLIENT)
    public void prepareForInventoryRender(Block block, int metadata) {
        super.prepareForInventoryRender(block, metadata);
        this.renderLine = false;
    }

    public void func_145845_h() {
        this.checkOrigin();
        if (Double.isNaN(this.currentPitch)) {
            Log.warn((String)"Pitch was NaN", (Object[])new Object[0]);
            this.currentPitch = 45.0;
            this.targetPitch.set(this.currentPitch);
        }
        if (Double.isNaN(this.currentYaw)) {
            Log.warn((String)"Yaw was NaN", (Object[])new Object[0]);
            this.currentYaw = 0.0;
        }
        super.func_145845_h();
        this.currentPitch -= (this.currentPitch - this.targetPitch.get()) / 20.0;
        this.currentYaw = GeometryUtils.normalizeAngle((double)this.currentYaw);
        double targetYaw = GeometryUtils.normalizeAngle((double)this.targetYaw.get());
        if (Math.abs(this.currentYaw - targetYaw) < 3.0) {
            this.currentYaw = targetYaw;
        } else {
            double dist = GeometryUtils.getAngleDistance((double)this.currentYaw, (double)targetYaw);
            this.currentYaw += 3.0 * Math.signum(dist);
        }
        this.currentSpeed -= (this.currentSpeed - this.targetSpeed.get()) / 20.0;
        this.invalidateMotion();
        if (!this.field_145850_b.field_72995_K) {
            ItemStack stack;
            if (this.field_145850_b.func_82737_E() % 20L == 0L && this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) && (stack = this.findStack()) != null) {
                this.fireStack(stack);
            }
        } else if (this.ticksSinceLastFire < 100) {
            ++this.ticksSinceLastFire;
        }
    }

    private ItemStack findStack() {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            ItemStack stack;
            IInventory inventory = InventoryUtils.getInventory((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (ForgeDirection)direction);
            if (inventory == null || (stack = ItemDistribution.removeFromFirstNonEmptySlot((IInventory)inventory)) == null) continue;
            return stack;
        }
        return null;
    }

    private void fireStack(ItemStack stack) {
        ITriggerable rpc = (ITriggerable)this.createServerRpcProxy(ITriggerable.class, new Class[0]);
        rpc.trigger();
        EntityItemProjectile item = new EntityItemProjectile(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, stack);
        item.field_145804_b = 20;
        Vec3 motion = this.getMotion();
        item.field_70159_w = motion.field_72450_a;
        item.field_70181_x = motion.field_72448_b;
        item.field_70179_y = motion.field_72449_c;
        this.field_145850_b.func_72838_d((Entity)item);
        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "openblocks:cannon.activate", 0.2f, 1.0f);
    }

    @Override
    public void trigger() {
        this.ticksSinceLastFire = 0;
        double pitchRad = Math.toRadians(this.currentYaw - 90.0);
        double x = -0.5 * Math.cos(pitchRad);
        double z = -0.5 * Math.sin(pitchRad);
        for (int i = 0; i < 20; ++i) {
            this.field_145850_b.func_72869_a((i < 4 ? "large" : "") + "smoke", x + (double)this.field_145851_c + 0.3 + this.field_145850_b.field_73012_v.nextDouble() * 0.4, (double)this.field_145848_d + 0.7, z + (double)this.field_145849_e + 0.3 + this.field_145850_b.field_73012_v.nextDouble() * 0.4, 0.0, 0.0, 0.0);
        }
    }

    public int getTicksSinceLastFire() {
        return this.ticksSinceLastFire;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB box = super.getRenderBoundingBox();
        return box.func_72314_b(32.0, 32.0, 32.0);
    }

    private Vec3 calcMotionFromAngles() {
        double p = Math.toRadians(this.currentPitch);
        double y = Math.toRadians(180.0 - this.currentYaw);
        double sinPitch = Math.sin(p);
        double cosPitch = Math.cos(p);
        double sinYaw = Math.sin(y);
        double cosYaw = Math.cos(y);
        return Vec3.func_72443_a((double)(-cosPitch * sinYaw * this.currentSpeed), (double)(sinPitch * this.currentSpeed), (double)(-cosPitch * cosYaw * this.currentSpeed));
    }

    private void invalidateMotion() {
        this.motion = null;
    }

    public Vec3 getMotion() {
        if (this.motion == null) {
            this.motion = this.calcMotionFromAngles();
        }
        return this.motion;
    }

    private void checkOrigin() {
        if (this.projectileOrigin == null) {
            this.projectileOrigin = Vec3.func_72443_a((double)((double)this.field_145851_c + 0.5), (double)this.field_145848_d, (double)((double)this.field_145849_e + 0.5));
        }
    }

    public void setTarget(int x, int y, int z) {
        this.checkOrigin();
        Vec3 target = Vec3.func_72443_a((double)((double)x + 0.5), (double)(y + 1), (double)((double)z + 0.5));
        double distHorizontal = 1.0 * Math.sqrt(Math.pow(target.field_72450_a - this.projectileOrigin.field_72450_a, 2.0) + Math.pow(target.field_72449_c - this.projectileOrigin.field_72449_c, 2.0));
        double distVertical = Math.max((target.field_72448_b - this.projectileOrigin.field_72448_b) * 4.0, 0.0);
        float lobScale = (float)Math.min(75.0, Math.max(20.0, 5.0 + distHorizontal + distVertical));
        Vec3 velocity = TileEntityCannonLogic.calculateTrajectory(this.projectileOrigin, target, lobScale);
        double speed = velocity.func_72433_c();
        this.targetSpeed.set(speed);
        Vec3 direction = velocity.func_72432_b();
        double pitch = Math.asin(direction.field_72448_b);
        double yaw = Math.atan2(direction.field_72449_c, direction.field_72450_a);
        this.targetYaw.set(Math.toDegrees(yaw) + -90.0);
        this.targetPitch.set(Math.toDegrees(pitch));
        this.currentYaw = this.targetYaw.get();
        this.currentPitch = this.targetPitch.get();
        this.sync();
    }

    public void disableLineRender() {
        this.renderLine = false;
    }

    @Override
    public void onPointingStart(ItemStack itemStack, EntityPlayer player) {
        player.func_146105_b((IChatComponent)new ChatComponentTranslation("openblocks.misc.selected_cannon", new Object[0]));
    }

    @Override
    public void onPointingEnd(ItemStack itemStack, EntityPlayer player, int x, int y, int z) {
        player.func_145747_a((IChatComponent)new ChatComponentTranslation("openblocks.misc.pointed_cannon", new Object[]{x, y, z}));
        this.setTarget(x, y, z);
    }

    public void setSpeed(double speed) {
        this.targetSpeed.set(speed);
        this.sync();
    }

    public void setPitch(double pitch2) {
        this.targetPitch.set(pitch2);
        this.sync();
    }

    public void setYaw(double yaw2) {
        this.targetYaw.set(yaw2);
        this.sync();
    }

    public ForgeDirection getSurfaceDirection() {
        return ForgeDirection.DOWN;
    }

    static class TileEntityCannonLogic {
        public static final int HOURS_WASTED_ON_CANNON_LOGIC = 14;
        private static final double PHYS_STEPS_PER_SECOND = 20.0;
        private static final double PHYS_PARTIAL_TIME = 0.05;
        private static final double PHYS_WORLD_GRAVITY = 0.8;
        private static final double PHYS_PARTIAL_WORLD_GRAVITY = 0.04000000000000001;
        private static final double PHYS_PARTIAL_TIME_SQUARE = 0.0025000000000000005;
        private static final Vec3 PHYS_GRAVITY_VECTOR_SQUARE_PARTIAL = Vec3.func_72443_a((double)0.0, (double)-1.0000000000000005E-4, (double)0.0);

        TileEntityCannonLogic() {
        }

        public static Vec3 calculateTrajectory(Vec3 start, Vec3 target, float scale) {
            double n = (double)scale * 20.0;
            double accelerationMultiplier = 0.5 * n * n + n;
            Vec3 scaledAcceleration = Vec3.func_72443_a((double)(TileEntityCannonLogic.PHYS_GRAVITY_VECTOR_SQUARE_PARTIAL.field_72450_a * accelerationMultiplier), (double)(TileEntityCannonLogic.PHYS_GRAVITY_VECTOR_SQUARE_PARTIAL.field_72448_b * accelerationMultiplier), (double)(TileEntityCannonLogic.PHYS_GRAVITY_VECTOR_SQUARE_PARTIAL.field_72449_c * accelerationMultiplier));
            double velocityMultiplier = -20.0 / n;
            Vec3 velocity = Vec3.func_72443_a((double)((start.field_72450_a + scaledAcceleration.field_72450_a - target.field_72450_a) * velocityMultiplier), (double)((start.field_72448_b + scaledAcceleration.field_72448_b - target.field_72448_b) * velocityMultiplier), (double)((start.field_72449_c + scaledAcceleration.field_72449_c - target.field_72449_c) * velocityMultiplier));
            return velocity;
        }
    }
}

