/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.blaze;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.blaze.Entity_SpecialBlaze;

public class EntityHellfireBlaze
extends Entity_SpecialBlaze {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "blaze/hellfire.png")};
    public int explosionStrength = 2;

    public EntityHellfireBlaze(World world) {
        super(world);
        this.getSpecialData().setTextures(TEXTURES);
        ++this.field_70728_aV;
    }

    @Override
    protected void adjustTypeAttributes() {
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 10.0);
        this.setRangedAI(1, 0, 60, 100, 40.0f);
        this.getSpecialData().arrowSpread = 0.0f;
    }

    @Override
    public void shootFireballAtEntity(Entity target, float distance) {
        double dX = target.field_70165_t - this.field_70165_t;
        double dY = target.field_70121_D.field_72338_b + (double)(target.field_70131_O / 2.0f) - this.field_70163_u - (double)(this.field_70131_O / 2.0f);
        double dZ = target.field_70161_v - this.field_70161_v;
        float spread = (float)Math.sqrt(distance) * this.getSpecialData().arrowSpread;
        this.field_70170_p.func_72889_a((EntityPlayer)null, 1009, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
        EntityLargeFireball fireball = new EntityLargeFireball(this.field_70170_p, (EntityLivingBase)this, dX + this.field_70146_Z.nextGaussian() * (double)spread, dY, dZ + this.field_70146_Z.nextGaussian() * (double)spread);
        fireball.field_92057_e = this.explosionStrength;
        fireball.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + 0.5;
        this.field_70170_p.func_72838_d((Entity)fireball);
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("ExplosionPower", this.explosionStrength);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("ExplosionPower")) {
            this.explosionStrength = tag.func_74762_e("ExplosionPower");
        }
    }

    @Override
    protected void func_70628_a(boolean hit, int looting) {
        super.func_70628_a(hit, looting);
        if (hit) {
            int i = this.field_70146_Z.nextInt(3 + looting);
            while (i-- > 0) {
                this.func_145779_a(Items.field_151016_H, 1);
            }
        }
    }
}

