/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.feature.blobs.populators;

import chylex.hee.system.util.BlockPosM;
import chylex.hee.world.feature.blobs.BlobPopulator;
import chylex.hee.world.feature.util.DecoratorFeatureGenerator;
import chylex.hee.world.util.Direction;
import chylex.hee.world.util.IRandomAmount;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class BlobPopulatorLiquidFall
extends BlobPopulator {
    private Block liquid;
    private IRandomAmount amountGen;
    private byte minAmount;
    private byte maxAmount;
    private byte minAttempts;
    private byte maxAttempts;
    private boolean requireBlockBelow;

    public BlobPopulatorLiquidFall(int weight) {
        super(weight);
    }

    public BlobPopulatorLiquidFall block(Block liquid) {
        this.liquid = liquid;
        return this;
    }

    public BlobPopulatorLiquidFall amount(IRandomAmount amountGen, int minAmount, int maxAmount) {
        this.amountGen = amountGen;
        this.minAmount = (byte)minAmount;
        this.maxAmount = (byte)maxAmount;
        return this;
    }

    public BlobPopulatorLiquidFall attempts(int minAttempts, int maxAttempts) {
        this.minAttempts = (byte)minAttempts;
        this.maxAttempts = (byte)maxAttempts;
        return this;
    }

    public BlobPopulatorLiquidFall requireBlockBelow() {
        this.requireBlockBelow = true;
        return this;
    }

    @Override
    public void generate(DecoratorFeatureGenerator gen, Random rand) {
        List<BlockPosM> blocks = gen.getUsedLocations();
        if (blocks.isEmpty()) {
            return;
        }
        int amount = this.amountGen.generate(rand, this.minAmount, this.maxAmount);
        block0: for (int attempts = this.minAttempts + rand.nextInt(this.maxAttempts - this.minAttempts + 1); attempts > 0 && amount > 0 && !blocks.isEmpty(); --attempts) {
            BlockPosM loc = blocks.remove(rand.nextInt(blocks.size()));
            if (gen.getBlock(loc.x, loc.y, loc.z) != Blocks.field_150377_bs || gen.getBlock(loc.x, loc.y - 1, loc.z) != Blocks.field_150377_bs) continue;
            int airDir = -1;
            for (int dir = 0; dir < 4; dir = (int)((byte)(dir + 1))) {
                if (gen.getBlock(loc.x + Direction.offsetX[dir], loc.y, loc.z + Direction.offsetZ[dir]) != Blocks.field_150350_a) continue;
                if (airDir == -1) {
                    airDir = dir;
                    continue;
                }
                airDir = -1;
                break;
            }
            if (airDir == -1) continue;
            int xx = loc.x + Direction.offsetX[airDir];
            int yy = loc.y;
            int zz = loc.z + Direction.offsetZ[airDir];
            if (!this.requireBlockBelow) {
                gen.setBlock(loc.x, loc.y, loc.z, this.liquid);
                continue;
            }
            while (--yy >= -16) {
                Block block = gen.getBlock(xx, yy, zz);
                if (block == Blocks.field_150377_bs) {
                    if (gen.getBlock(xx, yy - 1, zz) != Blocks.field_150377_bs) continue;
                    gen.setBlock(loc.x, loc.y, loc.z, this.liquid);
                    gen.setBlock(xx, yy, zz, Blocks.field_150350_a);
                    --amount;
                    continue block0;
                }
                if (block == Blocks.field_150350_a) continue;
            }
        }
    }
}

