/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.test.list.mechanics;

import chylex.hee.mechanics.charms.CharmRecipe;
import chylex.hee.mechanics.charms.CharmType;
import chylex.hee.mechanics.charms.RuneType;
import chylex.hee.system.test.Assert;
import chylex.hee.system.test.data.MethodType;
import chylex.hee.system.test.data.RunTime;
import chylex.hee.system.test.data.UnitTest;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.Map;

public class CharmTests {
    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testRecipeConflicts() {
        TIntIntHashMap hashes = new TIntIntHashMap(80, 0.75f, -1, -1);
        for (CharmType type : CharmType.values()) {
            for (CharmRecipe recipe : type.recipes) {
                Map<RuneType, Byte> data = recipe.getRunes();
                int hash = 0;
                for (Map.Entry<RuneType, Byte> entry : data.entrySet()) {
                    int key = entry.getKey().ordinal();
                    byte amount = entry.getValue();
                    hash |= amount << key * 3;
                }
                int prevHash = hashes.put(hash, (int)recipe.id);
                if (prevHash == -1) continue;
                Assert.fail("Found a duplicate Charm recipe: " + prevHash + " and " + recipe.id);
            }
        }
    }
}

