/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.compendium.render;

import chylex.hee.gui.GuiEnderCompendium;
import chylex.hee.gui.helpers.GuiItemRenderHelper;
import chylex.hee.mechanics.compendium.content.KnowledgeFragment;
import chylex.hee.mechanics.compendium.content.KnowledgeObject;
import chylex.hee.mechanics.compendium.player.PlayerCompendiumData;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class PurchaseDisplayElement {
    public final Object object;
    public final int price;
    private final PlayerCompendiumData.FragmentPurchaseStatus status;
    private final int y;
    public final boolean fragmentHasRedirect;

    public PurchaseDisplayElement(KnowledgeFragment fragment, int y, PlayerCompendiumData.FragmentPurchaseStatus status) {
        this.object = fragment;
        this.price = fragment.getPrice();
        this.y = y;
        this.status = status;
        this.fragmentHasRedirect = fragment.getUnlockRedirect() != null;
    }

    public PurchaseDisplayElement(KnowledgeObject<?> object, int y, PlayerCompendiumData.FragmentPurchaseStatus status) {
        this.object = object;
        this.price = object.getUnlockPrice();
        this.y = y;
        this.status = status;
        this.fragmentHasRedirect = false;
    }

    public void render(GuiScreen gui, int mouseX, int mouseY, int pageCenterX) {
        String price;
        pageCenterX += 3;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.96f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderHelper.func_74518_a();
        gui.field_146297_k.func_110434_K().func_110577_a(GuiEnderCompendium.texPage);
        gui.func_73729_b(pageCenterX - 27, this.y - 14, 155, 0, 54, 26);
        RenderHelper.func_74520_c();
        GuiEnderCompendium.renderItem.func_77015_a(gui.field_146297_k.field_71466_p, gui.field_146297_k.func_110434_K(), GuiEnderCompendium.knowledgeFragmentIS, pageCenterX - 22, this.y - 10);
        RenderHelper.func_74518_a();
        String string = price = this.status == PlayerCompendiumData.FragmentPurchaseStatus.NOT_BUYABLE ? "---" : String.valueOf(this.price);
        int color = this.status == PlayerCompendiumData.FragmentPurchaseStatus.CAN_PURCHASE ? 0x404040 : (this.status == PlayerCompendiumData.FragmentPurchaseStatus.REQUIREMENTS_UNFULFILLED || this.status == PlayerCompendiumData.FragmentPurchaseStatus.NOT_BUYABLE ? 0x888888 : (this.status == PlayerCompendiumData.FragmentPurchaseStatus.NOT_ENOUGH_POINTS ? 0xDD2020 : 0));
        gui.field_146297_k.field_71466_p.func_78276_b(price, pageCenterX - gui.field_146297_k.field_71466_p.func_78256_a(price) + 20, this.y - 5, color);
        if (this.object instanceof KnowledgeObject) {
            String name = ((KnowledgeObject)this.object).getTooltip();
            List parsed = gui.field_146297_k.field_71466_p.func_78271_c(name, 126);
            int yy = this.y - 25 - (parsed.size() - 1) * gui.field_146297_k.field_71466_p.field_78288_b;
            for (int a = 0; a < parsed.size(); ++a) {
                gui.field_146297_k.field_71466_p.func_78276_b((String)parsed.get(a), pageCenterX - (gui.field_146297_k.field_71466_p.func_78256_a((String)parsed.get(a)) >> 1), yy, 0x404040);
                yy += gui.field_146297_k.field_71466_p.field_78288_b;
            }
        } else if (this.isMouseOver(mouseX, mouseY, pageCenterX - 3)) {
            if (this.status == PlayerCompendiumData.FragmentPurchaseStatus.NOT_BUYABLE) {
                String tooltip = I18n.func_135052_a((String)"compendium.nonBuyable", (Object[])new Object[0]);
                if (this.fragmentHasRedirect) {
                    tooltip = tooltip + '\n' + EnumChatFormatting.DARK_PURPLE + I18n.func_135052_a((String)"compendium.viewObject", (Object[])new Object[0]) + ' ' + ((KnowledgeFragment)this.object).getUnlockRedirect().getTooltip();
                }
                GuiItemRenderHelper.setupTooltip(mouseX, mouseY, tooltip);
            } else if (this.status == PlayerCompendiumData.FragmentPurchaseStatus.REQUIREMENTS_UNFULFILLED) {
                GuiItemRenderHelper.setupTooltip(mouseX, mouseY, I18n.func_135052_a((String)"compendium.unfulfilledRequirements", (Object[])new Object[0]));
            }
        }
    }

    public boolean isMouseOver(int mouseX, int mouseY, int pageCenterX) {
        return mouseX >= pageCenterX + 3 - 27 && mouseY >= this.y - 14 && mouseX <= pageCenterX + 3 + 27 && mouseY <= this.y + 12;
    }

    public PlayerCompendiumData.FragmentPurchaseStatus getStatus() {
        return this.status;
    }
}

