/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.guis.screens;

import gcewing.sg.BaseMod;
import gcewing.sg.BaseModClient;
import gcewing.sg.SGCraft;
import gcewing.sg.guis.BaseGui;
import gcewing.sg.guis.GState;
import gcewing.sg.guis.MouseCoords;
import gcewing.sg.guis.Root;
import gcewing.sg.guis.containers.BaseContainer;
import gcewing.sg.interfaces.ISetMod;
import gcewing.sg.interfaces.IWidget;
import gcewing.sg.interfaces.IWidgetContainer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class Screen
extends GuiContainer
implements ISetMod {
    protected BaseMod mod;
    protected Root root;
    protected String title;
    protected IWidget mouseWidget;
    protected GState gstate;

    public Screen(Container container, int width, int height) {
        super(container);
        this.field_146999_f = width;
        this.field_147000_g = height;
        this.root = new Root(this);
        this.initGraphics();
    }

    public Screen(BaseContainer container) {
        this(container, container.xSize, container.ySize);
    }

    public Container getContainer() {
        return this.field_147002_h;
    }

    public int getWidth() {
        return this.field_146999_f;
    }

    public int getHeight() {
        return this.field_147000_g;
    }

    @Override
    public void setMod(BaseMod mod) {
        this.mod = mod;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.root.layout();
    }

    protected void initGraphics() {
        this.gstate = new GState();
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        this.initGraphics();
        this.drawBackgroundLayer();
        if (this.title != null) {
            this.drawTitle(this.title);
        }
        this.root.draw(this, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        GL11.glPopMatrix();
    }

    protected void drawBackgroundLayer() {
        this.initGraphics();
        this.drawGuiBackground(0.0, 0.0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146979_b(int par1, int par2) {
        this.drawForegroundLayer();
    }

    protected void drawForegroundLayer() {
    }

    public void close() {
        this.dispatchClosure(this.root);
        this.onClose();
        this.field_146297_k.field_71439_g.func_71053_j();
    }

    protected void onClose() {
    }

    public void bindTexture(String path, int usize, int vsize) {
        this.bindTexture(((BaseModClient)this.mod.client).textureLocation(path), usize, vsize);
    }

    public void bindTexture(ResourceLocation rsrc) {
        this.bindTexture(rsrc, 1, 1);
    }

    public void bindTexture(ResourceLocation rsrc, int usize, int vsize) {
        this.gstate.texture = rsrc;
        this.field_146297_k.func_110434_K().func_110577_a(rsrc);
        this.gstate.uscale = 1.0 / (double)usize;
        this.gstate.vscale = 1.0 / (double)vsize;
        SGCraft.log.trace(String.format("BaseGuiContainer.bindTexture: %s size (%s, %s) scale (%s, %s)", rsrc, usize, vsize, this.gstate.uscale, this.gstate.vscale));
    }

    public void drawRect(double x, double y, double w, double h) {
        GL11.glDisable((int)3553);
        GL11.glColor3d((double)this.gstate.red, (double)this.gstate.green, (double)this.gstate.blue);
        GL11.glBegin((int)7);
        GL11.glVertex3d((double)x, (double)(y + h), (double)this.field_73735_i);
        GL11.glVertex3d((double)(x + w), (double)(y + h), (double)this.field_73735_i);
        GL11.glVertex3d((double)(x + w), (double)y, (double)this.field_73735_i);
        GL11.glVertex3d((double)x, (double)y, (double)this.field_73735_i);
        GL11.glEnd();
        GL11.glEnable((int)3553);
    }

    public void drawBorderedRect(double x, double y, double w, double h, double u, double v, double uSize, double vSize, double cornerWidth, double cornerHeight) {
        double cw = cornerWidth;
        double ch = cornerHeight;
        double sw = w - 2.0 * cornerWidth;
        double sh = h - 2.0 * cornerHeight;
        double usw = uSize - 2.0 * cornerWidth;
        double ush = vSize - 2.0 * cornerHeight;
        double x1 = x + cw;
        double x2 = w - cw;
        double y1 = y + ch;
        double y2 = h - ch;
        double u1 = u + cw;
        double u2 = u + uSize - cw;
        double v1 = v + ch;
        double v2 = v + vSize - ch;
        this.drawTexturedRect(x, y, cw, ch, u, v);
        this.drawTexturedRect(x2, y, cw, ch, u2, v);
        this.drawTexturedRect(x, y2, cw, ch, u, v2);
        this.drawTexturedRect(x2, y2, cw, ch, u2, v2);
        this.drawTexturedRect(x1, y, sw, ch, u1, v, usw, ch);
        this.drawTexturedRect(x1, y2, sw, ch, u1, v2, usw, ch);
        this.drawTexturedRect(x, y1, cw, sh, u, v1, cw, ush);
        this.drawTexturedRect(x2, y1, cw, sh, u2, v1, cw, ush);
        this.drawTexturedRect(x1, y1, sw, sh, u1, v1, usw, ush);
    }

    public void drawGuiBackground(double x, double y, double w, double h) {
        this.bindTexture("gui/gui_background.png", 16, 16);
        this.setColor(0xFFFFFF);
        this.drawBorderedRect(x, y, w, h, 0.0, 0.0, 16.0, 16.0, 4.0, 4.0);
    }

    public void drawTexturedRect(double x, double y, double w, double h) {
        this.drawTexturedRectUV(x, y, w, h, 0.0, 0.0, 1.0, 1.0);
    }

    public void drawTexturedRect(double x, double y, double w, double h, double u, double v) {
        this.drawTexturedRect(x, y, w, h, u, v, w, h);
    }

    public void drawTexturedRect(double x, double y, double w, double h, double u, double v, double us, double vs) {
        this.drawTexturedRectUV(x, y, w, h, u * this.gstate.uscale, v * this.gstate.vscale, us * this.gstate.uscale, vs * this.gstate.vscale);
    }

    public void drawTexturedRectUV(double x, double y, double w, double h, double u, double v, double us, double vs) {
        SGCraft.log.trace(String.format("BaseGuiContainer.drawTexturedRectUV: (%s, %s, %s, %s) (%s, %s, %s, %s)", x, y, w, h, u, v, us, vs));
        GL11.glBegin((int)7);
        GL11.glColor3f((float)this.gstate.red, (float)this.gstate.green, (float)this.gstate.blue);
        GL11.glTexCoord2d((double)u, (double)(v + vs));
        GL11.glVertex3d((double)x, (double)(y + h), (double)this.field_73735_i);
        GL11.glTexCoord2d((double)(u + us), (double)(v + vs));
        GL11.glVertex3d((double)(x + w), (double)(y + h), (double)this.field_73735_i);
        GL11.glTexCoord2d((double)(u + us), (double)v);
        GL11.glVertex3d((double)(x + w), (double)y, (double)this.field_73735_i);
        GL11.glTexCoord2d((double)u, (double)v);
        GL11.glVertex3d((double)x, (double)y, (double)this.field_73735_i);
        GL11.glEnd();
    }

    public void setColor(int hex) {
        this.setColor((double)(hex >> 16) / 255.0, (double)(hex >> 8 & 0xFF) / 255.0, (double)(hex & 0xFF) / 255.0);
    }

    public void setColor(double r, double g, double b) {
        this.gstate.red = (float)r;
        this.gstate.green = (float)g;
        this.gstate.blue = (float)b;
    }

    public void resetColor() {
        this.setColor(1.0, 1.0, 1.0);
    }

    public void setTextColor(int hex) {
        this.gstate.textColor = hex;
    }

    public void drawString(String s, int x, int y) {
        this.field_146289_q.func_85187_a(s, x, y, this.gstate.textColor, this.gstate.textShadow);
    }

    public void drawCenteredString(String s, int x, int y) {
        this.field_146289_q.func_85187_a(s, x - this.field_146289_q.func_78256_a(s) / 2, y, this.gstate.textColor, this.gstate.textShadow);
    }

    public void drawRightAlignedString(String s, int x, int y) {
        this.field_146289_q.func_85187_a(s, x - this.field_146289_q.func_78256_a(s), y, this.gstate.textColor, this.gstate.textShadow);
    }

    public void drawTitle(String s) {
        this.drawCenteredString(s, this.field_146999_f / 2, 4);
    }

    protected void func_146286_b(int x, int y, int button) {
        super.func_146286_b(x, y, button);
        if (this.mouseWidget == null) {
            return;
        }
        MouseCoords m = new MouseCoords(this.mouseWidget, x, y);
        if (button == -1) {
            this.mouseWidget.mouseMoved(m);
            return;
        }
        this.mouseWidget.mouseReleased(m, button);
        this.mouseWidget = null;
    }

    public void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        this.mousePressed(x - this.field_147003_i, y - this.field_147009_r, button);
    }

    protected void mousePressed(int x, int y, int button) {
        this.mouseWidget = this.root.dispatchMousePress(x, y, button);
        if (this.mouseWidget == null) {
            return;
        }
        this.closeOldFocus(this.mouseWidget);
        this.focusOn(this.mouseWidget);
        this.mouseWidget.mousePressed(new MouseCoords(this.mouseWidget, x, y), button);
    }

    void closeOldFocus(IWidget clickedWidget) {
        if (BaseGui.isFocused(clickedWidget)) {
            return;
        }
        IWidgetContainer parent = clickedWidget.parent();
        while (!BaseGui.isFocused(parent)) {
            parent = parent.parent();
        }
        this.dispatchClosure(parent.getFocus());
    }

    void dispatchClosure(IWidget target) {
        while (target != null) {
            target.close();
            target = this.getFocusOf(target);
        }
    }

    IWidget getFocusOf(IWidget widget) {
        if (widget instanceof IWidgetContainer) {
            return ((IWidgetContainer)widget).getFocus();
        }
        return null;
    }

    public void func_73869_a(char c, int key) {
        if (this.root.dispatchKeyPress(c, key)) {
            return;
        }
        if (key == 1 || key == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.close();
            return;
        }
        super.func_73869_a(c, key);
    }

    public void focusOn(IWidget newFocus) {
        SGCraft.log.trace(String.format("BaseGui.Screen.focusOn: %s", BaseGui.name(newFocus)));
        IWidgetContainer parent = newFocus.parent();
        if (parent == null) {
            return;
        }
        IWidget oldFocus = parent.getFocus();
        SGCraft.log.trace(String.format("BaseGui.Screen.focusOn: Old parent focus = %s", BaseGui.name(oldFocus)));
        if (BaseGui.isFocused(parent)) {
            SGCraft.log.trace("BaseGui.Screen.focusOn: Parent is focused");
            if (oldFocus != newFocus) {
                BaseGui.tellFocusChanged(oldFocus, false);
                parent.setFocus(newFocus);
                BaseGui.tellFocusChanged(newFocus, true);
            }
            return;
        }
        SGCraft.log.trace("BaseGui.Screen.focusOn: Parent is not focused");
        parent.setFocus(newFocus);
        this.focusOn(parent);
    }
}

