/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import net.minecraft.block.Block;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tuhljin.automagy.lib.IAutomagyLocationLink;
import tuhljin.automagy.lib.IRemoteComparatorOverride;
import tuhljin.automagy.lib.NeighborNotifier;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.struct.WorldSpecificCoordinates;
import tuhljin.automagy.tiles.ModTileEntityWithInventory;

public class TileEntityRemoteComparator
extends ModTileEntityWithInventory {
    protected static final int MAX_DISTANCE = 20;
    protected static final int COOLDOWN_TIME = 4;
    protected int redstoneSignalStrength = 0;
    protected int linkMode = 0;
    protected int linkX;
    protected int linkY;
    protected int linkZ;
    protected int cooldown = 0;

    public TileEntityRemoteComparator() {
        super("blockRemoteComparator", 1);
    }

    public static boolean isValidContainerForReading(Block block, World world, int x, int y, int z) {
        if (block.func_149740_M()) {
            return true;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        return te instanceof IInventory;
    }

    public static int getComparatorReading(Block block, World world, int x, int y, int z) {
        if (block.func_149740_M()) {
            return block.func_149736_g(world, x, y, z, 1);
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IInventory) {
            return Container.func_94526_b((IInventory)((IInventory)te));
        }
        return 0;
    }

    public WorldSpecificCoordinates getLinkLocation() {
        ItemStack stack = this.func_70301_a(0);
        if (stack != null && stack.func_77973_b() instanceof IAutomagyLocationLink) {
            return ((IAutomagyLocationLink)stack.func_77973_b()).getLinkLocation(stack);
        }
        return null;
    }

    public boolean coordinatesAreInRange(WorldSpecificCoordinates coord) {
        if (coord != null && coord.dim == this.field_145850_b.field_73011_w.field_76574_g) {
            float distance = TjUtil.getDistanceBetweenPoints(this.field_145851_c, this.field_145848_d, this.field_145849_e, coord.x, coord.y, coord.z);
            return distance <= 20.0f;
        }
        return false;
    }

    public boolean coordinatesAreInRange() {
        return this.coordinatesAreInRange(this.getLinkLocation());
    }

    public Block getBlockAtLinkedLocationIfValid() {
        Block block;
        WorldSpecificCoordinates coord = this.getLinkLocation();
        if (coord != null && coord.dim == this.field_145850_b.field_73011_w.field_76574_g && TileEntityRemoteComparator.isValidContainerForReading(block = this.field_145850_b.func_147439_a(coord.x, coord.y, coord.z), this.field_145850_b, coord.x, coord.y, coord.z)) {
            return block;
        }
        return null;
    }

    public ItemStack getFloatingDisplayItem() {
        return this.func_70301_a(0);
    }

    public boolean isRedstoneSignalBeingSent() {
        if (this.linkMode == -2) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
            if (block == null) {
                return false;
            }
            if (block instanceof IRemoteComparatorOverride) {
                return ((IRemoteComparatorOverride)block).hasActiveRedstoneSignal(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this);
            }
            return block.func_149709_b((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, 2) > 0;
        }
        return this.getRedstoneSignalStrength() > 0;
    }

    public int getRedstoneSignalStrength() {
        return this.linkMode >= 0 ? this.redstoneSignalStrength : 0;
    }

    public void setOverride(boolean override) {
        if (override) {
            this.linkMode = -2;
            this.setRedstoneSignalStrength(0);
        } else {
            this.linkMode = 0;
        }
        this.func_70296_d();
    }

    public boolean isOverridden() {
        return this.linkMode == -2;
    }

    protected void setRedstoneSignalStrength(int strength) {
        if (this.redstoneSignalStrength != strength) {
            this.redstoneSignalStrength = strength;
            this.func_70296_d();
            NeighborNotifier.notifyBlocksOfExtendedNeighborChange(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void func_145845_h() {
        Block block;
        if (this.field_145850_b.field_72995_K) return;
        if (this.linkMode < 0) {
            return;
        }
        if (this.linkMode == 0) {
            WorldSpecificCoordinates coord = this.getLinkLocation();
            if (!this.coordinatesAreInRange(coord)) {
                this.linkMode = -1;
                this.setRedstoneSignalStrength(0);
                this.func_70296_d();
                return;
            }
            this.linkX = coord.x;
            this.linkY = coord.y;
            this.linkZ = coord.z;
            this.linkMode = 1;
            this.func_70296_d();
            this.cooldown = 0;
        } else {
            if (this.cooldown > 0) {
                --this.cooldown;
                return;
            }
            this.cooldown = 4;
        }
        if ((block = this.getBlockAtLinkedLocationIfValid()) == null) {
            this.setRedstoneSignalStrength(0);
            return;
        }
        int strength = 0;
        try {
            strength = TileEntityRemoteComparator.getComparatorReading(block, this.field_145850_b, this.linkX, this.linkY, this.linkZ);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setRedstoneSignalStrength(strength);
    }

    @Override
    public ItemStack func_70298_a(int slot, int num) {
        ItemStack stack = super.func_70298_a(slot, num);
        if (this.linkMode == -2) {
            this.field_145850_b.func_147460_e(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
        } else {
            this.linkMode = 0;
            this.func_70296_d();
        }
        return stack;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);
        if (this.linkMode == -2) {
            this.field_145850_b.func_147460_e(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
        } else {
            this.linkMode = 0;
            this.func_70296_d();
        }
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof IAutomagyLocationLink && ((IAutomagyLocationLink)stack.func_77973_b()).getLinkLocation(stack) != null;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        this.redstoneSignalStrength = nbttagcompound.func_74765_d("strength");
        this.linkMode = nbttagcompound.func_74765_d("linkMode");
        this.linkX = nbttagcompound.func_74762_e("linkX");
        this.linkY = nbttagcompound.func_74762_e("linkY");
        this.linkZ = nbttagcompound.func_74762_e("linkZ");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        super.writeCustomNBT(nbttagcompound);
        nbttagcompound.func_74777_a("strength", (short)this.redstoneSignalStrength);
        nbttagcompound.func_74777_a("linkMode", (short)this.linkMode);
        nbttagcompound.func_74768_a("linkX", this.linkX);
        nbttagcompound.func_74768_a("linkY", this.linkY);
        nbttagcompound.func_74768_a("linkZ", this.linkZ);
    }
}

