/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.client.renderer.block;

import com.gtnewhorizons.angelica.api.ThreadSafeISBRH;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.blocks.BlockChorusPlant;
import ganymedes01.etfuturum.client.renderer.block.BlockChorusFlowerRenderer;
import ganymedes01.etfuturum.core.utils.RandomXoshiro256StarStar;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

@ThreadSafeISBRH(perThread=false)
public class BlockChorusPlantRenderer
extends BlockChorusFlowerRenderer {
    private final Random rand = new RandomXoshiro256StarStar();

    public BlockChorusPlantRenderer(int modelID) {
        super(modelID);
    }

    @Override
    protected void renderInventoryModel(Block block, int meta, int modelId, RenderBlocks renderer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.renderStandardInventoryCube(block, meta, modelId, renderer, 0.25, 0.125, 0.25, 0.75, 0.875, 0.75);
        this.renderStandardInventoryCube(block, meta, modelId, renderer, 0.1875, 0.4375, 0.3175, 0.8125, 0.8125, 0.6875);
        this.renderStandardInventoryCube(block, meta, modelId, renderer, 0.3175, 0.4375, 0.1875, 0.6875, 0.8125, 0.8125);
        this.renderStandardInventoryCube(block, meta, modelId, renderer, 0.3125, 0.875, 0.3125, 0.6875, 0.9375, 0.6875);
    }

    @Override
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        renderer.field_147837_f = true;
        long seed = (long)x * 3129871L ^ (long)y * 116129781L ^ (long)z;
        seed = seed * seed * 42317861L + seed * 11L;
        this.rand.setSeed(seed);
        int noConUp = this.rand.nextInt(5);
        int noConDown = this.rand.nextInt(5);
        int noConWest = this.rand.nextInt(5);
        int noConEast = this.rand.nextInt(5);
        int noConNorth = this.rand.nextInt(5);
        int noConSouth = this.rand.nextInt(5);
        Block neighbourUp = world.func_147439_a(x, y + ForgeDirection.UP.offsetY, z);
        Block neighbourDown = world.func_147439_a(x, y + ForgeDirection.DOWN.offsetY, z);
        Block neighbourWest = world.func_147439_a(x + ForgeDirection.WEST.offsetX, y, z);
        Block neighbourEast = world.func_147439_a(x + ForgeDirection.EAST.offsetX, y, z);
        Block neighbourNorth = world.func_147439_a(x, y, z + ForgeDirection.NORTH.offsetZ);
        Block neighbourSouth = world.func_147439_a(x, y, z + ForgeDirection.SOUTH.offsetZ);
        boolean connectUp = BlockChorusPlant.canPlaceOn(neighbourUp);
        boolean connectDown = BlockChorusPlant.canPlaceOn(neighbourDown);
        boolean connectWest = BlockChorusPlant.canPlaceOn(neighbourWest);
        boolean connectEast = BlockChorusPlant.canPlaceOn(neighbourEast);
        boolean connectNorth = BlockChorusPlant.canPlaceOn(neighbourNorth);
        boolean connectSouth = BlockChorusPlant.canPlaceOn(neighbourSouth);
        double conSizeMin = 0.25;
        double conSizeMax = 0.75;
        if (neighbourUp == ModBlocks.CHORUS_FLOWER.get() || connectUp || neighbourUp == block) {
            this.renderStandardWorldCube(world, x, y, z, block, modelId, renderer, conSizeMin, conSizeMax, conSizeMin, conSizeMax, 1.0, conSizeMax);
        } else if (noConUp == 2 || noConUp == 3) {
            this.renderStandardWorldCube(world, x, y, z, block, modelId, renderer, conSizeMin, conSizeMax, conSizeMin, conSizeMax, 0.8175, conSizeMax);
        } else if (noConUp == 4) {
            this.renderStandardWorldCube(world, x, y, z, block, modelId, renderer, 0.3125, conSizeMax, 0.3125, 0.6875, 0.875, 0.6875);
        }
        if (neighbourDown == ModBlocks.CHORUS_FLOWER.get() || connectDown || neighbourDown == block) {
            this.renderStandardWorldCube(world, x, y, z, block, modelId, renderer, conSizeMin, 0.0, conSizeMin, conSizeMax, conSizeMin, conSizeMax);
        } else if (noConDown == 2 || noConDown == 3) {
            this.renderStandardWorldCube(world, x, y, z, block, modelId, renderer, conSizeMin, 0.1875, conSizeMin, conSizeMax, conSizeMin, conSizeMax);
        } else if (noConDown == 4) {
            this.renderStandardWorldCube(world, x, y, z, block, modelId, renderer, 0.3125, 0.125, 0.3125, 0.6875, conSizeMin, 0.6875);
        }
        if (neighbourWest == ModBlocks.CHORUS_FLOWER.get() || connectWest || neighbourWest == block) {
            this.renderStandardWorldCube(world, x, y, z, block, modelId, renderer, 0.0, conSizeMin, conSizeMin, conSizeMin, conSizeMax, conSizeMax);
        } else if (noConWest == 2 || noConWest == 3) {
            this.renderStandardWorldCube(world, x, y, z, block, modelId, renderer, 0.1875, conSizeMin, conSizeMin, conSizeMin, conSizeMax, conSizeMax);
        } else if (noConWest == 4) {
            this.renderStandardWorldCube(world, x, y, z, block, modelId, renderer, 0.125, 0.3125, 0.3125, conSizeMin, 0.6875, 0.6875);
        }
        if (neighbourEast == ModBlocks.CHORUS_FLOWER.get() || connectEast || neighbourEast == block) {
            this.renderStandardWorldCube(world, x, y, z, block, modelId, renderer, conSizeMax, conSizeMin, conSizeMin, 1.0, conSizeMax, conSizeMax);
        } else if (noConEast == 2 || noConEast == 3) {
            this.renderStandardWorldCube(world, x, y, z, block, modelId, renderer, conSizeMax, conSizeMin, conSizeMin, 0.8175, conSizeMax, conSizeMax);
        } else if (noConEast == 4) {
            this.renderStandardWorldCube(world, x, y, z, block, modelId, renderer, conSizeMax, 0.3125, 0.3125, 0.875, 0.6875, 0.6875);
        }
        if (neighbourNorth == ModBlocks.CHORUS_FLOWER.get() || connectNorth || neighbourNorth == block) {
            this.renderStandardWorldCube(world, x, y, z, block, modelId, renderer, conSizeMin, conSizeMin, 0.0, conSizeMax, conSizeMax, conSizeMin);
        } else if (noConNorth == 2 || noConNorth == 3) {
            this.renderStandardWorldCube(world, x, y, z, block, modelId, renderer, conSizeMin, conSizeMin, 0.1875, conSizeMax, conSizeMax, conSizeMin);
        } else if (noConNorth == 4) {
            this.renderStandardWorldCube(world, x, y, z, block, modelId, renderer, 0.3125, 0.3125, 0.125, 0.6875, 0.6875, conSizeMin);
        }
        if (neighbourSouth == ModBlocks.CHORUS_FLOWER.get() || connectSouth || neighbourSouth == block) {
            this.renderStandardWorldCube(world, x, y, z, block, modelId, renderer, conSizeMin, conSizeMin, conSizeMax, conSizeMax, conSizeMax, 1.0);
        } else if (noConSouth == 2 || noConSouth == 3) {
            this.renderStandardWorldCube(world, x, y, z, block, modelId, renderer, conSizeMin, conSizeMin, conSizeMax, conSizeMax, conSizeMax, 0.8175);
        } else if (noConSouth == 4) {
            this.renderStandardWorldCube(world, x, y, z, block, modelId, renderer, 0.3125, 0.3125, conSizeMax, 0.6875, 0.6875, 0.875);
        }
        this.renderStandardWorldCube(world, x, y, z, block, modelId, renderer, conSizeMin, conSizeMin, conSizeMin, conSizeMax, conSizeMax, conSizeMax);
        renderer.field_147837_f = false;
        return true;
    }
}

