/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import com.google.common.collect.Maps;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.blocks.ISubBlocksBlock;
import ganymedes01.etfuturum.core.utils.Utils;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BaseSlab
extends BlockSlab
implements ISubBlocksBlock {
    private IIcon[] icons;
    public final String[] types;
    private final BaseSlab singleSlab;
    private BaseSlab doubleSlab;
    private static BaseSlab previousSlab;
    private Block mapColorBase;
    private final Map<Integer, Float> hardnesses = Maps.newHashMap();
    private final Map<Integer, Float> resistances = Maps.newHashMap();

    public BaseSlab(boolean isDouble, Material material, String ... names) {
        super(isDouble, material);
        if (names.length > 8) {
            throw new IllegalArgumentException("Slabs can't have more than 8 subtypes! Tried to register a slab with " + names.length);
        }
        this.types = names;
        this.field_149783_u = !isDouble;
        this.field_149787_q = isDouble;
        if (isDouble) {
            this.doubleSlab = this;
            BaseSlab.previousSlab.doubleSlab = this;
            this.singleSlab = previousSlab;
            previousSlab = null;
        } else {
            this.singleSlab = previousSlab = this;
            this.func_149647_a(EtFuturum.creativeTabBlocks);
        }
    }

    public BaseSlab setUnlocalizedNameWithPrefix(String name) {
        this.func_149663_c(Utils.getUnlocalisedName(name));
        return this;
    }

    public BaseSlab setNames(String name) {
        this.setUnlocalizedNameWithPrefix(name);
        this.func_149658_d(name);
        return this;
    }

    public BaseSlab setToolClass(String toolClass, int level) {
        for (int m = 0; m < 8; ++m) {
            this.setHarvestLevel(toolClass, level, m);
        }
        return this;
    }

    public BaseSlab setToolClass(String toolClass, int level, int meta) {
        this.setHarvestLevel(toolClass, level, meta);
        if (meta < 8) {
            this.setHarvestLevel(toolClass, level, meta + 8);
        }
        return this;
    }

    public BaseSlab setMapColorBaseBlock(Block block) {
        this.mapColorBase = block;
        return this;
    }

    public BaseSlab setBlockSound(Block.SoundType type) {
        Utils.setBlockSound((Block)this, type);
        return this;
    }

    public MapColor func_149728_f(int meta) {
        return this.mapColorBase == null ? super.func_149728_f(meta % 8) : this.mapColorBase.func_149728_f(meta % 8);
    }

    public BaseSlab getDoubleSlab() {
        return this.doubleSlab;
    }

    public BaseSlab getSingleSlab() {
        return this.singleSlab;
    }

    @Override
    public IIcon[] getIcons() {
        return this.icons;
    }

    protected void setIcons(IIcon[] icons) {
        this.icons = icons;
    }

    @Override
    public String[] getTypes() {
        return this.types;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.setIcons(new IIcon[this.getTypes().length]);
        for (int i = 0; i < this.getIcons().length; ++i) {
            this.getIcons()[i] = "".equals(this.getTypes()[i]) ? reg.func_94245_a(this.func_149641_N()) : reg.func_94245_a((this.getTextureDomain().isEmpty() ? "" : this.getTextureDomain() + ":") + this.getTypes()[i]);
        }
        this.field_149761_L = this.getIcons()[0];
    }

    @Override
    public String getNameFor(ItemStack stack) {
        return this.func_150002_b(stack.func_77960_j());
    }

    public String func_150002_b(int meta) {
        String type = this.getTypes()[Math.max(0, meta % 8 % this.getTypes().length)];
        type = "".equals(type) ? this.func_149739_a().replace("tile.", "").replace("etfuturum.", "") : type;
        return type.replace("bricks", "brick").replace("tiles", "tile") + "_slab";
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        if (!this.field_150004_a) {
            for (int i = 0; i < this.types.length; ++i) {
                list.add(new ItemStack(itemIn, 1, i));
            }
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.icons[meta % 8 % this.icons.length];
    }

    public Item func_149694_d(World worldIn, int x, int y, int z) {
        return Item.func_150898_a((Block)this.singleSlab);
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        return Item.func_150898_a((Block)this.singleSlab);
    }

    public float func_149712_f(World worldIn, int x, int y, int z) {
        return this.hardnesses.getOrDefault(worldIn.func_72805_g(x, y, z), Float.valueOf(super.func_149712_f(worldIn, x, y, z))).floatValue();
    }

    public BaseSlab setHardnessValues(float hardness, int ... metas) {
        if (metas.length == 0) {
            this.func_149711_c(hardness);
        } else {
            for (int meta : metas) {
                this.hardnesses.put(meta + 8, Float.valueOf(hardness));
                this.hardnesses.put(meta, Float.valueOf(hardness));
            }
        }
        return this;
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        Float resistance = this.resistances.get(world.func_72805_g(x, y, z));
        if (resistance != null) {
            return resistance.floatValue() / 5.0f;
        }
        return super.getExplosionResistance(par1Entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public BaseSlab setResistanceValues(float resistance, int ... metas) {
        if (metas.length == 0) {
            this.func_149752_b(resistance);
        } else {
            for (int meta : metas) {
                this.resistances.put(meta + 8, Float.valueOf(resistance));
                this.resistances.put(meta, Float.valueOf(resistance));
            }
        }
        return this;
    }
}

