/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.movement;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.core.util.AABBUtils;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.movement.IDoorMovement;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.util.AxisAlignedBB;

public class Rotating4WaysMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getBoundingBox(DoorTileEntity tileEntity, boolean topBlock, BoundingBoxType type) {
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.1875);
        if (tileEntity.isOpened() && type == BoundingBoxType.COLLISION) {
            return null;
        }
        if (type == BoundingBoxType.SELECTION && !tileEntity.isOpened()) {
            if (!topBlock) {
                aabb.field_72337_e += 1.0;
            } else {
                aabb.field_72338_b -= 1.0;
            }
        }
        if (tileEntity.isOpened()) {
            AABBUtils.Axis axis = topBlock == !tileEntity.isReversed() ? AABBUtils.Axis.X : AABBUtils.Axis.Y;
            int dir = tileEntity.isReversed() ? -1 : 1;
            AABBUtils.rotate(aabb, dir, axis);
        }
        return aabb;
    }

    private Transformation getTransformation(DoorTileEntity tileEntity, boolean topBlock) {
        float angle = 90.0f;
        float hingeX = 0.40625f;
        float hingeY = -0.40625f;
        float hingeZ = -0.40625f;
        boolean axisX = false;
        boolean axisY = false;
        if (topBlock) {
            angle = -angle;
            hingeY = 1.0f - hingeY;
        }
        if (tileEntity.isReversed()) {
            hingeX = -hingeX;
        }
        if (topBlock != tileEntity.isReversed()) {
            axisX = true;
        } else {
            axisY = true;
        }
        Rotation rotation = new Rotation(angle);
        rotation.aroundAxis((float)axisX, (float)axisY, 0.0f).offset(hingeX, hingeY, hingeZ);
        rotation.reversed(tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED);
        rotation.forTicks(tileEntity.getDescriptor().getOpeningTime());
        return rotation;
    }

    @Override
    public Animation[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        return new Animation[]{new Animation(model.getShape("top"), this.getTransformation(tileEntity, true)), new Animation(model.getShape("bottom"), this.getTransformation(tileEntity, false))};
    }

    @Override
    public boolean isSpecial() {
        return false;
    }
}

