/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.bbcode;

import java.util.HashMap;
import java.util.Map;
import net.malisis.core.util.bbcode.BBString;
import net.malisis.core.util.bbcode.node.BBColorNode;
import net.malisis.core.util.bbcode.node.BBItemNode;
import net.malisis.core.util.bbcode.node.BBNode;
import net.malisis.core.util.bbcode.node.BBStyleNode;
import net.malisis.core.util.bbcode.node.BBTextNode;
import net.malisis.core.util.parser.Parser;
import net.malisis.core.util.parser.token.Token;
import net.minecraft.util.EnumChatFormatting;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class BBCodeParser
extends Parser<BBNode> {
    private BBString bbText;
    private BBNode currentNode;
    private BBNode node = null;
    private BBTextNode textNode = new BBTextNode("");
    private int charIndex;
    public static Map<Character, EnumChatFormatting> charFormats = new HashMap<Character, EnumChatFormatting>();

    public BBCodeParser(BBString bbText) {
        super(bbText.getText());
        for (EnumChatFormatting ecf : EnumChatFormatting.values()) {
            charFormats.put(Character.valueOf(ecf.func_96298_a()), ecf);
        }
        this.withTokens(Token.OpenCar, Token.CloseCar, Token.HexNumber, Token.Identifier, Token.Equal, Token.Div);
        this.bbText = bbText;
        this.currentNode = bbText.getRoot();
    }

    @Override
    public BBNode parse() {
        MutableObject c = new MutableObject();
        boolean close = false;
        while (!this.isEnd()) {
            this.matched = "";
            if (this.match(Token.OpenCar)) {
                close = this.match(Token.Div);
                if (this.match(Token.Identifier, (Mutable)c)) {
                    switch (c.toString().toLowerCase()) {
                        case "b": 
                        case "i": 
                        case "u": 
                        case "s": {
                            this.node = new BBStyleNode(c.toString());
                            break;
                        }
                        case "color": 
                        case "bgcolor": {
                            this.node = new BBColorNode(c.toString());
                            break;
                        }
                        case "item": {
                            this.node = new BBItemNode("");
                        }
                    }
                }
                if (close) {
                    if (this.node.getClass() == this.currentNode.getClass() && this.match(Token.CloseCar)) {
                        this.addText();
                        this.currentNode = this.currentNode.getParent();
                    } else {
                        close = false;
                        this.node = null;
                    }
                } else if (this.node instanceof BBColorNode && this.match(Token.Equal) && this.match(Token.HexNumber, (Mutable)c)) {
                    ((BBColorNode)this.node).setColor(c.toString());
                } else if (this.node instanceof BBItemNode && this.match(Token.Equal) && this.match(Token.Identifier, (Mutable)c)) {
                    String name = this.readUntil(Token.CloseCar);
                    ((BBItemNode)this.node).setName(c.toString());
                    this.matched = this.matched + name;
                }
            }
            if (this.node != null && this.match(Token.CloseCar, (Mutable)c)) {
                this.addText();
                this.currentNode.insert(this.node);
                if (!this.node.isStandAlone()) {
                    this.currentNode = this.node;
                }
            } else if (!close) {
                this.textNode.append(this.matched);
            }
            this.textNode.append(this.readUntil(Token.OpenCar));
        }
        if (this.textNode != null && !StringUtils.isEmpty((CharSequence)this.textNode.getText())) {
            this.currentNode.insert(this.textNode);
        }
        return this.bbText.getRoot();
    }

    private void addText() {
        if (StringUtils.isEmpty((CharSequence)this.textNode.getText())) {
            return;
        }
        this.charIndex += this.textNode.getText().length();
        this.currentNode.insert(this.textNode);
        this.textNode = new BBTextNode("");
        this.textNode.setIndex(this.charIndex);
    }
}

