/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features;

import appeng.api.definitions.ITileDefinition;
import appeng.block.AEBaseTileBlock;
import appeng.core.CommonHelper;
import appeng.core.CreativeTab;
import appeng.core.features.AEFeature;
import appeng.core.features.ActivityState;
import appeng.core.features.BlockStackSrc;
import appeng.core.features.FeatureNameExtractor;
import appeng.core.features.FeaturedActiveChecker;
import appeng.core.features.IFeatureHandler;
import appeng.core.features.TileDefinition;
import appeng.tile.AEBaseTile;
import appeng.util.Platform;
import com.google.common.base.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

public final class AETileBlockFeatureHandler
implements IFeatureHandler {
    private final AEBaseTileBlock featured;
    private final FeatureNameExtractor extractor;
    private final boolean enabled;
    private final TileDefinition definition;

    public AETileBlockFeatureHandler(EnumSet<AEFeature> features, AEBaseTileBlock featured, Optional<String> subName) {
        ActivityState state = new FeaturedActiveChecker(features).getActivityState();
        this.featured = featured;
        this.extractor = new FeatureNameExtractor(featured.getClass(), subName);
        this.enabled = state == ActivityState.Enabled;
        this.definition = new TileDefinition(featured, state);
    }

    @Override
    public boolean isFeatureAvailable() {
        return this.enabled;
    }

    @Override
    public ITileDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public void register() {
        if (this.enabled) {
            String name = this.extractor.get();
            this.featured.func_149647_a(CreativeTab.instance);
            this.featured.func_149663_c("appliedenergistics2." + name);
            this.featured.func_149658_d("appliedenergistics2:" + name);
            if (Platform.isClient()) {
                CommonHelper.proxy.bindTileEntitySpecialRenderer(this.featured.getTileEntityClass(), this.featured);
            }
            String registryName = "tile." + name;
            GameRegistry.registerBlock((Block)this.featured, null, (String)registryName);
            GameRegistry.registerItem((Item)((Item)this.definition.maybeItem().get()), (String)registryName);
            GameRegistry.registerTileEntity(this.featured.getTileEntityClass(), (String)this.featured.toString());
            AEBaseTile.registerTileItem(this.featured.getTileEntityClass(), new BlockStackSrc(this.featured, 0, ActivityState.from(this.isFeatureAvailable())));
        }
    }
}

