/*
 * Decompiled with CFR 0.152.
 */
package openmods.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

class ReflectionLog {
    private static final boolean ENABLE_LOG = Boolean.parseBoolean(System.getProperty("openmods.logReflection", "false"));
    private static final Logger logger = LogManager.getLogger((String)"OpenMods-Reflection");
    private static final Throwable stackInfo = new Throwable();

    ReflectionLog() {
    }

    private static synchronized String findCaller() {
        StackTraceElement[] stack;
        for (StackTraceElement el : stack = stackInfo.fillInStackTrace().getStackTrace()) {
            String cls = el.getClassName();
            if (cls.startsWith("openmods.reflection.")) continue;
            return cls;
        }
        return "<invalid>";
    }

    static void logLoad(Class<?> cls) {
        if (ENABLE_LOG) {
            logger.debug(String.format("###C %s %s", ReflectionLog.findCaller(), cls.getName()));
        }
    }

    static void logLoad(Constructor<?> ctor) {
        if (ENABLE_LOG) {
            logger.debug(String.format("###I %s %s %s", ReflectionLog.findCaller(), ctor.getDeclaringClass().getName(), Type.getType(ctor).getDescriptor()));
        }
    }

    static void logLoad(Method method) {
        if (ENABLE_LOG) {
            logger.debug(String.format("###M %s %s %s %s", ReflectionLog.findCaller(), method.getDeclaringClass().getName(), method.getName(), Type.getType((Method)method).getDescriptor()));
        }
    }

    static void logLoad(Field field) {
        if (ENABLE_LOG) {
            logger.debug(String.format("###F %s %s %s %s", ReflectionLog.findCaller(), field.getDeclaringClass().getName(), field.getName(), Type.getType(field.getType()).getDescriptor()));
        }
    }
}

