/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import gregtech.api.casing.Casings;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.structure.IStructureInstance;
import gregtech.api.structure.IStructureProvider;
import gregtech.api.structure.StructureWrapper;
import gregtech.api.structure.StructureWrapperInstanceInfo;
import gregtech.api.structure.StructureWrapperTooltipBuilder;
import gregtech.api.util.MultiblockTooltipBuilder;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import tectech.mechanics.dataTransport.QuantumDataPacket;
import tectech.thing.metaTileEntity.hatch.MTEHatchDataInput;
import tectech.thing.metaTileEntity.hatch.MTEHatchDataOutput;
import tectech.thing.metaTileEntity.multi.base.INameFunction;
import tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import tectech.thing.metaTileEntity.multi.base.LedStatus;
import tectech.thing.metaTileEntity.multi.base.Parameters;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;
import tectech.thing.metaTileEntity.multi.base.render.TTRenderedExtendedFacingTexture;

public class MTENetworkSwitch
extends TTMultiblockBase
implements ISurvivalConstructable,
IStructureProvider<MTENetworkSwitch> {
    protected final StructureWrapper<MTENetworkSwitch> structure;
    protected final StructureWrapperInstanceInfo<MTENetworkSwitch> structureInstanceInfo;
    private static final INameFunction<MTENetworkSwitch> DEST_NAME = MTENetworkSwitch::getDestName;
    private static final IStatusFunction<MTENetworkSwitch> DEST_STATUS = MTENetworkSwitch::getDestStatus;
    private static final INameFunction<MTENetworkSwitch> WEIGHT_NAME = MTENetworkSwitch::getWeightName;
    private static final IStatusFunction<MTENetworkSwitch> WEIGHT_STATUS = MTENetworkSwitch::getWeightStatus;
    protected Parameters.Group.ParameterIn[] dst;
    protected Parameters.Group.ParameterIn[] weight;

    public MTENetworkSwitch(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        this.structure = new StructureWrapper<MTENetworkSwitch>(this);
        this.structureInstanceInfo = null;
        this.structure.loadStructure();
    }

    public MTENetworkSwitch(MTENetworkSwitch prototype) {
        super(prototype.mName);
        this.structure = prototype.structure;
        this.structureInstanceInfo = new StructureWrapperInstanceInfo<MTENetworkSwitch>(this.structure);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTENetworkSwitch(this);
    }

    @Override
    public String[][] getDefinition() {
        return StructureUtility.transpose((String[][])new String[][]{{"BBB", "BAB", "BBB"}, {"B~B", "AAA", "BAB"}, {"BBB", "BAB", "BBB"}});
    }

    @Override
    public IStructureDefinition<MTENetworkSwitch> compile(String[][] definition) {
        this.structure.addCasing('A', Casings.AdvancedComputerCasing).withUnlimitedHatches(1, Arrays.asList(HatchElement.Energy.or(TTMultiblockBase.HatchElement.EnergyMulti), HatchElement.Maintenance, TTMultiblockBase.HatchElement.InputData, TTMultiblockBase.HatchElement.OutputData));
        this.structure.addCasing('B', Casings.ComputerCasing).withUnlimitedHatches(2, Arrays.asList(HatchElement.Energy.or(TTMultiblockBase.HatchElement.EnergyMulti), HatchElement.Maintenance, TTMultiblockBase.HatchElement.OutputData));
        return this.structure.buildStructure(definition);
    }

    @Override
    public IStructureInstance getStructureInstance() {
        return this.structureInstanceInfo;
    }

    public IStructureDefinition<MTENetworkSwitch> getStructure_EM() {
        return this.structure.getStructureDefinition();
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        return this.structure.checkStructure(this);
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structure.construct(this, stackSize, hintsOnly);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.structure.survivalConstruct(this, stackSize, elementBudget, env);
    }

    @Override
    public MultiblockTooltipBuilder createTooltip() {
        StructureWrapperTooltipBuilder<MTENetworkSwitch> tt = new StructureWrapperTooltipBuilder<MTENetworkSwitch>(this.structure);
        tt.addMachineType(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.switch.type"));
        tt.addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.switch.desc.0"));
        tt.addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.switch.desc.1"));
        tt.addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.switch.desc.2"));
        tt.addSeparator();
        tt.addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.switch.desc.3"));
        tt.addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.switch.desc.4"));
        tt.addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.switch.desc.5"));
        tt.addTecTechHatchInfo();
        tt.beginStructureBlock();
        tt.addController(StatCollector.func_74838_a((String)"tt.keyword.Structure.FrontCenter"));
        tt.addCasingInfoAuto(Casings.ComputerCasing);
        tt.addCasingInfoAuto(Casings.AdvancedComputerCasing);
        tt.addHatch(Casings.AdvancedComputerCasing, TTMultiblockBase.HatchElement.InputData, 1);
        tt.addHatch(Casings.ComputerCasing, TTMultiblockBase.HatchElement.OutputData, 1, 2);
        tt.addHatch(Casings.ComputerCasing, HatchElement.Energy, 1, 2);
        tt.addHatch(Casings.ComputerCasing, HatchElement.Maintenance, 1, 2);
        tt.toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][1], new TTRenderedExtendedFacingTexture(aActive ? TTMultiblockBase.ScreenON : TTMultiblockBase.ScreenOFF)};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][1]};
    }

    @Override
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.TECTECH_MACHINES_FX_HIGH_FREQ;
    }

    private static String getDestName(MTENetworkSwitch base, Parameters.IParameter p) {
        return StatCollector.func_74838_a((String)"tt.keyword.Destination") + " " + (p.hatchId() + 1);
    }

    private static LedStatus getDestStatus(MTENetworkSwitch base, Parameters.IParameter p) {
        if (base.weight[p.hatchId()].getStatus((boolean)false).isOk) {
            double v = p.get();
            if (Double.isNaN(v)) {
                return LedStatus.STATUS_WRONG;
            }
            if ((v = (double)((int)v)) <= 0.0) {
                return LedStatus.STATUS_TOO_LOW;
            }
            return LedStatus.STATUS_OK;
        }
        return LedStatus.STATUS_NEUTRAL;
    }

    private static String getWeightName(MTENetworkSwitch base, Parameters.IParameter p) {
        return StatCollector.func_74838_a((String)"tt.keyword.Weight") + " " + (p.hatchId() + 1);
    }

    private static LedStatus getWeightStatus(MTENetworkSwitch base, Parameters.IParameter p) {
        double v = p.get();
        if (Double.isNaN(v)) {
            return LedStatus.STATUS_WRONG;
        }
        if (v < 0.0) {
            return LedStatus.STATUS_TOO_LOW;
        }
        if (v == 0.0) {
            return LedStatus.STATUS_LOW;
        }
        if (Double.isInfinite(v)) {
            return LedStatus.STATUS_HIGH;
        }
        return LedStatus.STATUS_OK;
    }

    @Override
    protected void parametersInstantiation_EM() {
        this.dst = new Parameters.Group.ParameterIn[10];
        this.weight = new Parameters.Group.ParameterIn[10];
        for (int i = 0; i < 10; ++i) {
            Parameters.Group hatch = this.parametrization.getGroup(i);
            this.dst[i] = hatch.makeInParameter(0, i + 1, DEST_NAME, DEST_STATUS);
            this.weight[i] = hatch.makeInParameter(1, 0.0, WEIGHT_NAME, WEIGHT_STATUS);
        }
    }

    @Override
    @NotNull
    protected CheckRecipeResult checkProcessing_EM() {
        int thingsActive = 0;
        for (MTEHatchDataInput di : this.eInputData) {
            if (di.q == null) continue;
            thingsActive = (short)(thingsActive + 1);
        }
        if (thingsActive > 0) {
            thingsActive = (short)(thingsActive + this.eOutputData.size());
            this.mEUt = -((int)GTValues.V[7]);
            this.eAmpereFlow = 1 + (thingsActive >> 2);
            this.mMaxProgresstime = 20;
            this.mEfficiencyIncrease = 10000;
            return SimpleCheckRecipeResult.ofSuccess("routing");
        }
        return SimpleCheckRecipeResult.ofFailure("no_routing");
    }

    @Override
    public void outputAfterRecipe_EM() {
        if (!this.eOutputData.isEmpty()) {
            double weight;
            double total = 0.0;
            for (int i = 0; i < 10; ++i) {
                weight = this.weight[i].get();
                if (!(weight > 0.0) || !(this.dst[i].get() >= 0.0)) continue;
                total += weight;
            }
            Vec3Impl pos = new Vec3Impl(this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord());
            QuantumDataPacket pack = new QuantumDataPacket(0L).unifyTraceWith(pos);
            if (pack == null) {
                return;
            }
            for (MTEHatchDataInput hatch : this.eInputData) {
                if (hatch.q == null || ((QuantumDataPacket)hatch.q).contains(pos) || (pack = pack.unifyPacketWith((QuantumDataPacket)hatch.q)) != null) continue;
                return;
            }
            long remaining = (Long)pack.getContent();
            for (int i = 0; i < 10; ++i) {
                int outIndex;
                double dest = this.dst[i].get();
                weight = this.weight[i].get();
                if (!(weight > 0.0) || !(dest >= 0.0) || (outIndex = (int)dest - 1) < 0 || outIndex >= this.eOutputData.size()) continue;
                MTEHatchDataOutput out = (MTEHatchDataOutput)this.eOutputData.get(outIndex);
                if (Double.isInfinite(total)) {
                    if (!Double.isInfinite(weight)) continue;
                    out.q = new QuantumDataPacket(remaining).unifyTraceWith(pack);
                    break;
                }
                long part = (long)Math.floor((double)((Long)pack.getContent()).longValue() * weight / total);
                if (part <= 0L) continue;
                if ((remaining -= part) > 0L) {
                    out.q = new QuantumDataPacket(part).unifyTraceWith(pack);
                    continue;
                }
                if (part + remaining <= 0L) break;
                out.q = new QuantumDataPacket(part + remaining).unifyTraceWith(pack);
                break;
            }
        }
    }
}

