/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import gregtech.api.util.GTRecipe;
import gregtech.common.misc.GlobalVariableStorage;
import gregtech.common.misc.spaceprojects.SpaceProjectManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class WirelessDataStore {
    public static final long IO_TICK_RATE = 200L;
    public static final long DOWNLOAD_TICK_OFFSET = 1L;
    private long lastUploadTick = -1L;
    private long lastDownloadTick = -1L;
    private final ArrayList<GTRecipe.RecipeAssemblyLine> uploadedSticks = new ArrayList();
    private final ArrayList<GTRecipe.RecipeAssemblyLine> dataSticks = new ArrayList();

    public void uploadData(List<GTRecipe.RecipeAssemblyLine> recipes, long tick) {
        if (this.lastUploadTick < tick) {
            this.uploadedSticks.clear();
            this.lastUploadTick = tick;
        }
        this.uploadedSticks.addAll(recipes);
    }

    public List<GTRecipe.RecipeAssemblyLine> downloadData(long tick) {
        if (this.lastDownloadTick < tick) {
            this.dataSticks.clear();
            this.dataSticks.addAll(this.uploadedSticks);
            this.lastDownloadTick = tick;
        }
        return this.dataSticks;
    }

    public static WirelessDataStore getWirelessDataSticks(UUID uuid) {
        UUID team = SpaceProjectManager.getLeader(uuid);
        if (GlobalVariableStorage.GlobalWirelessDataSticks.get(team) == null) {
            GlobalVariableStorage.GlobalWirelessDataSticks.put(team, new WirelessDataStore());
        }
        return GlobalVariableStorage.GlobalWirelessDataSticks.get(team);
    }
}

