/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.crafting;

import java.util.ArrayList;
import makeo.gadomancy.api.GadomancyApi;
import makeo.gadomancy.api.golems.AdditionalGolemType;
import makeo.gadomancy.common.entities.golems.upgrades.GolemUpgrade;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.golems.EnumGolemType;

public class InfusionUpgradeRecipe
extends InfusionRecipe {
    private static final ItemStack DEFAULT_OUTPUT = new ItemStack(Blocks.field_150346_d);
    private final GolemUpgrade<?> upgrade;
    private final Object cachedOutput;

    private InfusionUpgradeRecipe(String research, GolemUpgrade<?> upgrade, int inst, AspectList aspects2, ItemStack input, ItemStack[] recipe) {
        super(research, (Object)DEFAULT_OUTPUT, inst, aspects2, input, recipe);
        this.upgrade = upgrade;
        this.cachedOutput = super.getRecipeOutput();
    }

    public boolean matches(ArrayList<ItemStack> input, ItemStack central, World world, EntityPlayer player) {
        return super.matches(input, central, world, player) && !this.upgrade.hasUpgrade(central);
    }

    public Object getRecipeOutput(ItemStack input) {
        ItemStack output = input.func_77946_l();
        this.upgrade.addUpgrade(output);
        return output;
    }

    public Object getRecipeOutput() {
        return this.cachedOutput;
    }

    public static InfusionUpgradeRecipe[] createRecipes(String research, GolemUpgrade upgrade, int inst, AspectList aspects, ItemStack[] recipe) {
        InfusionUpgradeRecipe[] recipes = new InfusionUpgradeRecipe[EnumGolemType.values().length];
        for (int i = 0; i < EnumGolemType.values().length; ++i) {
            EnumGolemType type = EnumGolemType.values()[i];
            if (type.health <= 0) continue;
            AdditionalGolemType addType = GadomancyApi.getAdditionalGolemType(type);
            Item input = addType == null ? ConfigItems.itemGolemPlacer : addType.getPlacerItem();
            recipes[i] = new InfusionUpgradeRecipe(research, upgrade, inst, aspects, new ItemStack(input, 1, type.ordinal()), recipe);
        }
        return recipes;
    }
}

