/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.aura;

import java.util.Random;
import makeo.gadomancy.api.AuraEffect;
import makeo.gadomancy.common.events.EventHandlerEntity;
import makeo.gadomancy.common.integration.IntegrationThaumicTinkerer;
import makeo.gadomancy.common.registration.RegisteredIntegrations;
import makeo.gadomancy.common.registration.RegisteredPotions;
import makeo.gadomancy.common.utils.MiscUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.BlockTaintFibres;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigEntities;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumcraft.common.entities.monster.EntityBrainyZombie;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.research.ScanManager;
import thaumcraft.common.lib.utils.EntityUtils;
import thaumcraft.common.lib.utils.Utils;
import thaumcraft.common.lib.world.ThaumcraftWorldGenerator;

public class AuraEffects {
    private static final ItemStack[][] ITEMS_SOUL = new ItemStack[][]{{new ItemStack((Item)Items.field_151031_f), new ItemStack(Items.field_151041_m), new ItemStack(Items.field_151052_q), new ItemStack(Items.field_151040_l), new ItemStack(Items.field_151049_t), new ItemStack(Items.field_151036_c)}, {new ItemStack((Item)Items.field_151021_T), new ItemStack((Item)Items.field_151029_X), new ItemStack((Item)Items.field_151167_ab)}, {new ItemStack((Item)Items.field_151026_S), new ItemStack((Item)Items.field_151022_W), new ItemStack((Item)Items.field_151165_aa)}, {new ItemStack((Item)Items.field_151027_R), new ItemStack((Item)Items.field_151023_V), new ItemStack((Item)Items.field_151030_Z)}, {new ItemStack(Blocks.field_150428_aP), new ItemStack(Blocks.field_150423_aK)}};
    public static final AuraEffect AER = new PotionDistributionEffect(Potion.field_76424_c, 4, 6, MiscUtils.ticksForMinutes(6), 1).register(Aspect.AIR);
    public static final AuraEffect AQUA = new PotionDistributionEffect(Potion.field_76427_o, 4, 10, MiscUtils.ticksForMinutes(10), 0).register(Aspect.WATER);
    public static final AuraEffect TERRA = new PotionDistributionEffect(Potion.field_76429_m, 4, 8, MiscUtils.ticksForMinutes(5), 0).register(Aspect.EARTH);
    public static final AuraEffect ORDO = new PotionDistributionEffect(Potion.field_76428_l, 4, 6, MiscUtils.ticksForMinutes(3), 0).register(Aspect.ORDER);
    public static final AuraEffect PERDITIO = new PotionDistributionEffect(Potion.field_76437_t, 4, 8, MiscUtils.ticksForMinutes(3), 0).register(Aspect.ENTROPY);
    public static final AuraEffect TELUM = new PotionDistributionEffect(Potion.field_76420_g, 4, 6, MiscUtils.ticksForMinutes(6), 2).register(Aspect.WEAPON);
    public static final AuraEffect TUTAMEN = new PotionDistributionEffect(Potion.field_76429_m, 4, 6, MiscUtils.ticksForMinutes(6), 1).register(Aspect.ARMOR);
    public static final AuraEffect MOTUS = new PotionDistributionEffect(Potion.field_76424_c, 4, 6, MiscUtils.ticksForMinutes(2), 2).register(Aspect.MOTION);
    public static final AuraEffect ITER = new PotionDistributionEffect(Potion.field_76424_c, 2, 10, MiscUtils.ticksForMinutes(15), 0).register(Aspect.TRAVEL);
    public static final AuraEffect FAMES = new PotionDistributionEffect(Potion.field_76438_s, 4, 6, MiscUtils.ticksForMinutes(2), 0).register(Aspect.HUNGER);
    public static final AuraEffect SENSUS = new PotionDistributionEffect(Potion.field_76439_r, 2, 8, MiscUtils.ticksForMinutes(8), 0).register(Aspect.SENSES);
    public static final AuraEffect VOLATUS = new PotionDistributionEffect(Potion.field_76430_j, 2, 5, MiscUtils.ticksForMinutes(4), 0).register(Aspect.FLIGHT);
    public static final AuraEffect POTENTIA = new PotionDistributionEffect(Potion.field_76420_g, 4, 6, MiscUtils.ticksForMinutes(4), 0).register(Aspect.ENERGY);
    public static final AuraEffect TENEBRAE = new PotionDistributionEffect(Potion.field_76440_q, 4, 6, MiscUtils.ticksForMinutes(1), 0).register(Aspect.DARKNESS);
    public static final AuraEffect SANO = new PotionDistributionEffect(Potion.field_76428_l, 8, 10, MiscUtils.ticksForMinutes(5), 1).register(Aspect.HEAL);
    public static final AuraEffect MORTUUS = new PotionDistributionEffect(Potion.field_82731_v, 4, 6, MiscUtils.ticksForMinutes(3), 1).register(Aspect.DEATH);
    public static final AuraEffect HUMANUS = new PotionDistributionEffect(Potion.field_76434_w, 2, 5, MiscUtils.ticksForMinutes(4), 1).register(Aspect.MAN);
    public static final AuraEffect INSTRUMENTUM = new PotionDistributionEffect(Potion.field_76422_e, 2, 7, MiscUtils.ticksForMinutes(6), 0).register(Aspect.TOOL);
    public static final AuraEffect PERFODIO = new PotionDistributionEffect(Potion.field_76422_e, 2, 7, MiscUtils.ticksForMinutes(5), 2).register(Aspect.MINE);
    public static final AuraEffect VENENUM = new PotionDistributionEffect(Potion.field_76436_u, 2, 6, MiscUtils.ticksForMinutes(1), 0).register(Aspect.POISON);
    public static final AuraEffect VINCULUM = new PotionDistributionEffect(Potion.field_76421_d, 4, 6, MiscUtils.ticksForMinutes(3), 0).register(Aspect.TRAP);
    public static final AuraEffect LUCRUM = new PotionDistributionEffect(RegisteredPotions.POTION_LUCK, 4, 6, MiscUtils.ticksForMinutes(5), 1).register(Aspect.GREED);
    public static final AuraEffect VICTUS = new AuraEffect.EntityAuraEffect(){

        @Override
        public boolean isEntityApplicable(Entity e) {
            return e instanceof EntityAgeable && ((EntityAgeable)e).func_70874_b() < 0;
        }

        @Override
        public void doEntityEffect(ChunkCoordinates originTile, Entity e) {
            if (e instanceof EntityPlayer) {
                return;
            }
            EntityAgeable ageable = (EntityAgeable)e;
            if (ageable.field_70170_p.field_73012_v.nextInt(20) == 0) {
                ageable.func_70873_a(0);
            }
        }
    }.register(Aspect.LIFE);
    public static final AuraEffect PANNUS = new AuraEffect.EntityAuraEffect(){

        @Override
        public boolean isEntityApplicable(Entity e) {
            return e instanceof EntitySheep && ((EntitySheep)e).func_70892_o();
        }

        @Override
        public void doEntityEffect(ChunkCoordinates originTile, Entity e) {
            EntitySheep sheep = (EntitySheep)e;
            if (sheep.field_70170_p.field_73012_v.nextInt(10) == 0) {
                sheep.func_70893_e(false);
            }
        }

        @Override
        public int getTickInterval() {
            return 10;
        }
    }.register(Aspect.CLOTH);
    public static final AuraEffect LUX = new AuraEffect.EntityAuraEffect(){

        @Override
        public boolean isEntityApplicable(Entity e) {
            return true;
        }

        @Override
        public void doEntityEffect(ChunkCoordinates originTile, Entity e) {
            if (!EventHandlerEntity.registeredLuxPylons.contains(originTile)) {
                EventHandlerEntity.registeredLuxPylons.add(originTile);
            }
        }

        @Override
        public int getTickInterval() {
            return 4;
        }

        @Override
        public double getRange() {
            return 64.0;
        }
    }.register(Aspect.LIGHT);
    public static final AuraEffect TEMPESTAS = new AuraEffect.BlockAuraEffect(){

        @Override
        public int getBlockCount(Random random) {
            return random.nextInt(10) == 0 ? 1 : 0;
        }

        @Override
        public void doBlockEffect(ChunkCoordinates originTile, ChunkCoordinates selectedBlock, World world) {
            int highestY = world.func_72825_h(selectedBlock.field_71574_a, selectedBlock.field_71573_c);
            EntityLightningBolt entityLightning = new EntityLightningBolt(world, (double)selectedBlock.field_71574_a + 0.5, (double)highestY, (double)selectedBlock.field_71573_c + 0.5);
            world.func_72942_c((Entity)entityLightning);
        }
    }.register(Aspect.WEATHER);
    public static final AuraEffect VITIUM = new AuraEffect(){

        @Override
        public AuraEffect.EffectType getEffectType() {
            return null;
        }

        @Override
        public boolean isEntityApplicable(Entity e) {
            return e instanceof EntityLivingBase;
        }

        @Override
        public void doEntityEffect(ChunkCoordinates originTile, Entity e) {
            if (e.field_70170_p.field_73012_v.nextInt(20) == 0 && !((EntityLivingBase)e).func_82165_m(Config.potionTaintPoisonID)) {
                ((EntityLivingBase)e).func_70690_d(new PotionEffect(Config.potionTaintPoisonID, MiscUtils.ticksForSeconds(20), 0, true));
            }
        }

        @Override
        public int getBlockCount(Random random) {
            return 5;
        }

        @Override
        public void doBlockEffect(ChunkCoordinates originTile, ChunkCoordinates selectedBlock, World world) {
            if (!Config.genTaint) {
                return;
            }
            int x = selectedBlock.field_71574_a;
            int y = selectedBlock.field_71572_b;
            int z = selectedBlock.field_71573_c;
            BlockTaintFibres.spreadFibres((World)world, (int)x, (int)y, (int)z);
            if (world.field_73012_v.nextInt(12) == 0) {
                Utils.setBiomeAt((World)world, (int)x, (int)z, (BiomeGenBase)ThaumcraftWorldGenerator.biomeTaint);
                world.func_147452_c(x, y, z, world.func_147439_a(x, y, z), 1, 0);
            }
        }

        @Override
        public double getRange() {
            return 14.0;
        }
    }.register(Aspect.TAINT);
    public static final AuraEffect GELUM = new AuraEffect(){

        @Override
        public AuraEffect.EffectType getEffectType() {
            return null;
        }

        @Override
        public boolean isEntityApplicable(Entity e) {
            return e instanceof EntityLivingBase;
        }

        @Override
        public void doEntityEffect(ChunkCoordinates originTile, Entity e) {
            boolean canAdd;
            EntityLivingBase living = (EntityLivingBase)e;
            int activeDuration = 0;
            if (living.func_70644_a(Potion.field_76421_d)) {
                PotionEffect effect = living.func_70660_b(Potion.field_76421_d);
                activeDuration = effect.func_76459_b();
            }
            boolean bl = canAdd = MiscUtils.ticksForMinutes(3) - activeDuration >= 5;
            if (canAdd) {
                living.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), activeDuration + 5, 1, true));
            }
        }

        @Override
        public int getTickInterval() {
            return 2;
        }

        @Override
        public int getBlockCount(Random random) {
            return random.nextInt(10) + 10;
        }

        @Override
        public void doBlockEffect(ChunkCoordinates originTile, ChunkCoordinates selectedBlock, World world) {
            Block selected = world.func_147439_a(selectedBlock.field_71574_a, selectedBlock.field_71572_b, selectedBlock.field_71573_c);
            if (selected.equals(Blocks.field_150355_j) && world.func_72805_g(selectedBlock.field_71574_a, selectedBlock.field_71572_b, selectedBlock.field_71573_c) == 0) {
                world.func_147449_b(selectedBlock.field_71574_a, selectedBlock.field_71572_b, selectedBlock.field_71573_c, Blocks.field_150432_aD);
            }
        }
    }.register(Aspect.COLD);
    public static final AuraEffect EXAMINIS = new AuraEffect(){

        @Override
        public AuraEffect.EffectType getEffectType() {
            return null;
        }

        @Override
        public boolean isEntityApplicable(Entity e) {
            return e instanceof EntityLivingBase && ((EntityLivingBase)e).func_70662_br();
        }

        @Override
        public void doEntityEffect(ChunkCoordinates originTile, Entity e) {
            AuraEffects.addOrExtendPotionEffect(Potion.field_76420_g, (EntityLivingBase)e, MiscUtils.ticksForMinutes(3), 30, 1, false);
            AuraEffects.addOrExtendPotionEffect(Potion.field_76424_c, (EntityLivingBase)e, MiscUtils.ticksForMinutes(3), 30, 0, false);
            AuraEffects.addOrExtendPotionEffect(Potion.field_76428_l, (EntityLivingBase)e, MiscUtils.ticksForMinutes(3), 30, 0, false);
        }

        @Override
        public int getTickInterval() {
            return 4;
        }

        @Override
        public int getBlockCount(Random random) {
            return random.nextInt(60) == 0 ? 1 : 0;
        }

        @Override
        public void doBlockEffect(ChunkCoordinates originTile, ChunkCoordinates selectedBlock, World world) {
            boolean canSpawn;
            EntityBrainyZombie zombie = new EntityBrainyZombie(world);
            boolean bl = canSpawn = AuraEffects.setAndCheckPosition((EntityLivingBase)zombie, selectedBlock, world, true) && zombie.func_70601_bi();
            if (canSpawn) {
                ChunkCoordinates pos = new ChunkCoordinates((int)zombie.field_70165_t, (int)zombie.field_70163_u, (int)zombie.field_70161_v);
                pos = AuraEffects.iterateDown(pos, world);
                zombie.func_70107_b((double)pos.field_71574_a + 0.5, (double)pos.field_71572_b, (double)pos.field_71573_c + 0.5);
                world.func_72838_d((Entity)zombie);
            }
        }

        @Override
        public double getRange() {
            return 10.0;
        }
    }.register(Aspect.UNDEAD);
    public static final AuraEffect AURAM = new AuraEffect.EntityAuraEffect(){

        @Override
        public boolean isEntityApplicable(Entity e) {
            return e instanceof EntityPlayer;
        }

        @Override
        public void doEntityEffect(ChunkCoordinates originTile, Entity e) {
            EntityPlayer player = (EntityPlayer)e;
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() != null && player.func_70694_bm().func_77973_b() instanceof ItemWandCasting) {
                ItemStack wand = player.func_70694_bm();
                ItemWandCasting wandCasting = (ItemWandCasting)wand.func_77973_b();
                AspectList al = wandCasting.getAspectsWithRoom(wand);
                for (Aspect a : al.getAspects()) {
                    if (a == null) continue;
                    wandCasting.addRealVis(wand, a, 4, true);
                }
            }
        }

        @Override
        public int getTickInterval() {
            return 1;
        }
    }.register(Aspect.AURA);
    public static final AuraEffect COGNITIO = new AuraEffect.EntityAuraEffect(){

        @Override
        public boolean isEntityApplicable(Entity e) {
            return e instanceof EntityPlayer;
        }

        @Override
        public void doEntityEffect(ChunkCoordinates originTile, Entity e) {
            EntityPlayer player = (EntityPlayer)e;
            for (Aspect a : Aspect.getPrimalAspects()) {
                if (a == null || e.field_70170_p.field_73012_v.nextInt(40) != 0) continue;
                if (e.field_70170_p.field_73012_v.nextInt(20) == 0) {
                    Thaumcraft.addWarpToPlayer((EntityPlayer)player, (int)1, (boolean)true);
                }
                ScanManager.checkAndSyncAspectKnowledge((EntityPlayer)player, (Aspect)a, (int)1);
            }
        }

        @Override
        public int getTickInterval() {
            return 40;
        }
    }.register(Aspect.MIND);
    public static final AuraEffect FABRICO = new AuraEffect(){

        @Override
        public AuraEffect.EffectType getEffectType() {
            return null;
        }

        @Override
        public boolean isEntityApplicable(Entity e) {
            return e instanceof EntityGolemBase;
        }

        @Override
        public void doEntityEffect(ChunkCoordinates originTile, Entity e) {
            EntityGolemBase golem = (EntityGolemBase)e;
            AuraEffects.addOrExtendPotionEffect(RegisteredPotions.BUFF_GOLEM, (EntityLivingBase)golem, MiscUtils.ticksForMinutes(6), 10, 0, false);
        }

        @Override
        public int getBlockCount(Random random) {
            return RegisteredIntegrations.automagy.isPresent() ? 50 : 0;
        }

        @Override
        public void doBlockEffect(ChunkCoordinates originTile, ChunkCoordinates selectedBlock, World world) {
            RegisteredIntegrations.automagy.tryFillGolemCrafttable(selectedBlock, world);
        }
    }.register(Aspect.CRAFT);
    public static final AuraEffect HERBA = new AuraEffect.BlockAuraEffect(){

        @Override
        public int getBlockCount(Random random) {
            return 180;
        }

        @Override
        public void doBlockEffect(ChunkCoordinates originTile, ChunkCoordinates selectedBlock, World world) {
            AuraEffects.waterLocation(selectedBlock, world);
        }

        @Override
        public int getTickInterval() {
            return 1;
        }
    }.register(Aspect.PLANT);
    public static final AuraEffect ARBOR = new AuraEffect.BlockAuraEffect(){

        @Override
        public int getBlockCount(Random random) {
            return 120;
        }

        @Override
        public void doBlockEffect(ChunkCoordinates originTile, ChunkCoordinates selectedBlock, World world) {
            AuraEffects.waterLocation(selectedBlock, world);
        }

        @Override
        public int getTickInterval() {
            return 3;
        }
    }.register(Aspect.TREE);
    public static final AuraEffect IGNIS = new AuraEffect.EntityAuraEffect(){

        @Override
        public boolean isEntityApplicable(Entity e) {
            return e instanceof EntityLivingBase;
        }

        @Override
        public void doEntityEffect(ChunkCoordinates originTile, Entity e) {
            if (!e.func_70045_F()) {
                e.func_70015_d(10);
            }
        }
    }.register(Aspect.FIRE);
    public static final AuraEffect ELDRITCH = new AuraEffect.EntityAuraEffect(){

        @Override
        public boolean isEntityApplicable(Entity e) {
            EntityMob mob;
            if (e instanceof EntityMob && (mob = (EntityMob)e).func_110148_a(EntityUtils.CHAMPION_MOD).func_111126_e() < 0.0 && mob.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() >= 10.0) {
                boolean whitelisted = false;
                for (Class clazz : ConfigEntities.championModWhitelist.keySet()) {
                    if (!clazz.isAssignableFrom(e.getClass())) continue;
                    whitelisted = true;
                }
                return whitelisted;
            }
            return false;
        }

        @Override
        public int getTickInterval() {
            return 20;
        }

        @Override
        public void doEntityEffect(ChunkCoordinates originTile, Entity e) {
            if (e.field_70170_p.field_73012_v.nextInt(4) == 0) {
                EntityMob mob = (EntityMob)e;
                PotionEffect effect = mob.func_70660_b((Potion)RegisteredPotions.ELDRITCH);
                if (effect != null && effect.func_76458_c() > 4) {
                    EntityUtils.makeChampion((EntityMob)mob, (boolean)false);
                    mob.func_82170_o(RegisteredPotions.ELDRITCH.func_76396_c());
                } else {
                    mob.func_70690_d(new PotionEffect(RegisteredPotions.ELDRITCH.func_76396_c(), MiscUtils.ticksForMinutes(1), effect == null ? 1 : effect.func_76458_c() + 1));
                }
            }
        }
    }.register(Aspect.ELDRITCH);
    public static final AuraEffect SOUL = new AuraEffect.BlockAuraEffect(){

        @Override
        public int getBlockCount(Random random) {
            return random.nextInt(60) == 0 ? 1 : 0;
        }

        @Override
        public int getTickInterval() {
            return 4;
        }

        @Override
        public void doBlockEffect(ChunkCoordinates originTile, ChunkCoordinates selectedBlock, World world) {
            EntitySkeleton mob;
            Object object = mob = world.field_73012_v.nextBoolean() ? new EntitySkeleton(world) : new EntityZombie(world);
            if (AuraEffects.setAndCheckPosition((EntityLivingBase)mob, selectedBlock, world, true) && world.field_73013_u != EnumDifficulty.PEACEFUL) {
                for (int i = 0; i < 5; ++i) {
                    mob.func_70062_b(i, null);
                }
                int timeout = 40;
                int totalCount = (world.field_73012_v.nextInt(3) == 0 ? 1 : 0) + 2;
                do {
                    ItemStack[] items;
                    ItemStack stack;
                    int slot;
                    int n = mob.func_71124_b(0) == null ? 0 : (slot = mob.func_71124_b(4) == null ? 4 : world.field_73012_v.nextInt(3) + 1);
                    if (mob.func_71124_b(slot) != null || (stack = (items = ITEMS_SOUL[slot])[world.field_73012_v.nextInt(items.length)]).func_77973_b() == Items.field_151031_f && !(mob instanceof EntitySkeleton)) continue;
                    --totalCount;
                    mob.func_70062_b(slot, stack);
                    mob.func_96120_a(slot, 0.0f);
                } while (totalCount > 0 && --timeout > 0);
                if (timeout > 0) {
                    mob.func_70690_d(new PotionEffect(Potion.field_76441_p.func_76396_c(), MiscUtils.ticksForMinutes(525600), 1, true));
                    ChunkCoordinates pos = new ChunkCoordinates((int)mob.field_70165_t, (int)mob.field_70163_u, (int)mob.field_70161_v);
                    pos = AuraEffects.iterateDown(pos, world);
                    mob.func_70107_b((double)pos.field_71574_a + 0.5, (double)pos.field_71572_b, (double)pos.field_71573_c + 0.5);
                    world.func_72838_d((Entity)mob);
                }
            }
        }
    }.register(Aspect.SOUL);
    public static final AuraEffect PRAECANTATIO = new PotionDistributionEffect(RegisteredPotions.VIS_DISCOUNT, 4, 6, MiscUtils.ticksForMinutes(5), 1).register(Aspect.MAGIC);
    public static final AuraEffect LIMUS = new AuraEffect.BlockAuraEffect(){

        @Override
        public int getBlockCount(Random random) {
            return random.nextInt(40) == 0 ? 1 : 0;
        }

        @Override
        public void doBlockEffect(ChunkCoordinates originTile, ChunkCoordinates selectedBlock, World world) {
            boolean canSpawn;
            EntitySlime slime = new EntitySlime(world);
            NBTTagCompound data = new NBTTagCompound();
            slime.func_70014_b(data);
            data.func_74768_a("Size", 0);
            slime.func_70037_a(data);
            boolean bl = canSpawn = AuraEffects.setAndCheckPosition((EntityLivingBase)slime, selectedBlock, world, true) && world.field_73013_u != EnumDifficulty.PEACEFUL;
            if (canSpawn) {
                ChunkCoordinates pos = new ChunkCoordinates((int)slime.field_70165_t, (int)slime.field_70163_u, (int)slime.field_70161_v);
                pos = AuraEffects.iterateDown(pos, world);
                slime.func_70107_b((double)pos.field_71574_a + 0.5, (double)pos.field_71572_b, (double)pos.field_71573_c + 0.5);
                world.func_72838_d((Entity)slime);
            }
        }

        @Override
        public int getTickInterval() {
            return 4;
        }
    }.register(Aspect.SLIME);
    public static final AuraEffect BESTIA = new AuraEffect.BlockAuraEffect(){
        private final Class[] animalClasses = new Class[]{EntitySheep.class, EntityCow.class, EntityChicken.class, EntityPig.class};

        @Override
        public int getBlockCount(Random random) {
            return random.nextInt(60) == 0 ? 1 : 0;
        }

        @Override
        public void doBlockEffect(ChunkCoordinates originTile, ChunkCoordinates selectedBlock, World world) {
            EntityLivingBase animal;
            Class animalClass = this.animalClasses[world.field_73012_v.nextInt(this.animalClasses.length)];
            try {
                animal = (EntityLivingBase)animalClass.getConstructor(World.class).newInstance(world);
            }
            catch (Exception e) {
                return;
            }
            boolean canSpawn = AuraEffects.setAndCheckPosition(animal, selectedBlock, world, true);
            if (canSpawn) {
                ChunkCoordinates pos = new ChunkCoordinates((int)animal.field_70165_t, (int)animal.field_70163_u, (int)animal.field_70161_v);
                pos = AuraEffects.iterateDown(pos, world);
                animal.func_70107_b((double)pos.field_71574_a + 0.5, (double)pos.field_71572_b, (double)pos.field_71573_c + 0.5);
                world.func_72838_d((Entity)animal);
            }
        }

        @Override
        public int getTickInterval() {
            return 4;
        }
    }.register(Aspect.BEAST);
    public static final AuraEffect VITREUS = new PotionDistributionEffect(RegisteredPotions.ACHROMATIC, 4, 6, MiscUtils.ticksForMinutes(5), 0){

        @Override
        public boolean isEntityApplicable(Entity e) {
            return e instanceof EntityPlayer;
        }
    }.register(Aspect.CRYSTAL);

    private static void waterLocation(ChunkCoordinates coordinates, World world) {
        TileEntity te;
        Block block = world.func_147439_a(coordinates.field_71574_a, coordinates.field_71572_b, coordinates.field_71573_c);
        if (block.func_149653_t()) {
            world.func_147464_a(coordinates.field_71574_a, coordinates.field_71572_b, coordinates.field_71573_c, block, world.field_73012_v.nextInt(8) + 2);
        }
        if (IntegrationThaumicTinkerer.isCropBlock(block) && (te = world.func_147438_o(coordinates.field_71574_a, coordinates.field_71572_b, coordinates.field_71573_c)) != null && IntegrationThaumicTinkerer.isCropTile(te)) {
            for (int i = 0; i < 10; ++i) {
                te.func_145845_h();
            }
        }
    }

    private static void addOrExtendPotionEffect(Potion potion, EntityLivingBase entityLiving, int cap, int durToAdd, int amplifier, boolean ambient) {
        boolean canAdd;
        int activeDuration = 0;
        if (entityLiving.func_70644_a(potion)) {
            PotionEffect effect = entityLiving.func_70660_b(potion);
            activeDuration = effect.func_76459_b();
        }
        boolean bl = canAdd = cap - activeDuration >= durToAdd;
        if (canAdd) {
            entityLiving.func_70690_d(new PotionEffect(potion.func_76396_c(), activeDuration + durToAdd, amplifier, ambient));
        }
    }

    private static void addOrExtendPotionEffect(Potion potion, EntityLivingBase entityLiving, int cap, int durToAdd, int amplifier) {
        AuraEffects.addOrExtendPotionEffect(potion, entityLiving, cap, durToAdd, amplifier, true);
    }

    private static ChunkCoordinates iterateDown(ChunkCoordinates pos, World world) {
        while (world.func_147437_c(pos.field_71574_a, pos.field_71572_b, pos.field_71573_c)) {
            --pos.field_71572_b;
        }
        ++pos.field_71572_b;
        return pos;
    }

    private static boolean setAndCheckPosition(EntityLivingBase entity, ChunkCoordinates cc, World world, boolean mayVary) {
        if (!world.func_147437_c(cc.field_71574_a, cc.field_71572_b, cc.field_71573_c)) {
            if (!mayVary) {
                return false;
            }
            ChunkCoordinates up = new ChunkCoordinates(cc.field_71574_a, cc.field_71572_b + 1, cc.field_71573_c);
            if (AuraEffects.setAndCheckPosition(entity, up, world, false)) {
                return true;
            }
            ChunkCoordinates down = new ChunkCoordinates(cc.field_71574_a, cc.field_71572_b - 1, cc.field_71573_c);
            return AuraEffects.setAndCheckPosition(entity, down, world, false);
        }
        ChunkCoordinates up = new ChunkCoordinates(cc.field_71574_a, cc.field_71572_b + 1, cc.field_71573_c);
        if (world.func_147437_c(up.field_71574_a, up.field_71572_b, up.field_71573_c)) {
            entity.func_70107_b((double)up.field_71574_a, (double)up.field_71572_b, (double)up.field_71573_c);
            return true;
        }
        ChunkCoordinates down = new ChunkCoordinates(cc.field_71574_a, cc.field_71572_b - 1, cc.field_71573_c);
        if (world.func_147437_c(down.field_71574_a, down.field_71572_b, down.field_71573_c)) {
            entity.func_70107_b((double)down.field_71574_a, (double)down.field_71572_b, (double)down.field_71573_c);
            return true;
        }
        if (!mayVary) {
            return false;
        }
        ChunkCoordinates hMove = new ChunkCoordinates(cc.field_71574_a + 1, cc.field_71572_b, cc.field_71573_c);
        if (AuraEffects.setAndCheckPosition(entity, hMove, world, false)) {
            return true;
        }
        hMove = new ChunkCoordinates(cc.field_71574_a, cc.field_71572_b, cc.field_71573_c + 1);
        if (AuraEffects.setAndCheckPosition(entity, hMove, world, false)) {
            return true;
        }
        hMove = new ChunkCoordinates(cc.field_71574_a - 1, cc.field_71572_b, cc.field_71573_c);
        if (AuraEffects.setAndCheckPosition(entity, hMove, world, false)) {
            return true;
        }
        hMove = new ChunkCoordinates(cc.field_71574_a, cc.field_71572_b, cc.field_71573_c - 1);
        return AuraEffects.setAndCheckPosition(entity, hMove, world, false);
    }

    public static class PotionDistributionEffect
    extends AuraEffect.EntityAuraEffect {
        private Potion potion;
        private int tickInterval;
        private int addedDuration;
        private int durationCap;
        private int amplifier;

        public PotionDistributionEffect(Potion potion, int tickInterval, int addedDuration, int durationCap, int amplifier) {
            this.potion = potion;
            this.tickInterval = tickInterval;
            this.addedDuration = addedDuration;
            this.durationCap = durationCap;
            this.amplifier = amplifier;
        }

        @Override
        public boolean isEntityApplicable(Entity e) {
            return e instanceof EntityLivingBase;
        }

        @Override
        public void doEntityEffect(ChunkCoordinates originTile, Entity e) {
            if (e == null || !(e instanceof EntityLivingBase)) {
                return;
            }
            EntityLivingBase living = (EntityLivingBase)e;
            AuraEffects.addOrExtendPotionEffect(this.potion, living, this.durationCap, this.addedDuration, this.amplifier);
        }

        @Override
        public int getTickInterval() {
            return this.tickInterval;
        }
    }
}

