/*
 * Decompiled with CFR 0.152.
 */
package gravisuite;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.GraviSuite;
import gravisuite.Helpers;
import gravisuite.IItemTickListener;
import gravisuite.ServerProxy;
import gravisuite.keyboard.Keyboard;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IMetalArmor;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;

public class ItemAdvancedLappack
extends ItemArmor
implements IElectricItem,
IMetalArmor,
ISpecialArmor,
IItemTickListener {
    private int maxCharge;
    private int transferLimit;
    private int tier;
    public String itemNm;
    private Boolean activated = false;

    public ItemAdvancedLappack(ItemArmor.ArmorMaterial armorMaterial, int par3, int par4, int MaxCharge, int Tier, int TransferLimit) {
        super(armorMaterial, par3, par4);
        this.maxCharge = MaxCharge;
        this.transferLimit = TransferLimit;
        this.func_77637_a(GraviSuite.ic2Tab);
        this.tier = Tier;
        this.func_77656_e(27);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        int energyPerDamage = this.getEnergyPerDamage();
        int damageLimit = (int)(energyPerDamage > 0 ? 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage : 0.0);
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, damageLimit);
    }

    public static int getCharge(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        int k = nbttagcompound.func_74762_e("charge");
        return k;
    }

    public int getEnergyPerDamage() {
        return 0;
    }

    public double getDamageAbsorptionRatio() {
        return 0.0;
    }

    private double getBaseAbsorptionRatio() {
        return 0.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("gravisuite:itemAdvancedLappack");
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "gravisuite:textures/armor/armor_advanced_lappack.png";
    }

    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio());
    }

    public void damageArmor(EntityLiving entity, ItemStack itemstack, DamageSource source, int damage, int slot) {
        ElectricItem.manager.discharge(itemstack, (double)(damage * this.getEnergyPerDamage()), Integer.MAX_VALUE, true, false, false);
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs var2, List var3) {
        ItemStack var4 = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
        var3.add(var4);
        var3.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack var1) {
        return EnumRarity.uncommon;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
    }

    public static Integer readToolMode(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        Integer toolMode = nbttagcompound.func_74762_e("toolMode");
        if (toolMode < 0 || toolMode > 1) {
            toolMode = 0;
        }
        return toolMode;
    }

    public void saveToolMode(ItemStack itemstack, Integer toolMode) {
        NBTTagCompound nbttagcompound = GraviSuite.getOrCreateNbtData(itemstack);
        nbttagcompound.func_74768_a("toolMode", toolMode.intValue());
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (Keyboard.isModeKeyDown(player) && GraviSuite.isSimulating()) {
            Integer toolMode = ItemAdvancedLappack.readToolMode(itemStack);
            if ((toolMode = Integer.valueOf(toolMode + 1)) > 1) {
                toolMode = 0;
            }
            this.saveToolMode(itemStack, toolMode);
            if (toolMode == 0) {
                ServerProxy.sendPlayerMessage(player, EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.powerSupply") + " " + EnumChatFormatting.RED + Helpers.formatMessage("message.text.disabled"));
            }
            if (toolMode == 1) {
                ServerProxy.sendPlayerMessage(player, EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.powerSupply") + " " + EnumChatFormatting.GREEN + Helpers.formatMessage("message.text.enabled"));
            }
        }
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par3List, par4);
        Integer toolMode = ItemAdvancedLappack.readToolMode(par1ItemStack);
        if (toolMode == 0) {
            par3List.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.powerSupply") + ": " + EnumChatFormatting.RED + Helpers.formatMessage("message.text.disabled"));
        }
        if (toolMode == 1) {
            par3List.add(EnumChatFormatting.GOLD + Helpers.formatMessage("message.text.powerSupply") + ": " + EnumChatFormatting.GREEN + Helpers.formatMessage("message.text.enabled"));
        }
    }

    @Override
    public boolean onTick(EntityPlayer player, ItemStack itemstack) {
        ItemStack armorItemStack;
        Integer toolMode = ItemAdvancedLappack.readToolMode(itemstack);
        if (toolMode == 1 && GraviSuite.isSimulating() && (armorItemStack = player.field_71071_by.field_70460_b[2]) != null && armorItemStack.func_77973_b() instanceof IElectricItem) {
            double sentPacket;
            int energyPacket = this.transferLimit;
            int mainCharge = ItemAdvancedLappack.getCharge(itemstack);
            if (mainCharge <= this.transferLimit) {
                energyPacket = mainCharge;
            }
            if ((sentPacket = ElectricItem.manager.charge(armorItemStack, (double)energyPacket, 4, false, false)) > 0.0) {
                ElectricItem.manager.discharge(itemstack, sentPacket, this.tier, false, false, false);
            }
        }
        return true;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }
}

