/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.redstone;

import com.enderio.core.common.util.BlockCoord;
import com.google.common.collect.Sets;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduit.redstone.Signal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RedstoneConduitNetwork
extends AbstractConduitNetwork<IRedstoneConduit, IRedstoneConduit> {
    private final Set<Signal> signals = new HashSet<Signal>();
    boolean updatingNetwork = false;
    private boolean networkEnabled = true;

    public RedstoneConduitNetwork() {
        super(IRedstoneConduit.class, IRedstoneConduit.class);
    }

    @Override
    public void init(IConduitBundle tile, Collection<IRedstoneConduit> connections, World world) {
        super.init(tile, connections, world);
        this.updatingNetwork = true;
        this.notifyNeigborsOfSignals();
        this.updatingNetwork = false;
    }

    @Override
    public void destroyNetwork() {
        this.updatingNetwork = true;
        for (IRedstoneConduit con : this.conduits) {
            con.setActive(false);
        }
        ArrayList<Signal> copy = new ArrayList<Signal>(this.signals);
        this.signals.clear();
        for (Signal s : copy) {
            this.notifyNeigborsOfSignalUpdate(s);
        }
        this.updatingNetwork = false;
        super.destroyNetwork();
    }

    @Override
    public void addConduit(IRedstoneConduit con) {
        this.updatingNetwork = true;
        super.addConduit(con);
        Set<Signal> newInputs = con.getNetworkInputs();
        this.signals.addAll(newInputs);
        for (Signal signal : newInputs) {
            this.notifyNeigborsOfSignalUpdate(signal);
        }
        for (Signal signal : this.signals) {
            this.notifyConduitNeighbours(con, signal);
        }
        this.updatingNetwork = false;
    }

    public Set<Signal> getSignals() {
        if (this.networkEnabled) {
            return this.signals;
        }
        return Collections.emptySet();
    }

    void setNetworkEnabled(boolean enabled) {
        this.networkEnabled = enabled;
    }

    public boolean isNetworkEnabled() {
        return this.networkEnabled;
    }

    public void addSignals(Set<Signal> newSignals) {
        for (Signal signal : newSignals) {
            this.addSignal(signal);
        }
    }

    public void addSignal(Signal signal) {
        this.updatingNetwork = true;
        this.signals.add(signal);
        this.notifyNetworkOfUpdate();
        this.notifyNeigborsOfSignalUpdate(signal);
        this.updatingNetwork = false;
    }

    public void removeSignals(Set<Signal> remove) {
        for (Signal signal : remove) {
            this.removeSignal(signal);
        }
    }

    public void removeSignal(Signal signal) {
        this.updatingNetwork = true;
        this.signals.remove(signal);
        this.notifyNetworkOfUpdate();
        this.notifyNeigborsOfSignalUpdate(signal);
        this.updatingNetwork = false;
    }

    public void replaceSignal(Signal oldSig, Signal newSig) {
        this.updatingNetwork = true;
        this.signals.remove(oldSig);
        this.signals.add(newSig);
        this.notifyNetworkOfUpdate();
        this.notifyNeigborsOfSignalUpdate(newSig);
        this.updatingNetwork = false;
    }

    @Override
    public void notifyNetworkOfUpdate() {
        block0: for (IRedstoneConduit con : this.conduits) {
            con.setActive(false);
            for (Signal s : this.getSignals()) {
                if (s.strength <= 0) continue;
                con.setActive(true);
                continue block0;
            }
        }
        super.notifyNetworkOfUpdate();
    }

    @Override
    public String toString() {
        return "RedstoneConduitNetwork [signals=" + this.signalsString() + ", conduits=" + this.conduitsString() + "]";
    }

    private String conduitsString() {
        StringBuilder sb = new StringBuilder();
        for (IRedstoneConduit con : this.conduits) {
            TileEntity te = con.getBundle().getEntity();
            sb.append("<").append(te.field_145851_c).append(",").append(te.field_145848_d).append(",").append(te.field_145849_e).append(">");
        }
        return sb.toString();
    }

    String signalsString() {
        StringBuilder sb = new StringBuilder();
        for (Signal s : this.signals) {
            sb.append("<");
            sb.append(s);
            sb.append(">");
        }
        return sb.toString();
    }

    public void notifyNeigborsOfSignals() {
        for (Signal signal : this.signals) {
            this.notifyNeigborsOfSignalUpdate(signal);
        }
    }

    public void notifyNeigborsOfSignalUpdate(Signal signal) {
        ArrayList conduitsCopy = new ArrayList(this.conduits);
        for (IRedstoneConduit con : conduitsCopy) {
            this.notifyConduitNeighbours(con, signal);
        }
    }

    private void notifyConduitNeighbours(IRedstoneConduit con, Signal signal) {
        if (con.getBundle() == null) {
            System.out.println("RedstoneConduitNetwork.notifyNeigborsOfSignalUpdate: NULL BUNDLE!!!!");
            return;
        }
        TileEntity te = con.getBundle().getEntity();
        World worldObj = te.func_145831_w();
        BlockCoord bc1 = new BlockCoord(te);
        if (!worldObj.func_72899_e(te.field_145851_c, te.field_145848_d, te.field_145849_e)) {
            return;
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            BlockCoord bc2 = bc1.getLocation(dir);
            if (!worldObj.func_72899_e(bc2.x, bc2.y, bc2.z)) continue;
            worldObj.func_147460_e(bc2.x, bc2.y, bc2.z, (Block)EnderIO.blockConduitBundle);
            if (signal == null || !bc2.getBlock((IBlockAccess)worldObj).func_149721_r()) continue;
            for (ForgeDirection dir2 : ForgeDirection.VALID_DIRECTIONS) {
                BlockCoord bc3 = bc2.getLocation(dir2);
                if (bc3.equals((Object)bc1) || !worldObj.func_72899_e(bc3.x, bc3.y, bc3.z)) continue;
                worldObj.func_147460_e(bc3.x, bc3.y, bc3.z, (Block)EnderIO.blockConduitBundle);
            }
        }
    }

    public void afterChunkUnload(List<IRedstoneConduit> conduits, Set<Signal> oldSignals) {
        World world = null;
        for (IRedstoneConduit c : conduits) {
            if (world == null) {
                world = c.getBundle().getWorld();
            }
            BlockCoord loc = c.getLocation();
            if (!world.func_72899_e(loc.x, loc.y, loc.z)) continue;
            this.conduits.add(c);
            c.setNetwork(this);
        }
        HashSet valid = Sets.newHashSet();
        for (Signal s : oldSignals) {
            if (!world.func_72899_e(s.x, s.y, s.z)) continue;
            valid.add(s);
        }
        this.addSignals(valid);
    }
}

