/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.renderer.LogisticsHUDRenderer;
import logisticspipes.routing.LaserData;
import net.minecraft.entity.player.EntityPlayer;

public class RoutingLaserPacket
extends ModernPacket {
    List<LaserData> lasers = new ArrayList<LaserData>();

    public RoutingLaserPacket(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        while (data.readBoolean()) {
            this.lasers.add(new LaserData().readData(data));
        }
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsHUDRenderer.instance().setLasers(this.getLasers());
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        for (LaserData laser : this.lasers) {
            data.writeBoolean(true);
            laser.writeData(data);
        }
        data.writeBoolean(false);
    }

    @Override
    public ModernPacket template() {
        return new RoutingLaserPacket(this.getId());
    }

    public RoutingLaserPacket setLasers(List<LaserData> lasers) {
        this.lasers = lasers;
        return this;
    }

    public List<LaserData> getLasers() {
        return this.lasers;
    }
}

