/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.oc.driver;

import cpw.mods.fml.common.Optional;
import java.util.Map;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.DeviceInfo;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.ManagedEnvironment;
import net.minecraftforge.event.ServerChatEvent;
import pl.asie.computronics.api.chat.ChatAPI;
import pl.asie.computronics.api.chat.IChatListener;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.util.ChatBoxUtils;
import pl.asie.computronics.util.OCUtils;

public class RobotUpgradeChatBox
extends ManagedEnvironment
implements DeviceInfo,
IChatListener {
    private final EnvironmentHost container;
    private int distance;
    private String name = "";
    protected Map<String, String> deviceInfo;

    public RobotUpgradeChatBox(EnvironmentHost container) {
        this.container = container;
        this.distance = Config.CHATBOX_DISTANCE;
        this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Network).withConnector().withComponent("chat", Visibility.Neighbors).create());
    }

    @Override
    public void receiveChatMessage(ServerChatEvent event) {
        if (!Config.CHATBOX_MAGIC && (event.player.field_70170_p != this.container.world() || event.player.func_70092_e(this.container.xPosition(), this.container.yPosition(), this.container.zPosition()) > (double)(this.distance * this.distance))) {
            return;
        }
        if (this.node() != null) {
            this.node().sendToReachable("computer.signal", new Object[]{"chat_message", event.username, event.message});
        }
    }

    @Override
    public boolean isValid() {
        return this.node() != null;
    }

    public void onConnect(Node node) {
        super.onConnect(node);
        if (node == this.node()) {
            ChatAPI.registry.registerChatListener(this);
        }
    }

    public void onDisconnect(Node node) {
        super.onDisconnect(node);
        if (node == this.node()) {
            ChatAPI.registry.unregisterChatListener(this);
        }
    }

    public int getDistance() {
        return this.distance;
    }

    public void setDistance(int dist) {
        if (dist > Short.MAX_VALUE) {
            dist = Short.MAX_VALUE;
        }
        this.distance = Math.min(Config.CHATBOX_DISTANCE, dist);
        if (this.distance < 0) {
            this.distance = Config.CHATBOX_DISTANCE;
        }
    }

    @Callback(doc="function():number; Returns the chat distance the chat box is currently set to", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getDistance(Context context, Arguments args) {
        return new Object[]{this.distance};
    }

    @Callback(doc="function(distance:number):number; Sets the distance of the chat box. Returns the new distance", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] setDistance(Context context, Arguments args) {
        this.setDistance(args.checkInteger(0));
        return new Object[]{this.distance};
    }

    @Callback(doc="function():string; Returns the name of the chat box", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getName(Context context, Arguments args) {
        return new Object[]{this.name};
    }

    @Callback(doc="function(name:string):string; Sets the name of the chat box. Returns the new name", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] setName(Context context, Arguments args) {
        this.name = args.checkString(0);
        return new Object[]{this.name};
    }

    @Callback(doc="function(text:string [, distance:number]):boolean; Makes the robot say some text with the currently set or the specified distance. Returns true on success", direct=true, limit=3)
    public Object[] say(Context context, Arguments args) {
        if (args.count() >= 1) {
            int d = this.distance;
            if (args.count() >= 1) {
                if (args.isInteger(1) && (d = Math.min(Config.CHATBOX_DISTANCE, args.checkInteger(1))) <= 0) {
                    d = this.distance;
                }
                if (args.isString(0)) {
                    RobotUpgradeChatBox.sendChatMessage(this.container, d, this.name.length() > 0 ? this.name : Config.CHATBOX_PREFIX, args.checkString(0));
                    return new Object[]{true};
                }
            }
            return new Object[]{false};
        }
        return null;
    }

    public static void sendChatMessage(EnvironmentHost c, int d, String prefix, String string) {
        if (c == null) {
            return;
        }
        ChatBoxUtils.sendChatMessage(c.world(), c.xPosition(), c.yPosition(), c.zPosition(), d, prefix, string);
    }

    public Map<String, String> getDeviceInfo() {
        if (this.deviceInfo == null) {
            this.deviceInfo = new OCUtils.Device("multimedia", "Chat interface", "National Security Agency", "[CLASSIFIED]", new String[0]).deviceInfo();
            return this.deviceInfo;
        }
        return this.deviceInfo;
    }
}

