/*
 * Decompiled with CFR 0.152.
 */
package openmods.geometry;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;

public class BoundingBoxMap<T> {
    private final List<Map.Entry<AxisAlignedBB, T>> entries = Lists.newArrayList();

    public void addBox(AxisAlignedBB aabb, T value) {
        Preconditions.checkNotNull((Object)aabb);
        this.entries.add(Maps.immutableEntry((Object)aabb, value));
    }

    public Map.Entry<AxisAlignedBB, T> findEntryContainingPoint(Vec3 point) {
        for (Map.Entry<AxisAlignedBB, T> e : this.entries) {
            if (!e.getKey().func_72318_a(point)) continue;
            return e;
        }
        return null;
    }

    public void findAllEntriesContainingPoint(Vec3 point, Collection<Map.Entry<AxisAlignedBB, T>> output) {
        for (Map.Entry<AxisAlignedBB, T> e : this.entries) {
            if (!e.getKey().func_72318_a(point)) continue;
            output.add(e);
        }
    }

    public static <T> BoundingBoxMap<T> create() {
        return new BoundingBoxMap<T>();
    }
}

