/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.crossmod.opencomputers;

import appeng.api.parts.IPartHost;
import com.glodblock.github.common.parts.PartFluidInterface;
import com.glodblock.github.common.tile.TileFluidInterface;
import com.glodblock.github.loader.ItemAndBlockHolder;
import com.glodblock.github.util.DualityFluidInterface;
import com.glodblock.github.util.Util;
import li.cil.oc.api.driver.EnvironmentProvider;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.driver.SidedBlock;
import li.cil.oc.api.internal.Database;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Node;
import li.cil.oc.integration.ManagedTileEntityEnvironment;
import li.cil.oc.server.network.Component;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class DriverDualFluidInterface
implements SidedBlock {
    public boolean worksWith(World world, int x, int y, int z, ForgeDirection side) {
        TileEntity te = world.func_147438_o(x, y, z);
        return DriverDualFluidInterface.isDualFluidInterface(te, side);
    }

    public ManagedEnvironment createEnvironment(World world, int x, int y, int z, ForgeDirection side) {
        TileEntity te = world.func_147438_o(x, y, z);
        return new Environment(DriverDualFluidInterface.getInterface(te, side));
    }

    private static boolean isDualFluidInterface(TileEntity te, ForgeDirection face) {
        if (te != null) {
            if (te instanceof TileFluidInterface) {
                return true;
            }
            if (te instanceof IPartHost) {
                return ((IPartHost)te).getPart(face) instanceof PartFluidInterface;
            }
        }
        return false;
    }

    private static DualityFluidInterface getInterface(TileEntity te, ForgeDirection face) {
        if (te != null) {
            if (te instanceof TileFluidInterface) {
                return ((TileFluidInterface)te).getDualityFluid();
            }
            if (te instanceof IPartHost && ((IPartHost)te).getPart(face) instanceof PartFluidInterface) {
                return ((PartFluidInterface)((IPartHost)te).getPart(face)).getDualityFluid();
            }
        }
        return null;
    }

    public static class Environment
    extends ManagedTileEntityEnvironment<DualityFluidInterface>
    implements NamedBlock {
        public Environment(DualityFluidInterface tileEntity) {
            super((Object)tileEntity, "fluid_interface");
        }

        @Callback(doc="function(index:number):table -- Get the configuration of the dual fluid interface on the specified slot.")
        public Object[] getFluidInterfaceConfiguration(Context context, Arguments args) {
            int index = args.checkInteger(0);
            if (index >= 0 && index < 6) {
                FluidStack fluid = ((DualityFluidInterface)this.tileEntity).getConfig().getFluidStackInSlot(index);
                return new Object[]{fluid == null ? null : new FluidStack(fluid.getFluid(), 1000)};
            }
            throw new IllegalArgumentException("invalid slot");
        }

        @Callback(doc="function(index:number[, database:address, entry:number]):boolean -- Configure the filter in fluid interface on the specified slot.")
        public Object[] setFluidInterfaceConfiguration(Context context, Arguments args) {
            int index = args.checkInteger(0);
            if (args.count() != 3) {
                ((DualityFluidInterface)this.tileEntity).getConfig().setFluidInSlot(index, null);
                context.pause(0.5);
                return new Object[]{true};
            }
            String address = args.checkString(1);
            int entry = args.checkInteger(2);
            Node node = this.node().network().node(address);
            if (!(node instanceof Component)) {
                throw new IllegalArgumentException("no such component");
            }
            li.cil.oc.api.network.Environment environment = node.host();
            if (!(environment instanceof Database)) {
                throw new IllegalArgumentException("not a database");
            }
            Database database = (Database)environment;
            if (index >= 0 && index < 6) {
                ItemStack data = database.getStackInSlot(entry - 1);
                if (data == null) {
                    ((DualityFluidInterface)this.tileEntity).getConfig().setFluidInSlot(index, null);
                } else {
                    FluidStack fluid = Util.getFluidFromItem(data);
                    ((DualityFluidInterface)this.tileEntity).getConfig().setFluidInSlot(index, ((DualityFluidInterface)this.tileEntity).getStandardFluid(fluid));
                }
                context.pause(0.5);
                return new Object[]{true};
            }
            throw new IllegalArgumentException("invalid slot");
        }

        public String preferredName() {
            return "fluid_interface";
        }

        public int priority() {
            return 0;
        }
    }

    public static class Provider
    implements EnvironmentProvider {
        Provider() {
        }

        public Class<?> getEnvironment(ItemStack itemStack) {
            if (itemStack != null && (itemStack.func_77969_a(ItemAndBlockHolder.FLUID_INTERFACE.stack()) || itemStack.func_77969_a(ItemAndBlockHolder.INTERFACE.stack()))) {
                return Environment.class;
            }
            return null;
        }
    }
}

