/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.hatch;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.NumericWidget;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.util.GTUtility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.mechanics.pipe.IConnectsToEnergyTunnel;
import tectech.thing.metaTileEntity.hatch.MTEHatchEnergyMulti;
import tectech.util.CommonValues;

public class MTEHatchEnergyTunnel
extends MTEHatchEnergyMulti
implements IConnectsToEnergyTunnel {
    public MTEHatchEnergyTunnel(int aID, String aName, String aNameRegional, int aTier, int aAmp) {
        super(aID, aName, aNameRegional, aTier, 0, new String[]{CommonValues.TEC_MARK_GENERAL, StatCollector.func_74838_a((String)"gt.blockmachines.hatch.energytunnel.desc.0"), StatCollector.func_74838_a((String)"gt.blockmachines.hatch.screwdrivertooltip"), StatCollector.func_74838_a((String)"gt.blockmachines.hatch.energytunnel.desc.1") + ": " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers((long)aAmp * GTValues.V[aTier]) + EnumChatFormatting.RESET + " EU/t"}, aAmp);
    }

    public MTEHatchEnergyTunnel(String aName, int aTier, int aAmp, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aAmp, aDescription, aTextures);
    }

    @Override
    public int getHatchType() {
        return 2;
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI_LASER[this.mTier + 1]};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI_LASER[this.mTier + 1]};
    }

    @Override
    public long getMinimumStoredEU() {
        return GTValues.V[this.mTier];
    }

    @Override
    public long maxEUStore() {
        return GTValues.V[this.mTier] * 24L * (long)this.Amperes;
    }

    @Override
    public boolean isEnetInput() {
        return false;
    }

    @Override
    public MTEHatch.ConnectionType getConnectionType() {
        return MTEHatch.ConnectionType.LASER;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchEnergyTunnel(this.mName, this.mTier, this.Amperes, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.Amperes != this.maxAmperes) {
            aNBT.func_74768_a("amperes", this.Amperes);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        int savedAmperes = aNBT.func_74762_e("amperes");
        if (savedAmperes != 0) {
            this.Amperes = savedAmperes;
        }
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        this.openGui(aPlayer);
        super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ, aTool);
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        int x = this.getGUIWidth() / 2 - 37;
        int y = this.getGUIHeight() / 5 - 7;
        ((ModularWindow.Builder)builder.widget(TextWidget.localised((String)"GT5U.machines.laser_hatch.amperage", (Object[])new Object[0]).setPos(x, y).setSize(74, 14))).widget(new NumericWidget().setSetter(val -> {
            this.Amperes = (int)val;
        }).setGetter(() -> this.Amperes).setBounds(1.0, (double)this.maxAmperes).setScrollValues(1.0, 4.0, 64.0).setTextAlignment(Alignment.Center).setTextColor(Color.WHITE.normal).setSize(70, 18).setPos(x, y + 16).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}));
    }

    @Override
    public boolean canConnect(ForgeDirection side) {
        return this.isInputFacing(side);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        byte Tick;
        if (aBaseMetaTileEntity.isServerSide() && 16 == (Tick = (byte)(aTick % 20L)) && aBaseMetaTileEntity.getStoredEU() > 0L) {
            this.setEUVar(aBaseMetaTileEntity.getStoredEU() - (long)this.Amperes);
            if (aBaseMetaTileEntity.getStoredEU() < 0L) {
                this.setEUVar(0L);
            }
        }
    }
}

